// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Contains encryption settings for a data disk image.
 */
@Fluent
public final class DataDiskImageEncryption extends DiskImageEncryption {
    /*
     * This property specifies the logical unit number of the data disk. This value is used to identify data disks
     * within the Virtual Machine and therefore must be unique for each data disk attached to the Virtual Machine.
     */
    private int lun;

    /**
     * Creates an instance of DataDiskImageEncryption class.
     */
    public DataDiskImageEncryption() {
    }

    /**
     * Get the lun property: This property specifies the logical unit number of the data disk. This value is used to
     * identify data disks within the Virtual Machine and therefore must be unique for each data disk attached to the
     * Virtual Machine.
     * 
     * @return the lun value.
     */
    public int lun() {
        return this.lun;
    }

    /**
     * Set the lun property: This property specifies the logical unit number of the data disk. This value is used to
     * identify data disks within the Virtual Machine and therefore must be unique for each data disk attached to the
     * Virtual Machine.
     * 
     * @param lun the lun value to set.
     * @return the DataDiskImageEncryption object itself.
     */
    public DataDiskImageEncryption withLun(int lun) {
        this.lun = lun;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public DataDiskImageEncryption withDiskEncryptionSetId(String diskEncryptionSetId) {
        super.withDiskEncryptionSetId(diskEncryptionSetId);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        super.validate();
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("diskEncryptionSetId", diskEncryptionSetId());
        jsonWriter.writeIntField("lun", this.lun);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DataDiskImageEncryption from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DataDiskImageEncryption if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the DataDiskImageEncryption.
     */
    public static DataDiskImageEncryption fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DataDiskImageEncryption deserializedDataDiskImageEncryption = new DataDiskImageEncryption();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("diskEncryptionSetId".equals(fieldName)) {
                    deserializedDataDiskImageEncryption.withDiskEncryptionSetId(reader.getString());
                } else if ("lun".equals(fieldName)) {
                    deserializedDataDiskImageEncryption.lun = reader.getInt();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDataDiskImageEncryption;
        });
    }
}
