// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Describes the data disk to be attached.
 */
@Fluent
public final class DataDisksToAttach implements JsonSerializable<DataDisksToAttach> {
    /*
     * ID of the managed data disk.
     */
    private String diskId;

    /*
     * The logical unit number of the data disk. This value is used to identify data disks within the VM and therefore
     * must be unique for each data disk attached to a VM. If not specified, lun would be auto assigned.
     */
    private Integer lun;

    /*
     * Specifies the caching requirements. Possible values are: **None,** **ReadOnly,** **ReadWrite.** The defaulting
     * behavior is: **None for Standard storage. ReadOnly for Premium storage.**
     */
    private CachingTypes caching;

    /*
     * Specifies whether data disk should be deleted or detached upon VM deletion. Possible values are: **Delete.** If
     * this value is used, the data disk is deleted when VM is deleted. **Detach.** If this value is used, the data disk
     * is retained after VM is deleted. The default value is set to **Detach**.
     */
    private DiskDeleteOptionTypes deleteOption;

    /*
     * Specifies the customer managed disk encryption set resource id for the managed disk.
     */
    private DiskEncryptionSetParameters diskEncryptionSet;

    /*
     * Specifies whether writeAccelerator should be enabled or disabled on the disk.
     */
    private Boolean writeAcceleratorEnabled;

    /**
     * Creates an instance of DataDisksToAttach class.
     */
    public DataDisksToAttach() {
    }

    /**
     * Get the diskId property: ID of the managed data disk.
     * 
     * @return the diskId value.
     */
    public String diskId() {
        return this.diskId;
    }

    /**
     * Set the diskId property: ID of the managed data disk.
     * 
     * @param diskId the diskId value to set.
     * @return the DataDisksToAttach object itself.
     */
    public DataDisksToAttach withDiskId(String diskId) {
        this.diskId = diskId;
        return this;
    }

    /**
     * Get the lun property: The logical unit number of the data disk. This value is used to identify data disks within
     * the VM and therefore must be unique for each data disk attached to a VM. If not specified, lun would be auto
     * assigned.
     * 
     * @return the lun value.
     */
    public Integer lun() {
        return this.lun;
    }

    /**
     * Set the lun property: The logical unit number of the data disk. This value is used to identify data disks within
     * the VM and therefore must be unique for each data disk attached to a VM. If not specified, lun would be auto
     * assigned.
     * 
     * @param lun the lun value to set.
     * @return the DataDisksToAttach object itself.
     */
    public DataDisksToAttach withLun(Integer lun) {
        this.lun = lun;
        return this;
    }

    /**
     * Get the caching property: Specifies the caching requirements. Possible values are: **None,** **ReadOnly,**
     * **ReadWrite.** The defaulting behavior is: **None for Standard storage. ReadOnly for Premium storage.**.
     * 
     * @return the caching value.
     */
    public CachingTypes caching() {
        return this.caching;
    }

    /**
     * Set the caching property: Specifies the caching requirements. Possible values are: **None,** **ReadOnly,**
     * **ReadWrite.** The defaulting behavior is: **None for Standard storage. ReadOnly for Premium storage.**.
     * 
     * @param caching the caching value to set.
     * @return the DataDisksToAttach object itself.
     */
    public DataDisksToAttach withCaching(CachingTypes caching) {
        this.caching = caching;
        return this;
    }

    /**
     * Get the deleteOption property: Specifies whether data disk should be deleted or detached upon VM deletion.
     * Possible values are: **Delete.** If this value is used, the data disk is deleted when VM is deleted. **Detach.**
     * If this value is used, the data disk is retained after VM is deleted. The default value is set to **Detach**.
     * 
     * @return the deleteOption value.
     */
    public DiskDeleteOptionTypes deleteOption() {
        return this.deleteOption;
    }

    /**
     * Set the deleteOption property: Specifies whether data disk should be deleted or detached upon VM deletion.
     * Possible values are: **Delete.** If this value is used, the data disk is deleted when VM is deleted. **Detach.**
     * If this value is used, the data disk is retained after VM is deleted. The default value is set to **Detach**.
     * 
     * @param deleteOption the deleteOption value to set.
     * @return the DataDisksToAttach object itself.
     */
    public DataDisksToAttach withDeleteOption(DiskDeleteOptionTypes deleteOption) {
        this.deleteOption = deleteOption;
        return this;
    }

    /**
     * Get the diskEncryptionSet property: Specifies the customer managed disk encryption set resource id for the
     * managed disk.
     * 
     * @return the diskEncryptionSet value.
     */
    public DiskEncryptionSetParameters diskEncryptionSet() {
        return this.diskEncryptionSet;
    }

    /**
     * Set the diskEncryptionSet property: Specifies the customer managed disk encryption set resource id for the
     * managed disk.
     * 
     * @param diskEncryptionSet the diskEncryptionSet value to set.
     * @return the DataDisksToAttach object itself.
     */
    public DataDisksToAttach withDiskEncryptionSet(DiskEncryptionSetParameters diskEncryptionSet) {
        this.diskEncryptionSet = diskEncryptionSet;
        return this;
    }

    /**
     * Get the writeAcceleratorEnabled property: Specifies whether writeAccelerator should be enabled or disabled on the
     * disk.
     * 
     * @return the writeAcceleratorEnabled value.
     */
    public Boolean writeAcceleratorEnabled() {
        return this.writeAcceleratorEnabled;
    }

    /**
     * Set the writeAcceleratorEnabled property: Specifies whether writeAccelerator should be enabled or disabled on the
     * disk.
     * 
     * @param writeAcceleratorEnabled the writeAcceleratorEnabled value to set.
     * @return the DataDisksToAttach object itself.
     */
    public DataDisksToAttach withWriteAcceleratorEnabled(Boolean writeAcceleratorEnabled) {
        this.writeAcceleratorEnabled = writeAcceleratorEnabled;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (diskId() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property diskId in model DataDisksToAttach"));
        }
        if (diskEncryptionSet() != null) {
            diskEncryptionSet().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(DataDisksToAttach.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("diskId", this.diskId);
        jsonWriter.writeNumberField("lun", this.lun);
        jsonWriter.writeStringField("caching", this.caching == null ? null : this.caching.toString());
        jsonWriter.writeStringField("deleteOption", this.deleteOption == null ? null : this.deleteOption.toString());
        jsonWriter.writeJsonField("diskEncryptionSet", this.diskEncryptionSet);
        jsonWriter.writeBooleanField("writeAcceleratorEnabled", this.writeAcceleratorEnabled);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DataDisksToAttach from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DataDisksToAttach if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the DataDisksToAttach.
     */
    public static DataDisksToAttach fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DataDisksToAttach deserializedDataDisksToAttach = new DataDisksToAttach();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("diskId".equals(fieldName)) {
                    deserializedDataDisksToAttach.diskId = reader.getString();
                } else if ("lun".equals(fieldName)) {
                    deserializedDataDisksToAttach.lun = reader.getNullable(JsonReader::getInt);
                } else if ("caching".equals(fieldName)) {
                    deserializedDataDisksToAttach.caching = CachingTypes.fromString(reader.getString());
                } else if ("deleteOption".equals(fieldName)) {
                    deserializedDataDisksToAttach.deleteOption = DiskDeleteOptionTypes.fromString(reader.getString());
                } else if ("diskEncryptionSet".equals(fieldName)) {
                    deserializedDataDisksToAttach.diskEncryptionSet = DiskEncryptionSetParameters.fromJson(reader);
                } else if ("writeAcceleratorEnabled".equals(fieldName)) {
                    deserializedDataDisksToAttach.writeAcceleratorEnabled = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDataDisksToAttach;
        });
    }
}
