// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Describes a reference to Key Vault Secret.
 */
@Fluent
public final class KeyVaultSecretReference implements JsonSerializable<KeyVaultSecretReference> {
    /*
     * The URL referencing a secret in a Key Vault.
     */
    private String secretUrl;

    /*
     * The relative URL of the Key Vault containing the secret.
     */
    private SubResource sourceVault;

    /**
     * Creates an instance of KeyVaultSecretReference class.
     */
    public KeyVaultSecretReference() {
    }

    /**
     * Get the secretUrl property: The URL referencing a secret in a Key Vault.
     * 
     * @return the secretUrl value.
     */
    public String secretUrl() {
        return this.secretUrl;
    }

    /**
     * Set the secretUrl property: The URL referencing a secret in a Key Vault.
     * 
     * @param secretUrl the secretUrl value to set.
     * @return the KeyVaultSecretReference object itself.
     */
    public KeyVaultSecretReference withSecretUrl(String secretUrl) {
        this.secretUrl = secretUrl;
        return this;
    }

    /**
     * Get the sourceVault property: The relative URL of the Key Vault containing the secret.
     * 
     * @return the sourceVault value.
     */
    public SubResource sourceVault() {
        return this.sourceVault;
    }

    /**
     * Set the sourceVault property: The relative URL of the Key Vault containing the secret.
     * 
     * @param sourceVault the sourceVault value to set.
     * @return the KeyVaultSecretReference object itself.
     */
    public KeyVaultSecretReference withSourceVault(SubResource sourceVault) {
        this.sourceVault = sourceVault;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (secretUrl() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property secretUrl in model KeyVaultSecretReference"));
        }
        if (sourceVault() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property sourceVault in model KeyVaultSecretReference"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(KeyVaultSecretReference.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("secretUrl", this.secretUrl);
        jsonWriter.writeJsonField("sourceVault", this.sourceVault);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of KeyVaultSecretReference from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of KeyVaultSecretReference if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the KeyVaultSecretReference.
     */
    public static KeyVaultSecretReference fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            KeyVaultSecretReference deserializedKeyVaultSecretReference = new KeyVaultSecretReference();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("secretUrl".equals(fieldName)) {
                    deserializedKeyVaultSecretReference.secretUrl = reader.getString();
                } else if ("sourceVault".equals(fieldName)) {
                    deserializedKeyVaultSecretReference.sourceVault = SubResource.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedKeyVaultSecretReference;
        });
    }
}
