// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Properties of the disk for which update is pending.
 */
@Fluent
public final class PropertyUpdatesInProgress implements JsonSerializable<PropertyUpdatesInProgress> {
    /*
     * The target performance tier of the disk if a tier change operation is in progress.
     */
    private String targetTier;

    /**
     * Creates an instance of PropertyUpdatesInProgress class.
     */
    public PropertyUpdatesInProgress() {
    }

    /**
     * Get the targetTier property: The target performance tier of the disk if a tier change operation is in progress.
     * 
     * @return the targetTier value.
     */
    public String targetTier() {
        return this.targetTier;
    }

    /**
     * Set the targetTier property: The target performance tier of the disk if a tier change operation is in progress.
     * 
     * @param targetTier the targetTier value to set.
     * @return the PropertyUpdatesInProgress object itself.
     */
    public PropertyUpdatesInProgress withTargetTier(String targetTier) {
        this.targetTier = targetTier;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("targetTier", this.targetTier);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of PropertyUpdatesInProgress from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of PropertyUpdatesInProgress if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the PropertyUpdatesInProgress.
     */
    public static PropertyUpdatesInProgress fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            PropertyUpdatesInProgress deserializedPropertyUpdatesInProgress = new PropertyUpdatesInProgress();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("targetTier".equals(fieldName)) {
                    deserializedPropertyUpdatesInProgress.targetTier = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedPropertyUpdatesInProgress;
        });
    }
}
