// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Describes the storage profile.
 */
@Fluent
public final class RestorePointSourceVMStorageProfile implements JsonSerializable<RestorePointSourceVMStorageProfile> {
    /*
     * Gets the OS disk of the VM captured at the time of the restore point creation.
     */
    private RestorePointSourceVmosDisk osDisk;

    /*
     * Gets the data disks of the VM captured at the time of the restore point creation.
     */
    private List<RestorePointSourceVMDataDisk> dataDisks;

    /*
     * Gets the disk controller type of the VM captured at the time of the restore point creation.
     */
    private DiskControllerTypes diskControllerType;

    /**
     * Creates an instance of RestorePointSourceVMStorageProfile class.
     */
    public RestorePointSourceVMStorageProfile() {
    }

    /**
     * Get the osDisk property: Gets the OS disk of the VM captured at the time of the restore point creation.
     * 
     * @return the osDisk value.
     */
    public RestorePointSourceVmosDisk osDisk() {
        return this.osDisk;
    }

    /**
     * Set the osDisk property: Gets the OS disk of the VM captured at the time of the restore point creation.
     * 
     * @param osDisk the osDisk value to set.
     * @return the RestorePointSourceVMStorageProfile object itself.
     */
    public RestorePointSourceVMStorageProfile withOsDisk(RestorePointSourceVmosDisk osDisk) {
        this.osDisk = osDisk;
        return this;
    }

    /**
     * Get the dataDisks property: Gets the data disks of the VM captured at the time of the restore point creation.
     * 
     * @return the dataDisks value.
     */
    public List<RestorePointSourceVMDataDisk> dataDisks() {
        return this.dataDisks;
    }

    /**
     * Set the dataDisks property: Gets the data disks of the VM captured at the time of the restore point creation.
     * 
     * @param dataDisks the dataDisks value to set.
     * @return the RestorePointSourceVMStorageProfile object itself.
     */
    public RestorePointSourceVMStorageProfile withDataDisks(List<RestorePointSourceVMDataDisk> dataDisks) {
        this.dataDisks = dataDisks;
        return this;
    }

    /**
     * Get the diskControllerType property: Gets the disk controller type of the VM captured at the time of the restore
     * point creation.
     * 
     * @return the diskControllerType value.
     */
    public DiskControllerTypes diskControllerType() {
        return this.diskControllerType;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (osDisk() != null) {
            osDisk().validate();
        }
        if (dataDisks() != null) {
            dataDisks().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("osDisk", this.osDisk);
        jsonWriter.writeArrayField("dataDisks", this.dataDisks, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RestorePointSourceVMStorageProfile from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RestorePointSourceVMStorageProfile if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the RestorePointSourceVMStorageProfile.
     */
    public static RestorePointSourceVMStorageProfile fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RestorePointSourceVMStorageProfile deserializedRestorePointSourceVMStorageProfile
                = new RestorePointSourceVMStorageProfile();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("osDisk".equals(fieldName)) {
                    deserializedRestorePointSourceVMStorageProfile.osDisk = RestorePointSourceVmosDisk.fromJson(reader);
                } else if ("dataDisks".equals(fieldName)) {
                    List<RestorePointSourceVMDataDisk> dataDisks
                        = reader.readArray(reader1 -> RestorePointSourceVMDataDisk.fromJson(reader1));
                    deserializedRestorePointSourceVMStorageProfile.dataDisks = dataDisks;
                } else if ("diskControllerType".equals(fieldName)) {
                    deserializedRestorePointSourceVMStorageProfile.diskControllerType
                        = DiskControllerTypes.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRestorePointSourceVMStorageProfile;
        });
    }
}
