/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.fluent.models;

import com.azure.core.management.Resource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.fluent.models.GalleryApplicationVersionProperties;
import com.azure.resourcemanager.compute.models.GalleryApplicationVersionPublishingProfile;
import com.azure.resourcemanager.compute.models.GalleryApplicationVersionSafetyProfile;
import com.azure.resourcemanager.compute.models.GalleryProvisioningState;
import com.azure.resourcemanager.compute.models.ReplicationStatus;
import java.io.IOException;
import java.util.Map;

public final class GalleryApplicationVersionInner
extends Resource {
    private GalleryApplicationVersionProperties innerProperties;
    private String id;
    private String name;
    private String type;

    private GalleryApplicationVersionProperties innerProperties() {
        return this.innerProperties;
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return this.type;
    }

    public GalleryApplicationVersionInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public GalleryApplicationVersionInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public GalleryApplicationVersionPublishingProfile publishingProfile() {
        return this.innerProperties() == null ? null : this.innerProperties().publishingProfile();
    }

    public GalleryApplicationVersionInner withPublishingProfile(GalleryApplicationVersionPublishingProfile publishingProfile) {
        if (this.innerProperties() == null) {
            this.innerProperties = new GalleryApplicationVersionProperties();
        }
        this.innerProperties().withPublishingProfile(publishingProfile);
        return this;
    }

    public GalleryApplicationVersionSafetyProfile safetyProfile() {
        return this.innerProperties() == null ? null : this.innerProperties().safetyProfile();
    }

    public GalleryApplicationVersionInner withSafetyProfile(GalleryApplicationVersionSafetyProfile safetyProfile) {
        if (this.innerProperties() == null) {
            this.innerProperties = new GalleryApplicationVersionProperties();
        }
        this.innerProperties().withSafetyProfile(safetyProfile);
        return this;
    }

    public GalleryProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public ReplicationStatus replicationStatus() {
        return this.innerProperties() == null ? null : this.innerProperties().replicationStatus();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static GalleryApplicationVersionInner fromJson(JsonReader jsonReader) throws IOException {
        return (GalleryApplicationVersionInner)((Object)jsonReader.readObject(reader -> {
            GalleryApplicationVersionInner deserializedGalleryApplicationVersionInner = new GalleryApplicationVersionInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedGalleryApplicationVersionInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedGalleryApplicationVersionInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedGalleryApplicationVersionInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedGalleryApplicationVersionInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedGalleryApplicationVersionInner.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedGalleryApplicationVersionInner.innerProperties = GalleryApplicationVersionProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedGalleryApplicationVersionInner;
        }));
    }
}

