/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.fluent.models.ImageProperties;
import com.azure.resourcemanager.compute.models.ExtendedLocation;
import com.azure.resourcemanager.compute.models.HyperVGenerationTypes;
import com.azure.resourcemanager.compute.models.ImageStorageProfile;
import java.io.IOException;
import java.util.Map;

public final class ImageInner
extends Resource {
    private ImageProperties innerProperties;
    private ExtendedLocation extendedLocation;
    private String id;
    private String name;
    private String type;

    private ImageProperties innerProperties() {
        return this.innerProperties;
    }

    public ExtendedLocation extendedLocation() {
        return this.extendedLocation;
    }

    public ImageInner withExtendedLocation(ExtendedLocation extendedLocation) {
        this.extendedLocation = extendedLocation;
        return this;
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return this.type;
    }

    public ImageInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public ImageInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public SubResource sourceVirtualMachine() {
        return this.innerProperties() == null ? null : this.innerProperties().sourceVirtualMachine();
    }

    public ImageInner withSourceVirtualMachine(SubResource sourceVirtualMachine) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ImageProperties();
        }
        this.innerProperties().withSourceVirtualMachine(sourceVirtualMachine);
        return this;
    }

    public ImageStorageProfile storageProfile() {
        return this.innerProperties() == null ? null : this.innerProperties().storageProfile();
    }

    public ImageInner withStorageProfile(ImageStorageProfile storageProfile) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ImageProperties();
        }
        this.innerProperties().withStorageProfile(storageProfile);
        return this;
    }

    public String provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public HyperVGenerationTypes hyperVGeneration() {
        return this.innerProperties() == null ? null : this.innerProperties().hyperVGeneration();
    }

    public ImageInner withHyperVGeneration(HyperVGenerationTypes hyperVGeneration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ImageProperties();
        }
        this.innerProperties().withHyperVGeneration(hyperVGeneration);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
        if (this.extendedLocation() != null) {
            this.extendedLocation().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        jsonWriter.writeJsonField("extendedLocation", (JsonSerializable)this.extendedLocation);
        return jsonWriter.writeEndObject();
    }

    public static ImageInner fromJson(JsonReader jsonReader) throws IOException {
        return (ImageInner)((Object)jsonReader.readObject(reader -> {
            ImageInner deserializedImageInner = new ImageInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedImageInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedImageInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedImageInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedImageInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedImageInner.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedImageInner.innerProperties = ImageProperties.fromJson(reader);
                    continue;
                }
                if ("extendedLocation".equals(fieldName)) {
                    deserializedImageInner.extendedLocation = ExtendedLocation.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedImageInner;
        }));
    }
}

