/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.fluent.models.RunCommandDocumentBaseInner;
import com.azure.resourcemanager.compute.models.OperatingSystemTypes;
import com.azure.resourcemanager.compute.models.RunCommandParameterDefinition;
import java.io.IOException;
import java.util.List;

public final class RunCommandDocumentInner
extends RunCommandDocumentBaseInner {
    private List<String> script;
    private List<RunCommandParameterDefinition> parameters;
    private static final ClientLogger LOGGER = new ClientLogger(RunCommandDocumentInner.class);

    public List<String> script() {
        return this.script;
    }

    public RunCommandDocumentInner withScript(List<String> script) {
        this.script = script;
        return this;
    }

    public List<RunCommandParameterDefinition> parameters() {
        return this.parameters;
    }

    public RunCommandDocumentInner withParameters(List<RunCommandParameterDefinition> parameters) {
        this.parameters = parameters;
        return this;
    }

    @Override
    public RunCommandDocumentInner withSchema(String schema) {
        super.withSchema(schema);
        return this;
    }

    @Override
    public RunCommandDocumentInner withId(String id) {
        super.withId(id);
        return this;
    }

    @Override
    public RunCommandDocumentInner withOsType(OperatingSystemTypes osType) {
        super.withOsType(osType);
        return this;
    }

    @Override
    public RunCommandDocumentInner withLabel(String label) {
        super.withLabel(label);
        return this;
    }

    @Override
    public RunCommandDocumentInner withDescription(String description) {
        super.withDescription(description);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.script() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property script in model RunCommandDocumentInner"));
        }
        if (this.parameters() != null) {
            this.parameters().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("$schema", this.schema());
        jsonWriter.writeStringField("id", this.id());
        jsonWriter.writeStringField("osType", this.osType() == null ? null : this.osType().toString());
        jsonWriter.writeStringField("label", this.label());
        jsonWriter.writeStringField("description", this.description());
        jsonWriter.writeArrayField("script", this.script, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("parameters", this.parameters, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static RunCommandDocumentInner fromJson(JsonReader jsonReader) throws IOException {
        return (RunCommandDocumentInner)jsonReader.readObject(reader -> {
            RunCommandDocumentInner deserializedRunCommandDocumentInner = new RunCommandDocumentInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("$schema".equals(fieldName)) {
                    deserializedRunCommandDocumentInner.withSchema(reader.getString());
                    continue;
                }
                if ("id".equals(fieldName)) {
                    deserializedRunCommandDocumentInner.withId(reader.getString());
                    continue;
                }
                if ("osType".equals(fieldName)) {
                    deserializedRunCommandDocumentInner.withOsType(OperatingSystemTypes.fromString(reader.getString()));
                    continue;
                }
                if ("label".equals(fieldName)) {
                    deserializedRunCommandDocumentInner.withLabel(reader.getString());
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedRunCommandDocumentInner.withDescription(reader.getString());
                    continue;
                }
                if ("script".equals(fieldName)) {
                    List script;
                    deserializedRunCommandDocumentInner.script = script = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    List parameters;
                    deserializedRunCommandDocumentInner.parameters = parameters = reader.readArray(reader1 -> RunCommandParameterDefinition.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRunCommandDocumentInner;
        });
    }
}

