/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.implementation;

import com.azure.core.http.HttpPipeline;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.management.AzureEnvironment;
import com.azure.core.management.Resource;
import com.azure.core.management.SubResource;
import com.azure.core.management.provider.IdentifierProvider;
import com.azure.core.management.serializer.SerializerFactory;
import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.core.util.serializer.SerializerEncoding;
import com.azure.resourcemanager.authorization.AuthorizationManager;
import com.azure.resourcemanager.authorization.models.BuiltInRole;
import com.azure.resourcemanager.authorization.utils.RoleAssignmentHelper;
import com.azure.resourcemanager.compute.ComputeManager;
import com.azure.resourcemanager.compute.fluent.ComputeManagementClient;
import com.azure.resourcemanager.compute.fluent.models.ProximityPlacementGroupInner;
import com.azure.resourcemanager.compute.fluent.models.VirtualMachineCaptureResultInner;
import com.azure.resourcemanager.compute.fluent.models.VirtualMachineInner;
import com.azure.resourcemanager.compute.fluent.models.VirtualMachineUpdateInner;
import com.azure.resourcemanager.compute.implementation.ProximityPlacementGroupImpl;
import com.azure.resourcemanager.compute.implementation.UnmanagedDataDiskImpl;
import com.azure.resourcemanager.compute.implementation.VirtualMachineDataDiskImpl;
import com.azure.resourcemanager.compute.implementation.VirtualMachineEncryptionImpl;
import com.azure.resourcemanager.compute.implementation.VirtualMachineExtensionImpl;
import com.azure.resourcemanager.compute.implementation.VirtualMachineExtensionsImpl;
import com.azure.resourcemanager.compute.implementation.VirtualMachineInstanceViewImpl;
import com.azure.resourcemanager.compute.implementation.VirtualMachineMsiHandler;
import com.azure.resourcemanager.compute.implementation.VirtualMachineSizeImpl;
import com.azure.resourcemanager.compute.models.AdditionalCapabilities;
import com.azure.resourcemanager.compute.models.AvailabilitySet;
import com.azure.resourcemanager.compute.models.AvailabilitySetSkuTypes;
import com.azure.resourcemanager.compute.models.BillingProfile;
import com.azure.resourcemanager.compute.models.BootDiagnostics;
import com.azure.resourcemanager.compute.models.CachingTypes;
import com.azure.resourcemanager.compute.models.DataDisk;
import com.azure.resourcemanager.compute.models.DeleteOptions;
import com.azure.resourcemanager.compute.models.DiagnosticsProfile;
import com.azure.resourcemanager.compute.models.DiffDiskOptions;
import com.azure.resourcemanager.compute.models.DiffDiskPlacement;
import com.azure.resourcemanager.compute.models.DiffDiskSettings;
import com.azure.resourcemanager.compute.models.Disk;
import com.azure.resourcemanager.compute.models.DiskCreateOptionTypes;
import com.azure.resourcemanager.compute.models.DiskDeleteOptionTypes;
import com.azure.resourcemanager.compute.models.DiskEncryptionSetParameters;
import com.azure.resourcemanager.compute.models.DiskEncryptionSettings;
import com.azure.resourcemanager.compute.models.HardwareProfile;
import com.azure.resourcemanager.compute.models.ImageReference;
import com.azure.resourcemanager.compute.models.InstanceViewTypes;
import com.azure.resourcemanager.compute.models.KnownLinuxVirtualMachineImage;
import com.azure.resourcemanager.compute.models.KnownWindowsVirtualMachineImage;
import com.azure.resourcemanager.compute.models.LinuxConfiguration;
import com.azure.resourcemanager.compute.models.ManagedDiskParameters;
import com.azure.resourcemanager.compute.models.NetworkInterfaceReference;
import com.azure.resourcemanager.compute.models.OSDisk;
import com.azure.resourcemanager.compute.models.OSProfile;
import com.azure.resourcemanager.compute.models.OperatingSystemTypes;
import com.azure.resourcemanager.compute.models.Plan;
import com.azure.resourcemanager.compute.models.PowerState;
import com.azure.resourcemanager.compute.models.ProximityPlacementGroup;
import com.azure.resourcemanager.compute.models.ProximityPlacementGroupType;
import com.azure.resourcemanager.compute.models.PurchasePlan;
import com.azure.resourcemanager.compute.models.ResourceIdentityType;
import com.azure.resourcemanager.compute.models.RunCommandInput;
import com.azure.resourcemanager.compute.models.RunCommandInputParameter;
import com.azure.resourcemanager.compute.models.RunCommandResult;
import com.azure.resourcemanager.compute.models.SecurityProfile;
import com.azure.resourcemanager.compute.models.SecurityTypes;
import com.azure.resourcemanager.compute.models.SshConfiguration;
import com.azure.resourcemanager.compute.models.SshPublicKey;
import com.azure.resourcemanager.compute.models.StorageAccountTypes;
import com.azure.resourcemanager.compute.models.StorageProfile;
import com.azure.resourcemanager.compute.models.UefiSettings;
import com.azure.resourcemanager.compute.models.VirtualHardDisk;
import com.azure.resourcemanager.compute.models.VirtualMachine;
import com.azure.resourcemanager.compute.models.VirtualMachineCaptureParameters;
import com.azure.resourcemanager.compute.models.VirtualMachineDataDisk;
import com.azure.resourcemanager.compute.models.VirtualMachineDiskOptions;
import com.azure.resourcemanager.compute.models.VirtualMachineEncryption;
import com.azure.resourcemanager.compute.models.VirtualMachineEvictionPolicyTypes;
import com.azure.resourcemanager.compute.models.VirtualMachineExtension;
import com.azure.resourcemanager.compute.models.VirtualMachineIdentity;
import com.azure.resourcemanager.compute.models.VirtualMachineInstanceView;
import com.azure.resourcemanager.compute.models.VirtualMachinePriorityTypes;
import com.azure.resourcemanager.compute.models.VirtualMachineScaleSet;
import com.azure.resourcemanager.compute.models.VirtualMachineSize;
import com.azure.resourcemanager.compute.models.VirtualMachineSizeTypes;
import com.azure.resourcemanager.compute.models.VirtualMachineUnmanagedDataDisk;
import com.azure.resourcemanager.compute.models.WinRMConfiguration;
import com.azure.resourcemanager.compute.models.WinRMListener;
import com.azure.resourcemanager.compute.models.WindowsConfiguration;
import com.azure.resourcemanager.msi.models.Identity;
import com.azure.resourcemanager.network.NetworkManager;
import com.azure.resourcemanager.network.models.Network;
import com.azure.resourcemanager.network.models.NetworkInterface;
import com.azure.resourcemanager.network.models.PublicIPSkuType;
import com.azure.resourcemanager.network.models.PublicIpAddress;
import com.azure.resourcemanager.resources.fluentcore.arm.AvailabilityZoneId;
import com.azure.resourcemanager.resources.fluentcore.arm.Manager;
import com.azure.resourcemanager.resources.fluentcore.arm.ResourceId;
import com.azure.resourcemanager.resources.fluentcore.arm.ResourceUtils;
import com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.GroupableResourceImpl;
import com.azure.resourcemanager.resources.fluentcore.model.Accepted;
import com.azure.resourcemanager.resources.fluentcore.model.Creatable;
import com.azure.resourcemanager.resources.fluentcore.model.implementation.AcceptedImpl;
import com.azure.resourcemanager.resources.fluentcore.utils.PagedConverter;
import com.azure.resourcemanager.resources.fluentcore.utils.ResourceManagerUtils;
import com.azure.resourcemanager.storage.StorageManager;
import com.azure.resourcemanager.storage.models.StorageAccount;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class VirtualMachineImpl
extends GroupableResourceImpl<VirtualMachine, VirtualMachineInner, VirtualMachineImpl, ComputeManager>
implements VirtualMachine,
VirtualMachine.DefinitionManagedOrUnmanaged,
VirtualMachine.DefinitionManaged,
VirtualMachine.DefinitionUnmanaged,
VirtualMachine.Update,
VirtualMachine.DefinitionStages.WithSystemAssignedIdentityBasedAccessOrCreate,
VirtualMachine.UpdateStages.WithSystemAssignedIdentityBasedAccessOrUpdate {
    private final ClientLogger logger = new ClientLogger(VirtualMachineImpl.class);
    private final StorageManager storageManager;
    private final NetworkManager networkManager;
    private final AuthorizationManager authorizationManager;
    private final String vmName;
    private final IdentifierProvider namer;
    private String creatableStorageAccountKey;
    private String creatableAvailabilitySetKey;
    private String creatablePrimaryNetworkInterfaceKey;
    private List<String> creatableSecondaryNetworkInterfaceKeys;
    private StorageAccount existingStorageAccountToAssociate;
    private AvailabilitySet existingAvailabilitySetToAssociate;
    private NetworkInterface existingPrimaryNetworkInterfaceToAssociate;
    private List<NetworkInterface> existingSecondaryNetworkInterfacesToAssociate;
    private VirtualMachineInstanceView virtualMachineInstanceView;
    private boolean isMarketplaceLinuxImage;
    private NetworkInterface.DefinitionStages.WithPrimaryPrivateIP nicDefinitionWithPrivateIp;
    private NetworkInterface.DefinitionStages.WithPrimaryNetworkSubnet nicDefinitionWithSubnet;
    private NetworkInterface.DefinitionStages.WithCreate nicDefinitionWithCreate;
    private VirtualMachineExtensionsImpl virtualMachineExtensions;
    private boolean isUnmanagedDiskSelected;
    private List<VirtualMachineUnmanagedDataDisk> unmanagedDataDisks;
    private final ManagedDataDiskCollection managedDataDisks;
    private final BootDiagnosticsHandler bootDiagnosticsHandler;
    private VirtualMachineMsiHandler virtualMachineMsiHandler;
    private PublicIpAddress.DefinitionStages.WithCreate implicitPipCreatable;
    private String newProximityPlacementGroupName;
    private ProximityPlacementGroupType newProximityPlacementGroupType;
    private boolean removeOsProfile;
    private DeleteOptions primaryNetworkInterfaceDeleteOptions;
    private final Map<String, DeleteOptions> secondaryNetworkInterfaceDeleteOptions = new HashMap<String, DeleteOptions>();
    private VirtualMachineUpdateInner updateParameterSnapshotOnUpdate;
    private static final SerializerAdapter SERIALIZER_ADAPTER = SerializerFactory.createDefaultManagementSerializerAdapter();

    VirtualMachineImpl(String name, VirtualMachineInner innerModel, ComputeManager computeManager, StorageManager storageManager, NetworkManager networkManager, AuthorizationManager authorizationManager) {
        super(name, (Resource)innerModel, (Manager)computeManager);
        this.storageManager = storageManager;
        this.networkManager = networkManager;
        this.authorizationManager = authorizationManager;
        this.vmName = name;
        this.isMarketplaceLinuxImage = false;
        this.namer = ((ComputeManager)this.manager()).resourceManager().internalContext().createIdentifierProvider(this.vmName);
        this.creatableSecondaryNetworkInterfaceKeys = new ArrayList<String>();
        this.existingSecondaryNetworkInterfacesToAssociate = new ArrayList<NetworkInterface>();
        this.virtualMachineExtensions = new VirtualMachineExtensionsImpl(((ComputeManagementClient)computeManager.serviceClient()).getVirtualMachineExtensions(), this);
        this.managedDataDisks = new ManagedDataDiskCollection(this);
        this.initializeDataDisks();
        this.bootDiagnosticsHandler = new BootDiagnosticsHandler(this);
        this.virtualMachineMsiHandler = new VirtualMachineMsiHandler(authorizationManager, this);
        this.newProximityPlacementGroupName = null;
        this.newProximityPlacementGroupType = null;
    }

    public VirtualMachineImpl update() {
        this.updateParameterSnapshotOnUpdate = this.deepCopyInnerToUpdateParameter();
        return (VirtualMachineImpl)super.update();
    }

    public Mono<VirtualMachine> refreshAsync() {
        return super.refreshAsync().map(virtualMachine -> {
            this.reset((VirtualMachineInner)((Object)((Object)virtualMachine.innerModel())));
            this.virtualMachineExtensions.refresh();
            return virtualMachine;
        });
    }

    protected Mono<VirtualMachineInner> getInnerAsync() {
        return ((ComputeManagementClient)((ComputeManager)this.manager()).serviceClient()).getVirtualMachines().getByResourceGroupAsync(this.resourceGroupName(), this.name());
    }

    @Override
    public void deallocate() {
        this.deallocateAsync().block();
    }

    @Override
    public Mono<Void> deallocateAsync() {
        return ((ComputeManagementClient)((ComputeManager)this.manager()).serviceClient()).getVirtualMachines().deallocateAsync(this.resourceGroupName(), this.name()).map(aVoid -> this.refreshAsync()).then();
    }

    @Override
    public void deallocate(boolean hibernate) {
        this.deallocateAsync(hibernate).block();
    }

    @Override
    public Mono<Void> deallocateAsync(boolean hibernate) {
        return ((ComputeManagementClient)((ComputeManager)this.manager()).serviceClient()).getVirtualMachines().deallocateAsync(this.resourceGroupName(), this.name(), hibernate).map(aVoid -> this.refreshAsync()).then();
    }

    @Override
    public void generalize() {
        this.generalizeAsync().block();
    }

    @Override
    public Mono<Void> generalizeAsync() {
        return ((ComputeManagementClient)((ComputeManager)this.manager()).serviceClient()).getVirtualMachines().generalizeAsync(this.resourceGroupName(), this.name());
    }

    @Override
    public void powerOff() {
        this.powerOffAsync().block();
    }

    @Override
    public Mono<Void> powerOffAsync() {
        return ((ComputeManagementClient)((ComputeManager)this.manager()).serviceClient()).getVirtualMachines().powerOffAsync(this.resourceGroupName(), this.name(), null);
    }

    @Override
    public void powerOff(boolean skipShutdown) {
        this.powerOffAsync(skipShutdown).block();
    }

    @Override
    public Mono<Void> powerOffAsync(boolean skipShutdown) {
        return ((ComputeManagementClient)((ComputeManager)this.manager()).serviceClient()).getVirtualMachines().powerOffAsync(this.resourceGroupName(), this.name(), skipShutdown);
    }

    @Override
    public void restart() {
        this.restartAsync().block();
    }

    @Override
    public Mono<Void> restartAsync() {
        return ((ComputeManagementClient)((ComputeManager)this.manager()).serviceClient()).getVirtualMachines().restartAsync(this.resourceGroupName(), this.name());
    }

    @Override
    public void start() {
        this.startAsync().block();
    }

    @Override
    public Mono<Void> startAsync() {
        return ((ComputeManagementClient)((ComputeManager)this.manager()).serviceClient()).getVirtualMachines().startAsync(this.resourceGroupName(), this.name());
    }

    @Override
    public void redeploy() {
        this.redeployAsync().block();
    }

    @Override
    public Mono<Void> redeployAsync() {
        return ((ComputeManagementClient)((ComputeManager)this.manager()).serviceClient()).getVirtualMachines().redeployAsync(this.resourceGroupName(), this.name());
    }

    @Override
    public void simulateEviction() {
        this.simulateEvictionAsync().block();
    }

    @Override
    public Mono<Void> simulateEvictionAsync() {
        return ((ComputeManagementClient)((ComputeManager)this.manager()).serviceClient()).getVirtualMachines().simulateEvictionAsync(this.resourceGroupName(), this.name());
    }

    @Override
    public void convertToManaged() {
        ((ComputeManagementClient)((ComputeManager)this.manager()).serviceClient()).getVirtualMachines().convertToManagedDisks(this.resourceGroupName(), this.name());
        this.refresh();
    }

    @Override
    public Mono<Void> convertToManagedAsync() {
        return ((ComputeManagementClient)((ComputeManager)this.manager()).serviceClient()).getVirtualMachines().convertToManagedDisksAsync(this.resourceGroupName(), this.name()).flatMap(aVoid -> this.refreshAsync()).then();
    }

    @Override
    public VirtualMachineEncryption diskEncryption() {
        return new VirtualMachineEncryptionImpl(this);
    }

    @Override
    public PagedIterable<VirtualMachineSize> availableSizes() {
        return PagedConverter.mapPage(((ComputeManagementClient)((ComputeManager)this.manager()).serviceClient()).getVirtualMachines().listAvailableSizes(this.resourceGroupName(), this.name()), VirtualMachineSizeImpl::new);
    }

    @Override
    public String capture(String containerName, String vhdPrefix, boolean overwriteVhd) {
        return (String)this.captureAsync(containerName, vhdPrefix, overwriteVhd).block();
    }

    @Override
    public Mono<String> captureAsync(String containerName, String vhdPrefix, boolean overwriteVhd) {
        VirtualMachineCaptureParameters parameters = new VirtualMachineCaptureParameters();
        parameters.withDestinationContainerName(containerName);
        parameters.withOverwriteVhds(overwriteVhd);
        parameters.withVhdPrefix(vhdPrefix);
        return ((ComputeManagementClient)((ComputeManager)this.manager()).serviceClient()).getVirtualMachines().captureAsync(this.resourceGroupName(), this.name(), parameters).map(captureResult -> VirtualMachineImpl.serializeCaptureResult(captureResult, this.logger));
    }

    @Override
    public VirtualMachineInstanceView refreshInstanceView() {
        return (VirtualMachineInstanceView)this.refreshInstanceViewAsync().block();
    }

    @Override
    public Mono<VirtualMachineInstanceView> refreshInstanceViewAsync() {
        return ((ComputeManagementClient)((ComputeManager)this.manager()).serviceClient()).getVirtualMachines().getByResourceGroupWithResponseAsync(this.resourceGroupName(), this.name(), InstanceViewTypes.INSTANCE_VIEW).map(inner -> {
            this.virtualMachineInstanceView = new VirtualMachineInstanceViewImpl(((VirtualMachineInner)((Object)((Object)inner.getValue()))).instanceView());
            return this.virtualMachineInstanceView;
        }).switchIfEmpty(Mono.defer(() -> {
            this.virtualMachineInstanceView = null;
            return Mono.empty();
        }));
    }

    @Override
    public RunCommandResult runPowerShellScript(List<String> scriptLines, List<RunCommandInputParameter> scriptParameters) {
        return ((ComputeManager)this.manager()).virtualMachines().runPowerShellScript(this.resourceGroupName(), this.name(), scriptLines, scriptParameters);
    }

    @Override
    public Mono<RunCommandResult> runPowerShellScriptAsync(List<String> scriptLines, List<RunCommandInputParameter> scriptParameters) {
        return ((ComputeManager)this.manager()).virtualMachines().runPowerShellScriptAsync(this.resourceGroupName(), this.name(), scriptLines, scriptParameters);
    }

    @Override
    public RunCommandResult runShellScript(List<String> scriptLines, List<RunCommandInputParameter> scriptParameters) {
        return ((ComputeManager)this.manager()).virtualMachines().runShellScript(this.resourceGroupName(), this.name(), scriptLines, scriptParameters);
    }

    @Override
    public Mono<RunCommandResult> runShellScriptAsync(List<String> scriptLines, List<RunCommandInputParameter> scriptParameters) {
        return ((ComputeManager)this.manager()).virtualMachines().runShellScriptAsync(this.resourceGroupName(), this.name(), scriptLines, scriptParameters);
    }

    @Override
    public RunCommandResult runCommand(RunCommandInput inputCommand) {
        return ((ComputeManager)this.manager()).virtualMachines().runCommand(this.resourceGroupName(), this.name(), inputCommand);
    }

    @Override
    public Mono<RunCommandResult> runCommandAsync(RunCommandInput inputCommand) {
        return ((ComputeManager)this.manager()).virtualMachines().runCommandAsync(this.resourceGroupName(), this.name(), inputCommand);
    }

    @Override
    public VirtualMachineImpl withNewPrimaryNetwork(Creatable<Network> creatable) {
        this.nicDefinitionWithPrivateIp = this.preparePrimaryNetworkInterface(this.namer.getRandomName("nic", 20)).withNewPrimaryNetwork(creatable);
        return this;
    }

    @Override
    public VirtualMachineImpl withNewPrimaryNetwork(String addressSpace) {
        this.nicDefinitionWithPrivateIp = this.preparePrimaryNetworkInterface(this.namer.getRandomName("nic", 20)).withNewPrimaryNetwork(addressSpace);
        return this;
    }

    @Override
    public VirtualMachineImpl withExistingPrimaryNetwork(Network network) {
        this.nicDefinitionWithSubnet = this.preparePrimaryNetworkInterface(this.namer.getRandomName("nic", 20)).withExistingPrimaryNetwork(network);
        return this;
    }

    @Override
    public VirtualMachineImpl withSubnet(String name) {
        this.nicDefinitionWithPrivateIp = this.nicDefinitionWithSubnet.withSubnet(name);
        return this;
    }

    @Override
    public VirtualMachineImpl withPrimaryPrivateIPAddressDynamic() {
        this.nicDefinitionWithCreate = this.nicDefinitionWithPrivateIp.withPrimaryPrivateIPAddressDynamic();
        return this;
    }

    @Override
    public VirtualMachineImpl withPrimaryPrivateIPAddressStatic(String staticPrivateIPAddress) {
        this.nicDefinitionWithCreate = this.nicDefinitionWithPrivateIp.withPrimaryPrivateIPAddressStatic(staticPrivateIPAddress);
        return this;
    }

    @Override
    public VirtualMachineImpl withNewPrimaryPublicIPAddress(Creatable<PublicIpAddress> creatable) {
        NetworkInterface.DefinitionStages.WithCreate nicCreatable = this.nicDefinitionWithCreate.withNewPrimaryPublicIPAddress(creatable);
        this.creatablePrimaryNetworkInterfaceKey = this.addDependency((Creatable)nicCreatable);
        return this;
    }

    @Override
    public VirtualMachineImpl withNewPrimaryPublicIPAddress(String leafDnsLabel) {
        return this.withNewPrimaryPublicIPAddress(leafDnsLabel, null);
    }

    public VirtualMachineImpl withNewPrimaryPublicIPAddress(String leafDnsLabel, DeleteOptions deleteOptions) {
        PublicIpAddress.DefinitionStages.WithGroup definitionWithGroup = (PublicIpAddress.DefinitionStages.WithGroup)((PublicIpAddress.DefinitionStages.Blank)this.networkManager.publicIpAddresses().define(this.namer.getRandomName("pip", 15))).withRegion(this.regionName());
        PublicIpAddress.DefinitionStages.WithCreate definitionAfterGroup = this.creatableGroup != null ? (PublicIpAddress.DefinitionStages.WithCreate)definitionWithGroup.withNewResourceGroup(this.creatableGroup) : (PublicIpAddress.DefinitionStages.WithCreate)definitionWithGroup.withExistingResourceGroup(this.resourceGroupName());
        this.implicitPipCreatable = definitionAfterGroup.withLeafDomainLabel(leafDnsLabel);
        NetworkInterface.DefinitionStages.WithCreate nicCreatable = this.nicDefinitionWithCreate.withNewPrimaryPublicIPAddress((Creatable)this.implicitPipCreatable);
        this.creatablePrimaryNetworkInterfaceKey = this.addDependency((Creatable)nicCreatable);
        return this;
    }

    @Override
    public VirtualMachineImpl withExistingPrimaryPublicIPAddress(PublicIpAddress publicIPAddress) {
        NetworkInterface.DefinitionStages.WithCreate nicCreatable = this.nicDefinitionWithCreate.withExistingPrimaryPublicIPAddress(publicIPAddress);
        this.creatablePrimaryNetworkInterfaceKey = this.addDependency((Creatable)nicCreatable);
        return this;
    }

    @Override
    public VirtualMachineImpl withoutPrimaryPublicIPAddress() {
        NetworkInterface.DefinitionStages.WithCreate nicCreatable = this.nicDefinitionWithCreate;
        this.creatablePrimaryNetworkInterfaceKey = this.addDependency((Creatable)nicCreatable);
        return this;
    }

    @Override
    public VirtualMachineImpl withNewPrimaryNetworkInterface(Creatable<NetworkInterface> creatable) {
        this.creatablePrimaryNetworkInterfaceKey = this.addDependency(creatable);
        return this;
    }

    public VirtualMachineImpl withNewPrimaryNetworkInterface(String name, String publicDnsNameLabel) {
        NetworkInterface.DefinitionStages.WithCreate definitionCreatable = this.prepareNetworkInterface(name).withNewPrimaryPublicIPAddress(publicDnsNameLabel);
        return this.withNewPrimaryNetworkInterface((Creatable)definitionCreatable);
    }

    @Override
    public VirtualMachineImpl withExistingPrimaryNetworkInterface(NetworkInterface networkInterface) {
        this.existingPrimaryNetworkInterfaceToAssociate = networkInterface;
        return this;
    }

    @Override
    public VirtualMachineImpl withStoredWindowsImage(String imageUrl) {
        VirtualHardDisk userImageVhd = new VirtualHardDisk();
        userImageVhd.withUri(imageUrl);
        ((VirtualMachineInner)((Object)this.innerModel())).storageProfile().osDisk().withCreateOption(DiskCreateOptionTypes.FROM_IMAGE);
        ((VirtualMachineInner)((Object)this.innerModel())).storageProfile().osDisk().withImage(userImageVhd);
        ((VirtualMachineInner)((Object)this.innerModel())).storageProfile().osDisk().withOsType(OperatingSystemTypes.WINDOWS);
        ((VirtualMachineInner)((Object)this.innerModel())).osProfile().withWindowsConfiguration(new WindowsConfiguration());
        ((VirtualMachineInner)((Object)this.innerModel())).osProfile().windowsConfiguration().withProvisionVMAgent(true);
        ((VirtualMachineInner)((Object)this.innerModel())).osProfile().windowsConfiguration().withEnableAutomaticUpdates(true);
        return this;
    }

    @Override
    public VirtualMachineImpl withStoredLinuxImage(String imageUrl) {
        VirtualHardDisk userImageVhd = new VirtualHardDisk();
        userImageVhd.withUri(imageUrl);
        ((VirtualMachineInner)((Object)this.innerModel())).storageProfile().osDisk().withCreateOption(DiskCreateOptionTypes.FROM_IMAGE);
        ((VirtualMachineInner)((Object)this.innerModel())).storageProfile().osDisk().withImage(userImageVhd);
        ((VirtualMachineInner)((Object)this.innerModel())).storageProfile().osDisk().withOsType(OperatingSystemTypes.LINUX);
        ((VirtualMachineInner)((Object)this.innerModel())).osProfile().withLinuxConfiguration(new LinuxConfiguration());
        return this;
    }

    @Override
    public VirtualMachineImpl withPopularWindowsImage(KnownWindowsVirtualMachineImage knownImage) {
        return this.withSpecificWindowsImageVersion(knownImage.imageReference());
    }

    @Override
    public VirtualMachineImpl withPopularLinuxImage(KnownLinuxVirtualMachineImage knownImage) {
        return this.withSpecificLinuxImageVersion(knownImage.imageReference());
    }

    @Override
    public VirtualMachineImpl withSpecificWindowsImageVersion(ImageReference imageReference) {
        ((VirtualMachineInner)((Object)this.innerModel())).storageProfile().osDisk().withCreateOption(DiskCreateOptionTypes.FROM_IMAGE);
        ((VirtualMachineInner)((Object)this.innerModel())).storageProfile().withImageReference(imageReference);
        ((VirtualMachineInner)((Object)this.innerModel())).osProfile().withWindowsConfiguration(new WindowsConfiguration());
        ((VirtualMachineInner)((Object)this.innerModel())).osProfile().windowsConfiguration().withProvisionVMAgent(true);
        ((VirtualMachineInner)((Object)this.innerModel())).osProfile().windowsConfiguration().withEnableAutomaticUpdates(true);
        return this;
    }

    @Override
    public VirtualMachineImpl withSpecificLinuxImageVersion(ImageReference imageReference) {
        ((VirtualMachineInner)((Object)this.innerModel())).storageProfile().osDisk().withCreateOption(DiskCreateOptionTypes.FROM_IMAGE);
        ((VirtualMachineInner)((Object)this.innerModel())).storageProfile().withImageReference(imageReference);
        ((VirtualMachineInner)((Object)this.innerModel())).osProfile().withLinuxConfiguration(new LinuxConfiguration());
        this.isMarketplaceLinuxImage = true;
        return this;
    }

    @Override
    public VirtualMachineImpl withLatestWindowsImage(String publisher, String offer, String sku) {
        ImageReference imageReference = new ImageReference();
        imageReference.withPublisher(publisher);
        imageReference.withOffer(offer);
        imageReference.withSku(sku);
        imageReference.withVersion("latest");
        return this.withSpecificWindowsImageVersion(imageReference);
    }

    @Override
    public VirtualMachineImpl withLatestLinuxImage(String publisher, String offer, String sku) {
        ImageReference imageReference = new ImageReference();
        imageReference.withPublisher(publisher);
        imageReference.withOffer(offer);
        imageReference.withSku(sku);
        imageReference.withVersion("latest");
        return this.withSpecificLinuxImageVersion(imageReference);
    }

    @Override
    public VirtualMachineImpl withGeneralizedWindowsCustomImage(String customImageId) {
        ImageReference imageReferenceInner = new ImageReference();
        imageReferenceInner.withId(customImageId);
        ((VirtualMachineInner)((Object)this.innerModel())).storageProfile().osDisk().withCreateOption(DiskCreateOptionTypes.FROM_IMAGE);
        ((VirtualMachineInner)((Object)this.innerModel())).storageProfile().withImageReference(imageReferenceInner);
        ((VirtualMachineInner)((Object)this.innerModel())).osProfile().withWindowsConfiguration(new WindowsConfiguration());
        ((VirtualMachineInner)((Object)this.innerModel())).osProfile().windowsConfiguration().withProvisionVMAgent(true);
        ((VirtualMachineInner)((Object)this.innerModel())).osProfile().windowsConfiguration().withEnableAutomaticUpdates(true);
        return this;
    }

    @Override
    public VirtualMachineImpl withSpecializedWindowsCustomImage(String customImageId) {
        this.withGeneralizedWindowsCustomImage(customImageId);
        this.removeOsProfile = true;
        return this;
    }

    @Override
    public VirtualMachineImpl withGeneralizedWindowsGalleryImageVersion(String galleryImageVersionId) {
        return this.withGeneralizedWindowsCustomImage(galleryImageVersionId);
    }

    @Override
    public VirtualMachineImpl withSpecializedWindowsGalleryImageVersion(String galleryImageVersionId) {
        return this.withSpecializedWindowsCustomImage(galleryImageVersionId);
    }

    @Override
    public VirtualMachineImpl withGeneralizedLinuxCustomImage(String customImageId) {
        ImageReference imageReferenceInner = new ImageReference();
        imageReferenceInner.withId(customImageId);
        ((VirtualMachineInner)((Object)this.innerModel())).storageProfile().osDisk().withCreateOption(DiskCreateOptionTypes.FROM_IMAGE);
        ((VirtualMachineInner)((Object)this.innerModel())).storageProfile().withImageReference(imageReferenceInner);
        ((VirtualMachineInner)((Object)this.innerModel())).osProfile().withLinuxConfiguration(new LinuxConfiguration());
        this.isMarketplaceLinuxImage = true;
        return this;
    }

    @Override
    public VirtualMachineImpl withSpecializedLinuxCustomImage(String customImageId) {
        this.withGeneralizedLinuxCustomImage(customImageId);
        this.removeOsProfile = true;
        return this;
    }

    @Override
    public VirtualMachineImpl withGeneralizedLinuxGalleryImageVersion(String galleryImageVersionId) {
        return this.withGeneralizedLinuxCustomImage(galleryImageVersionId);
    }

    @Override
    public VirtualMachineImpl withSpecializedLinuxGalleryImageVersion(String galleryImageVersionId) {
        return this.withSpecializedLinuxCustomImage(galleryImageVersionId);
    }

    @Override
    public VirtualMachineImpl withSpecializedOSUnmanagedDisk(String osDiskUrl, OperatingSystemTypes osType) {
        VirtualHardDisk osVhd = new VirtualHardDisk();
        osVhd.withUri(osDiskUrl);
        ((VirtualMachineInner)((Object)this.innerModel())).storageProfile().osDisk().withCreateOption(DiskCreateOptionTypes.ATTACH);
        ((VirtualMachineInner)((Object)this.innerModel())).storageProfile().osDisk().withVhd(osVhd);
        ((VirtualMachineInner)((Object)this.innerModel())).storageProfile().osDisk().withOsType(osType);
        ((VirtualMachineInner)((Object)this.innerModel())).storageProfile().osDisk().withManagedDisk(null);
        return this;
    }

    @Override
    public VirtualMachineImpl withSpecializedOSDisk(Disk disk, OperatingSystemTypes osType) {
        ManagedDiskParameters diskParametersInner = new ManagedDiskParameters();
        diskParametersInner.withId(disk.id());
        ((VirtualMachineInner)((Object)this.innerModel())).storageProfile().osDisk().withCreateOption(DiskCreateOptionTypes.ATTACH);
        ((VirtualMachineInner)((Object)this.innerModel())).storageProfile().osDisk().withManagedDisk(diskParametersInner);
        ((VirtualMachineInner)((Object)this.innerModel())).storageProfile().osDisk().withOsType(osType);
        ((VirtualMachineInner)((Object)this.innerModel())).storageProfile().osDisk().withVhd(null);
        return this;
    }

    @Override
    public VirtualMachineImpl withRootUsername(String rootUserName) {
        ((VirtualMachineInner)((Object)this.innerModel())).osProfile().withAdminUsername(rootUserName);
        return this;
    }

    @Override
    public VirtualMachineImpl withAdminUsername(String adminUserName) {
        ((VirtualMachineInner)((Object)this.innerModel())).osProfile().withAdminUsername(adminUserName);
        return this;
    }

    @Override
    public VirtualMachineImpl withSsh(String publicKeyData) {
        OSProfile osProfile = ((VirtualMachineInner)((Object)this.innerModel())).osProfile();
        if (osProfile.linuxConfiguration().ssh() == null) {
            SshConfiguration sshConfiguration = new SshConfiguration();
            sshConfiguration.withPublicKeys(new ArrayList<SshPublicKey>());
            osProfile.linuxConfiguration().withSsh(sshConfiguration);
        }
        SshPublicKey sshPublicKey = new SshPublicKey();
        sshPublicKey.withKeyData(publicKeyData);
        sshPublicKey.withPath("/home/" + osProfile.adminUsername() + "/.ssh/authorized_keys");
        osProfile.linuxConfiguration().ssh().publicKeys().add(sshPublicKey);
        return this;
    }

    @Override
    public VirtualMachineImpl withoutVMAgent() {
        ((VirtualMachineInner)((Object)this.innerModel())).osProfile().windowsConfiguration().withProvisionVMAgent(false);
        return this;
    }

    @Override
    public VirtualMachineImpl withoutAutoUpdate() {
        ((VirtualMachineInner)((Object)this.innerModel())).osProfile().windowsConfiguration().withEnableAutomaticUpdates(false);
        return this;
    }

    @Override
    public VirtualMachineImpl withTimeZone(String timeZone) {
        ((VirtualMachineInner)((Object)this.innerModel())).osProfile().windowsConfiguration().withTimeZone(timeZone);
        return this;
    }

    @Override
    public VirtualMachineImpl withWinRM(WinRMListener listener) {
        if (((VirtualMachineInner)((Object)this.innerModel())).osProfile().windowsConfiguration().winRM() == null) {
            WinRMConfiguration winRMConfiguration = new WinRMConfiguration();
            ((VirtualMachineInner)((Object)this.innerModel())).osProfile().windowsConfiguration().withWinRM(winRMConfiguration);
        }
        ((VirtualMachineInner)((Object)this.innerModel())).osProfile().windowsConfiguration().winRM().listeners().add(listener);
        return this;
    }

    @Override
    public VirtualMachineImpl withRootPassword(String password) {
        ((VirtualMachineInner)((Object)this.innerModel())).osProfile().withAdminPassword(password);
        return this;
    }

    @Override
    public VirtualMachineImpl withAdminPassword(String password) {
        ((VirtualMachineInner)((Object)this.innerModel())).osProfile().withAdminPassword(password);
        return this;
    }

    @Override
    public VirtualMachineImpl withCustomData(String base64EncodedCustomData) {
        ((VirtualMachineInner)((Object)this.innerModel())).osProfile().withCustomData(base64EncodedCustomData);
        return this;
    }

    @Override
    public VirtualMachineImpl withUserData(String base64EncodedUserData) {
        ((VirtualMachineInner)((Object)this.innerModel())).withUserData(base64EncodedUserData);
        return this;
    }

    @Override
    public VirtualMachineImpl withComputerName(String computerName) {
        ((VirtualMachineInner)((Object)this.innerModel())).osProfile().withComputerName(computerName);
        return this;
    }

    @Override
    public VirtualMachineImpl withSize(String sizeName) {
        ((VirtualMachineInner)((Object)this.innerModel())).hardwareProfile().withVmSize(VirtualMachineSizeTypes.fromString(sizeName));
        return this;
    }

    @Override
    public VirtualMachineImpl withSize(VirtualMachineSizeTypes size) {
        ((VirtualMachineInner)((Object)this.innerModel())).hardwareProfile().withVmSize(size);
        return this;
    }

    @Override
    public VirtualMachineImpl withOSDiskCaching(CachingTypes cachingType) {
        ((VirtualMachineInner)((Object)this.innerModel())).storageProfile().osDisk().withCaching(cachingType);
        return this;
    }

    @Override
    public VirtualMachineImpl withOSDiskVhdLocation(String containerName, String vhdName) {
        if (this.isManagedDiskEnabled()) {
            return this;
        }
        StorageProfile storageProfile = ((VirtualMachineInner)((Object)this.innerModel())).storageProfile();
        OSDisk osDisk = storageProfile.osDisk();
        if (!this.isOSDiskFromImage(osDisk)) {
            return this;
        }
        if (this.isOsDiskFromCustomImage(storageProfile)) {
            return this;
        }
        if (this.isOSDiskFromPlatformImage(storageProfile)) {
            VirtualHardDisk osVhd = new VirtualHardDisk();
            osVhd.withUri(this.temporaryBlobUrl(containerName, vhdName));
            ((VirtualMachineInner)((Object)this.innerModel())).storageProfile().osDisk().withVhd(osVhd);
            return this;
        }
        if (this.isOSDiskFromStoredImage(storageProfile)) {
            VirtualHardDisk osVhd = new VirtualHardDisk();
            try {
                URL sourceCustomImageUrl = new URL(osDisk.image().uri());
                URL destinationVhdUrl = new URL(sourceCustomImageUrl.getProtocol(), sourceCustomImageUrl.getHost(), "/" + containerName + "/" + vhdName);
                osVhd.withUri(destinationVhdUrl.toString());
            }
            catch (MalformedURLException ex) {
                throw this.logger.logExceptionAsError(new RuntimeException(ex));
            }
            ((VirtualMachineInner)((Object)this.innerModel())).storageProfile().osDisk().withVhd(osVhd);
        }
        return this;
    }

    @Override
    public VirtualMachineImpl withOSDiskStorageAccountType(StorageAccountTypes accountType) {
        if (((VirtualMachineInner)((Object)this.innerModel())).storageProfile().osDisk().managedDisk() == null) {
            ((VirtualMachineInner)((Object)this.innerModel())).storageProfile().osDisk().withManagedDisk(new ManagedDiskParameters());
        }
        ((VirtualMachineInner)((Object)this.innerModel())).storageProfile().osDisk().managedDisk().withStorageAccountType(accountType);
        return this;
    }

    @Override
    public VirtualMachineImpl withDataDiskDefaultCachingType(CachingTypes cachingType) {
        this.managedDataDisks.setDefaultCachingType(cachingType);
        return this;
    }

    @Override
    public VirtualMachineImpl withDataDiskDefaultStorageAccountType(StorageAccountTypes storageAccountType) {
        this.managedDataDisks.setDefaultStorageAccountType(storageAccountType);
        return this;
    }

    @Override
    public VirtualMachineImpl withDataDiskDefaultDeleteOptions(DeleteOptions deleteOptions) {
        this.managedDataDisks.setDefaultDeleteOptions(this.diskDeleteOptionsFromDeleteOptions(deleteOptions));
        return this;
    }

    @Override
    public VirtualMachineImpl withDataDiskDefaultDiskEncryptionSet(String diskEncryptionSetId) {
        this.managedDataDisks.setDefaultEncryptionSet(diskEncryptionSetId);
        return this;
    }

    @Override
    public VirtualMachineImpl withOSDiskEncryptionSettings(DiskEncryptionSettings settings) {
        ((VirtualMachineInner)((Object)this.innerModel())).storageProfile().osDisk().withEncryptionSettings(settings);
        return this;
    }

    @Override
    public VirtualMachineImpl withOSDiskSizeInGB(int size) {
        ((VirtualMachineInner)((Object)this.innerModel())).storageProfile().osDisk().withDiskSizeGB(size);
        return this;
    }

    @Override
    public VirtualMachineImpl withOSDiskName(String name) {
        ((VirtualMachineInner)((Object)this.innerModel())).storageProfile().osDisk().withName(name);
        return this;
    }

    @Override
    public VirtualMachineImpl withOSDiskDeleteOptions(DeleteOptions deleteOptions) {
        ((VirtualMachineInner)((Object)this.innerModel())).storageProfile().osDisk().withDeleteOption(DiskDeleteOptionTypes.fromString(deleteOptions.toString()));
        return this;
    }

    @Override
    public VirtualMachineImpl withOSDiskDiskEncryptionSet(String diskEncryptionSetId) {
        if (((VirtualMachineInner)((Object)this.innerModel())).storageProfile().osDisk().managedDisk() == null) {
            ((VirtualMachineInner)((Object)this.innerModel())).storageProfile().osDisk().withManagedDisk(new ManagedDiskParameters());
        }
        if (((VirtualMachineInner)((Object)this.innerModel())).storageProfile().osDisk().managedDisk().diskEncryptionSet() == null) {
            ((VirtualMachineInner)((Object)this.innerModel())).storageProfile().osDisk().managedDisk().withDiskEncryptionSet(new DiskEncryptionSetParameters());
        }
        ((VirtualMachineInner)((Object)this.innerModel())).storageProfile().osDisk().managedDisk().diskEncryptionSet().withId(diskEncryptionSetId);
        return this;
    }

    @Override
    public VirtualMachineImpl withEphemeralOSDisk() {
        if (((VirtualMachineInner)((Object)this.innerModel())).storageProfile().osDisk().diffDiskSettings() == null) {
            ((VirtualMachineInner)((Object)this.innerModel())).storageProfile().osDisk().withDiffDiskSettings(new DiffDiskSettings());
        }
        ((VirtualMachineInner)((Object)this.innerModel())).storageProfile().osDisk().diffDiskSettings().withOption(DiffDiskOptions.LOCAL);
        this.withOSDiskCaching(CachingTypes.READ_ONLY);
        return this;
    }

    public UnmanagedDataDiskImpl defineUnmanagedDataDisk(String name) {
        this.throwIfManagedDiskEnabled("This virtual machine is based on managed disk(s), both un-managed and managed disk cannot exists together in a virtual machine");
        return UnmanagedDataDiskImpl.prepareDataDisk(name, this);
    }

    @Override
    public VirtualMachineImpl withNewUnmanagedDataDisk(Integer sizeInGB) {
        this.throwIfManagedDiskEnabled("This virtual machine is based on managed disk(s), both un-managed and managed disk cannot exists together in a virtual machine");
        return this.defineUnmanagedDataDisk(null).withNewVhd(sizeInGB).attach();
    }

    @Override
    public VirtualMachineImpl withExistingUnmanagedDataDisk(String storageAccountName, String containerName, String vhdName) {
        this.throwIfManagedDiskEnabled("This virtual machine is based on managed disk(s), both un-managed and managed disk cannot exists together in a virtual machine");
        return this.defineUnmanagedDataDisk(null).withExistingVhd(storageAccountName, containerName, vhdName).attach();
    }

    @Override
    public VirtualMachineImpl withoutUnmanagedDataDisk(String name) {
        int idx = -1;
        for (VirtualMachineUnmanagedDataDisk dataDisk : this.unmanagedDataDisks) {
            ++idx;
            if (!dataDisk.name().equalsIgnoreCase(name)) continue;
            this.unmanagedDataDisks.remove(idx);
            ((VirtualMachineInner)((Object)this.innerModel())).storageProfile().dataDisks().remove(idx);
            break;
        }
        return this;
    }

    @Override
    public VirtualMachineImpl withoutUnmanagedDataDisk(int lun) {
        int idx = -1;
        for (VirtualMachineUnmanagedDataDisk dataDisk : this.unmanagedDataDisks) {
            ++idx;
            if (dataDisk.lun() != lun) continue;
            this.unmanagedDataDisks.remove(idx);
            ((VirtualMachineInner)((Object)this.innerModel())).storageProfile().dataDisks().remove(idx);
            break;
        }
        return this;
    }

    @Override
    public UnmanagedDataDiskImpl updateUnmanagedDataDisk(String name) {
        this.throwIfManagedDiskEnabled("This virtual machine is based on managed disk(s) and there is no un-managed disk to update");
        for (VirtualMachineUnmanagedDataDisk dataDisk : this.unmanagedDataDisks) {
            if (!dataDisk.name().equalsIgnoreCase(name)) continue;
            return (UnmanagedDataDiskImpl)dataDisk;
        }
        throw this.logger.logExceptionAsError(new RuntimeException("A data disk with name  '" + name + "' not found"));
    }

    @Override
    public VirtualMachineImpl withNewDataDisk(Creatable<Disk> creatable) {
        this.throwIfManagedDiskDisabled("This virtual machine is based on un-managed disks (s), both un-managed and managed disk cannot exists together in a virtual machine");
        this.managedDataDisks.newDisksToAttach.put(this.addDependency(creatable), new DataDisk().withLun(-1));
        return this;
    }

    @Override
    public VirtualMachineImpl withNewDataDisk(Creatable<Disk> creatable, int lun, CachingTypes cachingType) {
        this.throwIfManagedDiskDisabled("This virtual machine is based on un-managed disks (s), both un-managed and managed disk cannot exists together in a virtual machine");
        this.managedDataDisks.newDisksToAttach.put(this.addDependency(creatable), new DataDisk().withLun(lun).withCaching(cachingType));
        return this;
    }

    @Override
    public VirtualMachineImpl withNewDataDisk(int sizeInGB) {
        this.throwIfManagedDiskDisabled("This virtual machine is based on un-managed disks (s), both un-managed and managed disk cannot exists together in a virtual machine");
        this.managedDataDisks.implicitDisksToAssociate.add(new DataDisk().withLun(-1).withDiskSizeGB(sizeInGB));
        return this;
    }

    @Override
    public VirtualMachineImpl withNewDataDisk(int sizeInGB, int lun, CachingTypes cachingType) {
        this.throwIfManagedDiskDisabled("This virtual machine is based on un-managed disks (s), both un-managed and managed disk cannot exists together in a virtual machine");
        this.managedDataDisks.implicitDisksToAssociate.add(new DataDisk().withLun(lun).withDiskSizeGB(sizeInGB).withCaching(cachingType));
        return this;
    }

    @Override
    public VirtualMachineImpl withNewDataDisk(int sizeInGB, int lun, CachingTypes cachingType, StorageAccountTypes storageAccountType) {
        this.throwIfManagedDiskDisabled("This virtual machine is based on un-managed disks (s), both un-managed and managed disk cannot exists together in a virtual machine");
        ManagedDiskParameters managedDiskParameters = new ManagedDiskParameters();
        managedDiskParameters.withStorageAccountType(storageAccountType);
        this.managedDataDisks.implicitDisksToAssociate.add(new DataDisk().withLun(lun).withDiskSizeGB(sizeInGB).withCaching(cachingType).withManagedDisk(managedDiskParameters));
        return this;
    }

    @Override
    public VirtualMachineImpl withNewDataDisk(int sizeInGB, int lun, VirtualMachineDiskOptions options) {
        this.throwIfManagedDiskDisabled("This virtual machine is based on un-managed disks (s), both un-managed and managed disk cannot exists together in a virtual machine");
        ManagedDiskParameters managedDiskParameters = null;
        if (options.storageAccountType() != null || options.isDiskEncryptionSetConfigured()) {
            managedDiskParameters = new ManagedDiskParameters();
            managedDiskParameters.withStorageAccountType(options.storageAccountType());
            if (options.isDiskEncryptionSetConfigured()) {
                managedDiskParameters.withDiskEncryptionSet(new DiskEncryptionSetParameters().withId(options.diskEncryptionSetId()));
            }
        }
        this.managedDataDisks.implicitDisksToAssociate.add(new DataDisk().withLun(lun).withDiskSizeGB(sizeInGB).withCaching(options.cachingTypes()).withDeleteOption(this.diskDeleteOptionsFromDeleteOptions(options.deleteOptions())).withManagedDisk(managedDiskParameters));
        return this;
    }

    @Override
    public VirtualMachineImpl withExistingDataDisk(Disk disk) {
        this.throwIfManagedDiskDisabled("This virtual machine is based on un-managed disks (s), both un-managed and managed disk cannot exists together in a virtual machine");
        ManagedDiskParameters managedDiskParameters = new ManagedDiskParameters();
        managedDiskParameters.withId(disk.id());
        this.managedDataDisks.existingDisksToAttach.add(new DataDisk().withLun(-1).withManagedDisk(managedDiskParameters));
        return this;
    }

    @Override
    public VirtualMachineImpl withExistingDataDisk(Disk disk, int lun, CachingTypes cachingType) {
        this.throwIfManagedDiskDisabled("This virtual machine is based on un-managed disks (s), both un-managed and managed disk cannot exists together in a virtual machine");
        ManagedDiskParameters managedDiskParameters = new ManagedDiskParameters();
        managedDiskParameters.withId(disk.id());
        this.managedDataDisks.existingDisksToAttach.add(new DataDisk().withLun(lun).withManagedDisk(managedDiskParameters).withCaching(cachingType));
        return this;
    }

    @Override
    public VirtualMachineImpl withExistingDataDisk(Disk disk, int newSizeInGB, int lun, CachingTypes cachingType) {
        this.throwIfManagedDiskDisabled("This virtual machine is based on un-managed disks (s), both un-managed and managed disk cannot exists together in a virtual machine");
        ManagedDiskParameters managedDiskParameters = new ManagedDiskParameters();
        managedDiskParameters.withId(disk.id());
        this.managedDataDisks.existingDisksToAttach.add(new DataDisk().withLun(lun).withDiskSizeGB(newSizeInGB).withManagedDisk(managedDiskParameters).withCaching(cachingType));
        return this;
    }

    @Override
    public VirtualMachineImpl withExistingDataDisk(Disk disk, int newSizeInGB, int lun, VirtualMachineDiskOptions options) {
        this.throwIfManagedDiskDisabled("This virtual machine is based on un-managed disks (s), both un-managed and managed disk cannot exists together in a virtual machine");
        ManagedDiskParameters managedDiskParameters = new ManagedDiskParameters();
        managedDiskParameters.withId(disk.id());
        if (options.isDiskEncryptionSetConfigured()) {
            managedDiskParameters.withDiskEncryptionSet(new DiskEncryptionSetParameters().withId(options.diskEncryptionSetId()));
        }
        this.managedDataDisks.existingDisksToAttach.add(new DataDisk().withLun(lun).withDiskSizeGB(newSizeInGB).withCaching(options.cachingTypes()).withDeleteOption(this.diskDeleteOptionsFromDeleteOptions(options.deleteOptions())).withManagedDisk(managedDiskParameters));
        return this;
    }

    @Override
    public VirtualMachineImpl withNewDataDiskFromImage(int imageLun) {
        this.managedDataDisks.newDisksFromImage.add(new DataDisk().withLun(imageLun));
        return this;
    }

    @Override
    public VirtualMachineImpl withNewDataDiskFromImage(int imageLun, int newSizeInGB, CachingTypes cachingType) {
        this.managedDataDisks.newDisksFromImage.add(new DataDisk().withLun(imageLun).withDiskSizeGB(newSizeInGB).withCaching(cachingType));
        return this;
    }

    @Override
    public VirtualMachineImpl withNewDataDiskFromImage(int imageLun, int newSizeInGB, CachingTypes cachingType, StorageAccountTypes storageAccountType) {
        ManagedDiskParameters managedDiskParameters = new ManagedDiskParameters();
        managedDiskParameters.withStorageAccountType(storageAccountType);
        this.managedDataDisks.newDisksFromImage.add(new DataDisk().withLun(imageLun).withDiskSizeGB(newSizeInGB).withManagedDisk(managedDiskParameters).withCaching(cachingType));
        return this;
    }

    @Override
    public VirtualMachineImpl withNewDataDiskFromImage(int imageLun, int newSizeInGB, VirtualMachineDiskOptions options) {
        this.throwIfManagedDiskDisabled("This virtual machine is based on un-managed disks (s), both un-managed and managed disk cannot exists together in a virtual machine");
        ManagedDiskParameters managedDiskParameters = null;
        if (options.storageAccountType() != null || options.isDiskEncryptionSetConfigured()) {
            managedDiskParameters = new ManagedDiskParameters();
            managedDiskParameters.withStorageAccountType(options.storageAccountType());
            if (options.isDiskEncryptionSetConfigured()) {
                managedDiskParameters.withDiskEncryptionSet(new DiskEncryptionSetParameters().withId(options.diskEncryptionSetId()));
            }
        }
        this.managedDataDisks.implicitDisksToAssociate.add(new DataDisk().withLun(imageLun).withDiskSizeGB(newSizeInGB).withCaching(options.cachingTypes()).withDeleteOption(this.diskDeleteOptionsFromDeleteOptions(options.deleteOptions())).withManagedDisk(managedDiskParameters));
        return this;
    }

    @Override
    public VirtualMachineImpl withoutDataDisk(int lun) {
        if (!this.isManagedDiskEnabled()) {
            return this;
        }
        this.managedDataDisks.diskLunsToRemove.add(lun);
        return this;
    }

    @Override
    public VirtualMachineImpl withNewStorageAccount(Creatable<StorageAccount> creatable) {
        if (this.creatableStorageAccountKey == null) {
            this.creatableStorageAccountKey = this.addDependency(creatable);
        }
        return this;
    }

    @Override
    public VirtualMachineImpl withNewStorageAccount(String name) {
        StorageAccount.DefinitionStages.WithGroup definitionWithGroup = (StorageAccount.DefinitionStages.WithGroup)((StorageAccount.DefinitionStages.Blank)this.storageManager.storageAccounts().define(name)).withRegion(this.regionName());
        Creatable definitionAfterGroup = this.creatableGroup != null ? (Creatable)definitionWithGroup.withNewResourceGroup(this.creatableGroup) : (Creatable)definitionWithGroup.withExistingResourceGroup(this.resourceGroupName());
        return this.withNewStorageAccount(definitionAfterGroup);
    }

    @Override
    public VirtualMachineImpl withExistingStorageAccount(StorageAccount storageAccount) {
        this.existingStorageAccountToAssociate = storageAccount;
        return this;
    }

    @Override
    public VirtualMachineImpl withNewAvailabilitySet(Creatable<AvailabilitySet> creatable) {
        if (this.creatableAvailabilitySetKey == null) {
            this.creatableAvailabilitySetKey = this.addDependency(creatable);
        }
        return this;
    }

    @Override
    public VirtualMachineImpl withProximityPlacementGroup(String proximityPlacementGroupId) {
        ((VirtualMachineInner)((Object)this.innerModel())).withProximityPlacementGroup(new SubResource().withId(proximityPlacementGroupId));
        this.newProximityPlacementGroupName = null;
        return this;
    }

    @Override
    public VirtualMachineImpl withNewProximityPlacementGroup(String proximityPlacementGroupName, ProximityPlacementGroupType type) {
        this.newProximityPlacementGroupName = proximityPlacementGroupName;
        this.newProximityPlacementGroupType = type;
        ((VirtualMachineInner)((Object)this.innerModel())).withProximityPlacementGroup(null);
        return this;
    }

    @Override
    public VirtualMachineImpl withoutProximityPlacementGroup() {
        ((VirtualMachineInner)((Object)this.innerModel())).withProximityPlacementGroup(null);
        return this;
    }

    @Override
    public VirtualMachineImpl withNewAvailabilitySet(String name) {
        AvailabilitySet.DefinitionStages.WithGroup definitionWithGroup = (AvailabilitySet.DefinitionStages.WithGroup)((AvailabilitySet.DefinitionStages.Blank)((ComputeManager)this.myManager).availabilitySets().define(name)).withRegion(this.regionName());
        AvailabilitySet.DefinitionStages.WithSku definitionWithSku = this.creatableGroup != null ? (AvailabilitySet.DefinitionStages.WithSku)definitionWithGroup.withNewResourceGroup(this.creatableGroup) : (AvailabilitySet.DefinitionStages.WithSku)definitionWithGroup.withExistingResourceGroup(this.resourceGroupName());
        AvailabilitySet.DefinitionStages.WithCreate creatable = this.isManagedDiskEnabled() ? definitionWithSku.withSku(AvailabilitySetSkuTypes.ALIGNED) : definitionWithSku.withSku(AvailabilitySetSkuTypes.CLASSIC);
        return this.withNewAvailabilitySet(creatable);
    }

    @Override
    public VirtualMachineImpl withExistingAvailabilitySet(AvailabilitySet availabilitySet) {
        this.existingAvailabilitySetToAssociate = availabilitySet;
        return this;
    }

    @Override
    public VirtualMachineImpl withNewSecondaryNetworkInterface(Creatable<NetworkInterface> creatable) {
        this.creatableSecondaryNetworkInterfaceKeys.add(this.addDependency(creatable));
        return this;
    }

    @Override
    public VirtualMachineImpl withNewSecondaryNetworkInterface(Creatable<NetworkInterface> creatable, DeleteOptions deleteOptions) {
        String key = this.addDependency(creatable);
        this.creatableSecondaryNetworkInterfaceKeys.add(key);
        if (deleteOptions != null) {
            this.secondaryNetworkInterfaceDeleteOptions.put(key, deleteOptions);
        }
        return this;
    }

    @Override
    public VirtualMachineImpl withExistingSecondaryNetworkInterface(NetworkInterface networkInterface) {
        this.existingSecondaryNetworkInterfacesToAssociate.add(networkInterface);
        return this;
    }

    public VirtualMachineExtensionImpl defineNewExtension(String name) {
        return this.virtualMachineExtensions.define(name);
    }

    @Override
    public VirtualMachineImpl withoutSecondaryNetworkInterface(String name) {
        if (((VirtualMachineInner)((Object)this.innerModel())).networkProfile() != null && ((VirtualMachineInner)((Object)this.innerModel())).networkProfile().networkInterfaces() != null) {
            int idx = -1;
            for (NetworkInterfaceReference nicReference : ((VirtualMachineInner)((Object)this.innerModel())).networkProfile().networkInterfaces()) {
                ++idx;
                if (nicReference.primary().booleanValue() || !name.equalsIgnoreCase(ResourceUtils.nameFromResourceId((String)nicReference.id()))) continue;
                ((VirtualMachineInner)((Object)this.innerModel())).networkProfile().networkInterfaces().remove(idx);
                break;
            }
        }
        return this;
    }

    @Override
    public VirtualMachineExtensionImpl updateExtension(String name) {
        return this.virtualMachineExtensions.update(name);
    }

    @Override
    public VirtualMachineImpl withoutExtension(String name) {
        this.virtualMachineExtensions.remove(name);
        return this;
    }

    @Override
    public VirtualMachineImpl withPlan(PurchasePlan plan) {
        ((VirtualMachineInner)((Object)this.innerModel())).withPlan(new Plan());
        ((VirtualMachineInner)((Object)this.innerModel())).plan().withPublisher(plan.publisher()).withProduct(plan.product()).withName(plan.name());
        return this;
    }

    @Override
    public VirtualMachineImpl withPromotionalPlan(PurchasePlan plan, String promotionCode) {
        this.withPlan(plan);
        ((VirtualMachineInner)((Object)this.innerModel())).plan().withPromotionCode(promotionCode);
        return this;
    }

    @Override
    public VirtualMachineImpl withUnmanagedDisks() {
        this.isUnmanagedDiskSelected = true;
        return this;
    }

    @Override
    public VirtualMachineImpl withBootDiagnosticsOnManagedStorageAccount() {
        this.bootDiagnosticsHandler.withBootDiagnostics(true);
        return this;
    }

    @Override
    public VirtualMachineImpl withBootDiagnostics() {
        this.bootDiagnosticsHandler.withBootDiagnostics(false);
        return this;
    }

    @Override
    public VirtualMachineImpl withBootDiagnostics(Creatable<StorageAccount> creatable) {
        this.bootDiagnosticsHandler.withBootDiagnostics(creatable);
        return this;
    }

    @Override
    public VirtualMachineImpl withBootDiagnostics(String storageAccountBlobEndpointUri) {
        this.bootDiagnosticsHandler.withBootDiagnostics(storageAccountBlobEndpointUri);
        return this;
    }

    @Override
    public VirtualMachineImpl withBootDiagnostics(StorageAccount storageAccount) {
        this.bootDiagnosticsHandler.withBootDiagnostics(storageAccount);
        return this;
    }

    @Override
    public VirtualMachineImpl withoutBootDiagnostics() {
        this.bootDiagnosticsHandler.withoutBootDiagnostics();
        return this;
    }

    @Override
    public VirtualMachineImpl withPriority(VirtualMachinePriorityTypes priority) {
        ((VirtualMachineInner)((Object)this.innerModel())).withPriority(priority);
        return this;
    }

    @Override
    public VirtualMachineImpl withLowPriority() {
        this.withPriority(VirtualMachinePriorityTypes.LOW);
        return this;
    }

    @Override
    public VirtualMachineImpl withLowPriority(VirtualMachineEvictionPolicyTypes policy) {
        this.withLowPriority();
        ((VirtualMachineInner)((Object)this.innerModel())).withEvictionPolicy(policy);
        return this;
    }

    @Override
    public VirtualMachineImpl withSpotPriority() {
        this.withPriority(VirtualMachinePriorityTypes.SPOT);
        return this;
    }

    @Override
    public VirtualMachineImpl withSpotPriority(VirtualMachineEvictionPolicyTypes policy) {
        this.withSpotPriority();
        ((VirtualMachineInner)((Object)this.innerModel())).withEvictionPolicy(policy);
        return this;
    }

    @Override
    public VirtualMachineImpl withMaxPrice(Double maxPrice) {
        ((VirtualMachineInner)((Object)this.innerModel())).withBillingProfile(new BillingProfile().withMaxPrice(maxPrice));
        return this;
    }

    @Override
    public VirtualMachineImpl withSystemAssignedManagedServiceIdentity() {
        this.virtualMachineMsiHandler.withLocalManagedServiceIdentity();
        return this;
    }

    @Override
    public VirtualMachineImpl withoutSystemAssignedManagedServiceIdentity() {
        this.virtualMachineMsiHandler.withoutLocalManagedServiceIdentity();
        return this;
    }

    @Override
    public VirtualMachineImpl withSystemAssignedIdentityBasedAccessTo(String resourceId, BuiltInRole role) {
        this.virtualMachineMsiHandler.withAccessTo(resourceId, role);
        return this;
    }

    @Override
    public VirtualMachineImpl withSystemAssignedIdentityBasedAccessToCurrentResourceGroup(BuiltInRole role) {
        this.virtualMachineMsiHandler.withAccessToCurrentResourceGroup(role);
        return this;
    }

    @Override
    public VirtualMachineImpl withSystemAssignedIdentityBasedAccessTo(String resourceId, String roleDefinitionId) {
        this.virtualMachineMsiHandler.withAccessTo(resourceId, roleDefinitionId);
        return this;
    }

    @Override
    public VirtualMachineImpl withSystemAssignedIdentityBasedAccessToCurrentResourceGroup(String roleDefinitionId) {
        this.virtualMachineMsiHandler.withAccessToCurrentResourceGroup(roleDefinitionId);
        return this;
    }

    @Override
    public VirtualMachineImpl withNewUserAssignedManagedServiceIdentity(Creatable<Identity> creatableIdentity) {
        this.virtualMachineMsiHandler.withNewExternalManagedServiceIdentity(creatableIdentity);
        return this;
    }

    @Override
    public VirtualMachineImpl withExistingUserAssignedManagedServiceIdentity(Identity identity) {
        this.virtualMachineMsiHandler.withExistingExternalManagedServiceIdentity(identity);
        return this;
    }

    @Override
    public VirtualMachineImpl withoutUserAssignedManagedServiceIdentity(String identityId) {
        this.virtualMachineMsiHandler.withoutExternalManagedServiceIdentity(identityId);
        return this;
    }

    @Override
    public VirtualMachineImpl withLicenseType(String licenseType) {
        ((VirtualMachineInner)((Object)this.innerModel())).withLicenseType(licenseType);
        return this;
    }

    @Override
    public VirtualMachineImpl enableHibernation() {
        this.ensureAdditionalCapabilities();
        ((VirtualMachineInner)((Object)this.innerModel())).additionalCapabilities().withHibernationEnabled(true);
        return this;
    }

    @Override
    public VirtualMachineImpl disableHibernation() {
        this.ensureAdditionalCapabilities();
        ((VirtualMachineInner)((Object)this.innerModel())).additionalCapabilities().withHibernationEnabled(false);
        return this;
    }

    @Override
    public VirtualMachineImpl enableUltraSsd() {
        this.ensureAdditionalCapabilities();
        ((VirtualMachineInner)((Object)this.innerModel())).additionalCapabilities().withUltraSsdEnabled(true);
        return this;
    }

    @Override
    public VirtualMachineImpl disableUltraSsd() {
        this.ensureAdditionalCapabilities();
        ((VirtualMachineInner)((Object)this.innerModel())).additionalCapabilities().withUltraSsdEnabled(false);
        return this;
    }

    public void ensureAdditionalCapabilities() {
        if (((VirtualMachineInner)((Object)this.innerModel())).additionalCapabilities() == null) {
            ((VirtualMachineInner)((Object)this.innerModel())).withAdditionalCapabilities(new AdditionalCapabilities());
        }
    }

    @Override
    public boolean isManagedDiskEnabled() {
        if (this.isOsDiskFromCustomImage(((VirtualMachineInner)((Object)this.innerModel())).storageProfile())) {
            return true;
        }
        if (this.isOSDiskAttachedManaged(((VirtualMachineInner)((Object)this.innerModel())).storageProfile().osDisk())) {
            return true;
        }
        if (this.isOSDiskFromStoredImage(((VirtualMachineInner)((Object)this.innerModel())).storageProfile())) {
            return false;
        }
        if (this.isOSDiskAttachedUnmanaged(((VirtualMachineInner)((Object)this.innerModel())).storageProfile().osDisk())) {
            return false;
        }
        if (this.isOSDiskFromPlatformImage(((VirtualMachineInner)((Object)this.innerModel())).storageProfile()) && this.isUnmanagedDiskSelected) {
            return false;
        }
        if (this.isInCreateMode()) {
            return true;
        }
        return ((VirtualMachineInner)((Object)this.innerModel())).storageProfile().osDisk().vhd() == null;
    }

    @Override
    public String computerName() {
        if (((VirtualMachineInner)((Object)this.innerModel())).osProfile() == null) {
            return null;
        }
        return ((VirtualMachineInner)((Object)this.innerModel())).osProfile().computerName();
    }

    @Override
    public VirtualMachineSizeTypes size() {
        return ((VirtualMachineInner)((Object)this.innerModel())).hardwareProfile().vmSize();
    }

    @Override
    public OperatingSystemTypes osType() {
        if (((VirtualMachineInner)((Object)this.innerModel())).storageProfile().osDisk().osType() != null) {
            return ((VirtualMachineInner)((Object)this.innerModel())).storageProfile().osDisk().osType();
        }
        if (((VirtualMachineInner)((Object)this.innerModel())).osProfile() != null) {
            if (((VirtualMachineInner)((Object)this.innerModel())).osProfile().linuxConfiguration() != null) {
                return OperatingSystemTypes.LINUX;
            }
            if (((VirtualMachineInner)((Object)this.innerModel())).osProfile().windowsConfiguration() != null) {
                return OperatingSystemTypes.WINDOWS;
            }
        }
        return null;
    }

    @Override
    public String osUnmanagedDiskVhdUri() {
        if (this.isManagedDiskEnabled() || this.storageProfile().osDisk().vhd() == null) {
            return null;
        }
        return ((VirtualMachineInner)((Object)this.innerModel())).storageProfile().osDisk().vhd().uri();
    }

    @Override
    public CachingTypes osDiskCachingType() {
        return ((VirtualMachineInner)((Object)this.innerModel())).storageProfile().osDisk().caching();
    }

    @Override
    public int osDiskSize() {
        return ResourceManagerUtils.toPrimitiveInt((Integer)((VirtualMachineInner)((Object)this.innerModel())).storageProfile().osDisk().diskSizeGB());
    }

    @Override
    public StorageAccountTypes osDiskStorageAccountType() {
        if (!this.isManagedDiskEnabled() || this.storageProfile().osDisk().managedDisk() == null) {
            return null;
        }
        return this.storageProfile().osDisk().managedDisk().storageAccountType();
    }

    @Override
    public String osDiskId() {
        if (!this.isManagedDiskEnabled()) {
            return null;
        }
        return this.storageProfile().osDisk().managedDisk().id();
    }

    @Override
    public DeleteOptions osDiskDeleteOptions() {
        if (!this.isManagedDiskEnabled() || this.storageProfile().osDisk().deleteOption() == null) {
            return null;
        }
        return DeleteOptions.fromString(this.storageProfile().osDisk().deleteOption().toString());
    }

    @Override
    public String osDiskDiskEncryptionSetId() {
        if (!this.isManagedDiskEnabled() || this.storageProfile().osDisk().managedDisk() == null || this.storageProfile().osDisk().managedDisk().diskEncryptionSet() == null) {
            return null;
        }
        return this.storageProfile().osDisk().managedDisk().diskEncryptionSet().id();
    }

    @Override
    public boolean isOSDiskEphemeral() {
        return this.storageProfile().osDisk().diffDiskSettings() != null && this.storageProfile().osDisk().diffDiskSettings().placement() != null;
    }

    @Override
    public boolean isEncryptionAtHost() {
        return !Objects.isNull(((VirtualMachineInner)((Object)this.innerModel())).securityProfile()) && ((VirtualMachineInner)((Object)this.innerModel())).securityProfile().encryptionAtHost() != false;
    }

    @Override
    public Map<Integer, VirtualMachineUnmanagedDataDisk> unmanagedDataDisks() {
        HashMap<Integer, VirtualMachineUnmanagedDataDisk> dataDisks = new HashMap<Integer, VirtualMachineUnmanagedDataDisk>();
        if (!this.isManagedDiskEnabled()) {
            for (VirtualMachineUnmanagedDataDisk dataDisk : this.unmanagedDataDisks) {
                dataDisks.put(dataDisk.lun(), dataDisk);
            }
        }
        return Collections.unmodifiableMap(dataDisks);
    }

    @Override
    public Map<Integer, VirtualMachineDataDisk> dataDisks() {
        List<DataDisk> innerDataDisks;
        HashMap<Integer, VirtualMachineDataDiskImpl> dataDisks = new HashMap<Integer, VirtualMachineDataDiskImpl>();
        if (this.isManagedDiskEnabled() && (innerDataDisks = ((VirtualMachineInner)((Object)this.innerModel())).storageProfile().dataDisks()) != null) {
            for (DataDisk innerDataDisk : innerDataDisks) {
                dataDisks.put(innerDataDisk.lun(), new VirtualMachineDataDiskImpl(innerDataDisk));
            }
        }
        return Collections.unmodifiableMap(dataDisks);
    }

    public NetworkInterface getPrimaryNetworkInterface() {
        return (NetworkInterface)this.getPrimaryNetworkInterfaceAsync().block();
    }

    public Mono<NetworkInterface> getPrimaryNetworkInterfaceAsync() {
        return this.networkManager.networkInterfaces().getByIdAsync(this.primaryNetworkInterfaceId());
    }

    @Override
    public PublicIpAddress getPrimaryPublicIPAddress() {
        return this.getPrimaryNetworkInterface().primaryIPConfiguration().getPublicIpAddress();
    }

    @Override
    public String getPrimaryPublicIPAddressId() {
        return this.getPrimaryNetworkInterface().primaryIPConfiguration().publicIpAddressId();
    }

    public List<String> networkInterfaceIds() {
        ArrayList<String> nicIds = new ArrayList<String>();
        for (NetworkInterfaceReference nicRef : ((VirtualMachineInner)((Object)this.innerModel())).networkProfile().networkInterfaces()) {
            nicIds.add(nicRef.id());
        }
        return nicIds;
    }

    public String primaryNetworkInterfaceId() {
        List<NetworkInterfaceReference> nicRefs = ((VirtualMachineInner)((Object)this.innerModel())).networkProfile().networkInterfaces();
        String primaryNicRefId = null;
        if (nicRefs.size() == 1) {
            primaryNicRefId = nicRefs.get(0).id();
        } else if (nicRefs.size() == 0) {
            primaryNicRefId = null;
        } else {
            for (NetworkInterfaceReference nicRef : ((VirtualMachineInner)((Object)this.innerModel())).networkProfile().networkInterfaces()) {
                if (nicRef.primary() == null || !nicRef.primary().booleanValue()) continue;
                primaryNicRefId = nicRef.id();
                break;
            }
            if (primaryNicRefId == null) {
                primaryNicRefId = nicRefs.get(0).id();
            }
        }
        return primaryNicRefId;
    }

    @Override
    public String availabilitySetId() {
        if (((VirtualMachineInner)((Object)this.innerModel())).availabilitySet() != null) {
            return ((VirtualMachineInner)((Object)this.innerModel())).availabilitySet().id();
        }
        return null;
    }

    @Override
    public String virtualMachineScaleSetId() {
        if (((VirtualMachineInner)((Object)this.innerModel())).virtualMachineScaleSet() != null) {
            return ((VirtualMachineInner)((Object)this.innerModel())).virtualMachineScaleSet().id();
        }
        return null;
    }

    @Override
    public String provisioningState() {
        return ((VirtualMachineInner)((Object)this.innerModel())).provisioningState();
    }

    @Override
    public String licenseType() {
        return ((VirtualMachineInner)((Object)this.innerModel())).licenseType();
    }

    @Override
    public ProximityPlacementGroup proximityPlacementGroup() {
        if (((VirtualMachineInner)((Object)this.innerModel())).proximityPlacementGroup() == null) {
            return null;
        }
        ResourceId id = ResourceId.fromString((String)((VirtualMachineInner)((Object)this.innerModel())).proximityPlacementGroup().id());
        ProximityPlacementGroupInner plgInner = ((ComputeManagementClient)((ComputeManager)this.manager()).serviceClient()).getProximityPlacementGroups().getByResourceGroup(id.resourceGroupName(), id.name());
        if (plgInner == null) {
            return null;
        }
        return new ProximityPlacementGroupImpl(plgInner);
    }

    @Override
    public Mono<List<VirtualMachineExtension>> listExtensionsAsync() {
        return this.virtualMachineExtensions.listAsync();
    }

    @Override
    public Map<String, VirtualMachineExtension> listExtensions() {
        return this.virtualMachineExtensions.asMap();
    }

    @Override
    public Plan plan() {
        return ((VirtualMachineInner)((Object)this.innerModel())).plan();
    }

    @Override
    public StorageProfile storageProfile() {
        return ((VirtualMachineInner)((Object)this.innerModel())).storageProfile();
    }

    @Override
    public OSProfile osProfile() {
        return ((VirtualMachineInner)((Object)this.innerModel())).osProfile();
    }

    @Override
    public DiagnosticsProfile diagnosticsProfile() {
        return ((VirtualMachineInner)((Object)this.innerModel())).diagnosticsProfile();
    }

    @Override
    public String vmId() {
        return ((VirtualMachineInner)((Object)this.innerModel())).vmId();
    }

    @Override
    public VirtualMachineInstanceView instanceView() {
        if (this.virtualMachineInstanceView == null) {
            this.refreshInstanceView();
        }
        return this.virtualMachineInstanceView;
    }

    @Override
    public Set<AvailabilityZoneId> availabilityZones() {
        HashSet<AvailabilityZoneId> zones = new HashSet<AvailabilityZoneId>();
        if (((VirtualMachineInner)((Object)this.innerModel())).zones() != null) {
            for (String zone : ((VirtualMachineInner)((Object)this.innerModel())).zones()) {
                zones.add(AvailabilityZoneId.fromString((String)zone));
            }
        }
        return Collections.unmodifiableSet(zones);
    }

    @Override
    public PowerState powerState() {
        return PowerState.fromInstanceView(this.instanceView());
    }

    @Override
    public boolean isBootDiagnosticsEnabled() {
        return this.bootDiagnosticsHandler.isBootDiagnosticsEnabled();
    }

    @Override
    public String bootDiagnosticsStorageUri() {
        return this.bootDiagnosticsHandler.bootDiagnosticsStorageUri();
    }

    @Override
    public boolean isManagedServiceIdentityEnabled() {
        ResourceIdentityType type = this.managedServiceIdentityType();
        return type != null && !type.equals((Object)ResourceIdentityType.NONE);
    }

    @Override
    public String systemAssignedManagedServiceIdentityTenantId() {
        if (((VirtualMachineInner)((Object)this.innerModel())).identity() != null) {
            return ((VirtualMachineInner)((Object)this.innerModel())).identity().tenantId();
        }
        return null;
    }

    @Override
    public String systemAssignedManagedServiceIdentityPrincipalId() {
        if (((VirtualMachineInner)((Object)this.innerModel())).identity() != null) {
            return ((VirtualMachineInner)((Object)this.innerModel())).identity().principalId();
        }
        return null;
    }

    @Override
    public ResourceIdentityType managedServiceIdentityType() {
        if (((VirtualMachineInner)((Object)this.innerModel())).identity() != null) {
            return ((VirtualMachineInner)((Object)this.innerModel())).identity().type();
        }
        return null;
    }

    @Override
    public Set<String> userAssignedManagedServiceIdentityIds() {
        if (((VirtualMachineInner)((Object)this.innerModel())).identity() != null && ((VirtualMachineInner)((Object)this.innerModel())).identity().userAssignedIdentities() != null) {
            return Collections.unmodifiableSet(new HashSet<String>(((VirtualMachineInner)((Object)this.innerModel())).identity().userAssignedIdentities().keySet()));
        }
        return Collections.unmodifiableSet(new HashSet());
    }

    @Override
    public BillingProfile billingProfile() {
        return ((VirtualMachineInner)((Object)this.innerModel())).billingProfile();
    }

    @Override
    public boolean isHibernationEnabled() {
        return ((VirtualMachineInner)((Object)this.innerModel())).additionalCapabilities() != null && ResourceManagerUtils.toPrimitiveBoolean((Boolean)((VirtualMachineInner)((Object)this.innerModel())).additionalCapabilities().hibernationEnabled());
    }

    @Override
    public boolean isUltraSsdEnabled() {
        return ((VirtualMachineInner)((Object)this.innerModel())).additionalCapabilities() != null && ResourceManagerUtils.toPrimitiveBoolean((Boolean)((VirtualMachineInner)((Object)this.innerModel())).additionalCapabilities().ultraSsdEnabled());
    }

    @Override
    public SecurityTypes securityType() {
        SecurityProfile securityProfile = ((VirtualMachineInner)((Object)this.innerModel())).securityProfile();
        if (securityProfile == null) {
            return null;
        }
        return securityProfile.securityType();
    }

    @Override
    public boolean isSecureBootEnabled() {
        return this.securityType() != null && ((VirtualMachineInner)((Object)this.innerModel())).securityProfile().uefiSettings() != null && ResourceManagerUtils.toPrimitiveBoolean((Boolean)((VirtualMachineInner)((Object)this.innerModel())).securityProfile().uefiSettings().secureBootEnabled());
    }

    @Override
    public boolean isVTpmEnabled() {
        return this.securityType() != null && ((VirtualMachineInner)((Object)this.innerModel())).securityProfile().uefiSettings() != null && ResourceManagerUtils.toPrimitiveBoolean((Boolean)((VirtualMachineInner)((Object)this.innerModel())).securityProfile().uefiSettings().vTpmEnabled());
    }

    @Override
    public OffsetDateTime timeCreated() {
        return ((VirtualMachineInner)((Object)this.innerModel())).timeCreated();
    }

    @Override
    public DeleteOptions primaryNetworkInterfaceDeleteOptions() {
        String nicId = this.primaryNetworkInterfaceId();
        return this.networkInterfaceDeleteOptions(nicId);
    }

    @Override
    public DeleteOptions networkInterfaceDeleteOptions(String networkInterfaceId) {
        if (CoreUtils.isNullOrEmpty((CharSequence)networkInterfaceId) || ((VirtualMachineInner)((Object)this.innerModel())).networkProfile() == null || ((VirtualMachineInner)((Object)this.innerModel())).networkProfile().networkInterfaces() == null) {
            return null;
        }
        return ((VirtualMachineInner)((Object)this.innerModel())).networkProfile().networkInterfaces().stream().filter(nic -> networkInterfaceId.equalsIgnoreCase(nic.id())).findAny().map(NetworkInterfaceReference::deleteOption).orElse(null);
    }

    @Override
    public VirtualMachinePriorityTypes priority() {
        return ((VirtualMachineInner)((Object)this.innerModel())).priority();
    }

    @Override
    public VirtualMachineEvictionPolicyTypes evictionPolicy() {
        return ((VirtualMachineInner)((Object)this.innerModel())).evictionPolicy();
    }

    @Override
    public String userData() {
        return ((VirtualMachineInner)((Object)this.innerModel())).userData();
    }

    public void beforeGroupCreateOrUpdate() {
        if (this.creatableStorageAccountKey == null && this.existingStorageAccountToAssociate == null && (this.osDiskRequiresImplicitStorageAccountCreation() || this.dataDisksRequiresImplicitStorageAccountCreation())) {
            Creatable storageAccountCreatable = null;
            storageAccountCreatable = this.creatableGroup != null ? (Creatable)((StorageAccount.DefinitionStages.WithGroup)((StorageAccount.DefinitionStages.Blank)this.storageManager.storageAccounts().define(this.namer.getRandomName("stg", 24).replace("-", ""))).withRegion(this.regionName())).withNewResourceGroup(this.creatableGroup) : (Creatable)((StorageAccount.DefinitionStages.WithGroup)((StorageAccount.DefinitionStages.Blank)this.storageManager.storageAccounts().define(this.namer.getRandomName("stg", 24).replace("-", ""))).withRegion(this.regionName())).withExistingResourceGroup(this.resourceGroupName());
            this.creatableStorageAccountKey = this.addDependency(storageAccountCreatable);
        }
        this.bootDiagnosticsHandler.prepare();
    }

    public Mono<VirtualMachine> createResourceAsync() {
        return this.prepareCreateResourceAsync().flatMap(virtualMachine -> ((ComputeManagementClient)((ComputeManager)this.manager()).serviceClient()).getVirtualMachines().createOrUpdateAsync(this.resourceGroupName(), this.vmName, (VirtualMachineInner)((Object)((Object)this.innerModel()))).map(virtualMachineInner -> {
            this.reset((VirtualMachineInner)((Object)((Object)virtualMachineInner)));
            return this;
        }));
    }

    private Mono<VirtualMachine> prepareCreateResourceAsync() {
        this.setOSDiskDefaults();
        this.setOSProfileDefaults();
        this.setHardwareProfileDefaults();
        if (this.isManagedDiskEnabled()) {
            this.managedDataDisks.setDataDisksDefaults();
        } else {
            UnmanagedDataDiskImpl.setDataDisksDefaults(this.unmanagedDataDisks, this.vmName);
        }
        this.handleUnManagedOSAndDataDisksStorageSettings();
        this.bootDiagnosticsHandler.handleDiagnosticsSettings();
        this.handleNetworkSettings();
        return this.createNewProximityPlacementGroupAsync().map(virtualMachine -> {
            this.handleAvailabilitySettings();
            this.virtualMachineMsiHandler.processCreatedExternalIdentities();
            this.virtualMachineMsiHandler.handleExternalIdentities();
            return virtualMachine;
        });
    }

    @Override
    public Accepted<VirtualMachine> beginCreate() {
        return AcceptedImpl.newAccepted((ClientLogger)this.logger, (HttpPipeline)((ComputeManagementClient)((ComputeManager)this.manager()).serviceClient()).getHttpPipeline(), (Duration)((ComputeManagementClient)((ComputeManager)this.manager()).serviceClient()).getDefaultPollInterval(), () -> (Response)((ComputeManagementClient)((ComputeManager)this.manager()).serviceClient()).getVirtualMachines().createOrUpdateWithResponseAsync(this.resourceGroupName(), this.vmName, (VirtualMachineInner)((Object)((Object)this.innerModel())), null, null).block(), inner -> new VirtualMachineImpl(inner.name(), (VirtualMachineInner)((Object)inner), (ComputeManager)this.manager(), this.storageManager, this.networkManager, this.authorizationManager), VirtualMachineInner.class, () -> {
            Flux dependencyTasksAsync = this.taskGroup().invokeDependencyAsync(this.taskGroup().newInvocationContext());
            dependencyTasksAsync.blockLast();
            this.prepareCreateResourceAsync().block();
        }, this::reset, (Context)Context.NONE);
    }

    public Mono<VirtualMachine> updateResourceAsync() {
        if (this.isManagedDiskEnabled()) {
            this.managedDataDisks.setDataDisksDefaults();
        } else {
            UnmanagedDataDiskImpl.setDataDisksDefaults(this.unmanagedDataDisks, this.vmName);
        }
        this.handleUnManagedOSAndDataDisksStorageSettings();
        this.bootDiagnosticsHandler.handleDiagnosticsSettings();
        this.handleNetworkSettings();
        this.handleAvailabilitySettings();
        this.virtualMachineMsiHandler.processCreatedExternalIdentities();
        VirtualMachineUpdateInner updateParameter = new VirtualMachineUpdateInner();
        this.copyInnerToUpdateParameter(updateParameter);
        this.virtualMachineMsiHandler.handleExternalIdentities(updateParameter);
        boolean vmModified = this.isVirtualMachineModifiedDuringUpdate(updateParameter);
        if (vmModified) {
            return ((ComputeManagementClient)((ComputeManager)this.manager()).serviceClient()).getVirtualMachines().updateAsync(this.resourceGroupName(), this.vmName, updateParameter).map(virtualMachineInner -> {
                this.reset((VirtualMachineInner)((Object)virtualMachineInner));
                return this;
            });
        }
        return Mono.just((Object)this);
    }

    public Mono<Void> afterPostRunAsync(boolean isGroupFaulted) {
        this.virtualMachineExtensions.clear();
        if (isGroupFaulted) {
            return Mono.empty();
        }
        return this.refreshAsync().then();
    }

    VirtualMachineImpl withExtension(VirtualMachineExtensionImpl extension) {
        this.virtualMachineExtensions.addExtension(extension);
        return this;
    }

    static String serializeCaptureResult(VirtualMachineCaptureResultInner captureResultInner, ClientLogger logger) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        resultMap.put("id", captureResultInner.id());
        resultMap.put("contentVersion", captureResultInner.contentVersion());
        resultMap.put("schema", captureResultInner.schema());
        resultMap.put("resources", captureResultInner.resources());
        resultMap.put("parameters", captureResultInner.parameters());
        try {
            return SerializerFactory.createDefaultManagementSerializerAdapter().serialize(resultMap, SerializerEncoding.JSON);
        }
        catch (IOException e) {
            throw logger.logExceptionAsError(Exceptions.propagate((Throwable)e));
        }
    }

    private void reset(VirtualMachineInner inner) {
        this.setInner((Object)inner);
        this.clearCachedRelatedResources();
        this.initializeDataDisks();
        this.virtualMachineMsiHandler.clear();
        this.creatableSecondaryNetworkInterfaceKeys.clear();
        this.existingSecondaryNetworkInterfacesToAssociate.clear();
        this.secondaryNetworkInterfaceDeleteOptions.clear();
        this.primaryNetworkInterfaceDeleteOptions = null;
    }

    VirtualMachineImpl withUnmanagedDataDisk(UnmanagedDataDiskImpl dataDisk) {
        ((VirtualMachineInner)((Object)this.innerModel())).storageProfile().dataDisks().add((DataDisk)dataDisk.innerModel());
        this.unmanagedDataDisks.add(dataDisk);
        return this;
    }

    @Override
    public VirtualMachineImpl withAvailabilityZone(AvailabilityZoneId zoneId) {
        if (this.isInCreateMode()) {
            if (((VirtualMachineInner)((Object)this.innerModel())).zones() == null) {
                ((VirtualMachineInner)((Object)this.innerModel())).withZones(new ArrayList<String>());
            }
            ((VirtualMachineInner)((Object)this.innerModel())).zones().add(zoneId.toString());
            if (this.implicitPipCreatable != null) {
                this.implicitPipCreatable.withAvailabilityZone(zoneId).withSku(PublicIPSkuType.STANDARD).withStaticIP();
            }
        }
        return this;
    }

    @Override
    public VirtualMachineImpl withOsDiskDeleteOptions(DeleteOptions deleteOptions) {
        if (deleteOptions == null || ((VirtualMachineInner)((Object)this.innerModel())).storageProfile() == null || ((VirtualMachineInner)((Object)this.innerModel())).storageProfile().osDisk() == null) {
            return null;
        }
        ((VirtualMachineInner)((Object)this.innerModel())).storageProfile().osDisk().withDeleteOption(this.diskDeleteOptionsFromDeleteOptions(deleteOptions));
        return this;
    }

    @Override
    public VirtualMachineImpl withPrimaryNetworkInterfaceDeleteOptions(DeleteOptions deleteOptions) {
        this.primaryNetworkInterfaceDeleteOptions = deleteOptions;
        return this;
    }

    @Override
    public VirtualMachineImpl withNetworkInterfacesDeleteOptions(DeleteOptions deleteOptions, String ... nicIds) {
        if (((VirtualMachineInner)((Object)this.innerModel())).networkProfile() != null && ((VirtualMachineInner)((Object)this.innerModel())).networkProfile().networkInterfaces() != null) {
            Set nicIdSet = Arrays.stream(nicIds).map(nicId -> nicId.toLowerCase(Locale.ROOT)).collect(Collectors.toSet());
            ((VirtualMachineInner)((Object)this.innerModel())).networkProfile().networkInterfaces().forEach(nic -> {
                if (nicIdSet.contains(nic.id().toLowerCase(Locale.ROOT))) {
                    nic.withDeleteOption(deleteOptions);
                }
            });
        }
        return this;
    }

    @Override
    public VirtualMachineImpl withNetworkInterfacesDeleteOptions(DeleteOptions deleteOptions) {
        ((VirtualMachineInner)((Object)this.innerModel())).networkProfile().networkInterfaces().forEach(nic -> nic.withDeleteOption(deleteOptions));
        return this;
    }

    @Override
    public VirtualMachineImpl withDataDisksDeleteOptions(DeleteOptions deleteOptions, Integer ... luns) {
        if (((VirtualMachineInner)((Object)this.innerModel())).storageProfile() != null && ((VirtualMachineInner)((Object)this.innerModel())).storageProfile().dataDisks() != null) {
            Set lunSet = Arrays.stream(luns).filter(Objects::nonNull).collect(Collectors.toSet());
            ((VirtualMachineInner)((Object)this.innerModel())).storageProfile().dataDisks().forEach(dataDisk -> {
                if (lunSet.contains(dataDisk.lun())) {
                    dataDisk.withDeleteOption(this.diskDeleteOptionsFromDeleteOptions(deleteOptions));
                }
            });
        }
        return this;
    }

    @Override
    public VirtualMachineImpl withDataDisksDeleteOptions(DeleteOptions deleteOptions) {
        ((VirtualMachineInner)((Object)this.innerModel())).storageProfile().dataDisks().forEach(dataDisk -> dataDisk.withDeleteOption(this.diskDeleteOptionsFromDeleteOptions(deleteOptions)));
        return this;
    }

    AzureEnvironment environment() {
        return ((ComputeManager)this.manager()).environment();
    }

    private void setOSDiskDefaults() {
        if (this.isInUpdateMode()) {
            return;
        }
        StorageProfile storageProfile = ((VirtualMachineInner)((Object)this.innerModel())).storageProfile();
        OSDisk osDisk = storageProfile.osDisk();
        if (this.isOSDiskFromImage(osDisk)) {
            if (this.isManagedDiskEnabled()) {
                if (osDisk.managedDisk() == null) {
                    osDisk.withManagedDisk(new ManagedDiskParameters());
                }
                if (osDisk.managedDisk().storageAccountType() == null) {
                    osDisk.managedDisk().withStorageAccountType(StorageAccountTypes.STANDARD_LRS);
                }
                osDisk.withVhd(null);
            } else {
                if (this.isOSDiskFromPlatformImage(storageProfile) || this.isOSDiskFromStoredImage(storageProfile)) {
                    if (osDisk.vhd() == null) {
                        String osDiskVhdContainerName = "vhds";
                        String osDiskVhdName = this.vmName + "-os-disk-" + UUID.randomUUID().toString() + ".vhd";
                        this.withOSDiskVhdLocation(osDiskVhdContainerName, osDiskVhdName);
                    }
                    osDisk.withManagedDisk(null);
                }
                if (osDisk.name() == null) {
                    this.withOSDiskName(this.vmName + "-os-disk");
                }
            }
        } else if (this.isManagedDiskEnabled()) {
            if (osDisk.managedDisk() != null) {
                osDisk.managedDisk().withStorageAccountType(null);
            }
            osDisk.withVhd(null);
        } else {
            osDisk.withManagedDisk(null);
            if (osDisk.name() == null) {
                this.withOSDiskName(this.vmName + "-os-disk");
            }
        }
        if (osDisk.caching() == null) {
            this.withOSDiskCaching(CachingTypes.READ_WRITE);
        }
    }

    private void setOSProfileDefaults() {
        if (this.isInUpdateMode()) {
            return;
        }
        StorageProfile storageProfile = ((VirtualMachineInner)((Object)this.innerModel())).storageProfile();
        OSDisk osDisk = storageProfile.osDisk();
        if (!this.removeOsProfile && this.isOSDiskFromImage(osDisk)) {
            if (osDisk.osType() == OperatingSystemTypes.LINUX || this.isMarketplaceLinuxImage) {
                OSProfile osProfile = ((VirtualMachineInner)((Object)this.innerModel())).osProfile();
                if (osProfile.linuxConfiguration() == null) {
                    osProfile.withLinuxConfiguration(new LinuxConfiguration());
                }
                ((VirtualMachineInner)((Object)this.innerModel())).osProfile().linuxConfiguration().withDisablePasswordAuthentication(osProfile.adminPassword() == null);
            }
            if (((VirtualMachineInner)((Object)this.innerModel())).osProfile().computerName() == null) {
                if (this.vmName.matches("[0-9]+")) {
                    ((VirtualMachineInner)((Object)this.innerModel())).osProfile().withComputerName(this.namer.getRandomName("vm", 15));
                } else if (this.vmName.length() <= 15) {
                    ((VirtualMachineInner)((Object)this.innerModel())).osProfile().withComputerName(this.vmName);
                } else {
                    ((VirtualMachineInner)((Object)this.innerModel())).osProfile().withComputerName(this.namer.getRandomName("vm", 15));
                }
            }
        } else {
            ((VirtualMachineInner)((Object)this.innerModel())).withOsProfile(null);
        }
    }

    private void setHardwareProfileDefaults() {
        if (!this.isInCreateMode()) {
            return;
        }
        HardwareProfile hardwareProfile = ((VirtualMachineInner)((Object)this.innerModel())).hardwareProfile();
        if (hardwareProfile.vmSize() == null) {
            hardwareProfile.withVmSize(VirtualMachineSizeTypes.BASIC_A0);
        }
    }

    private void handleUnManagedOSAndDataDisksStorageSettings() {
        if (this.isManagedDiskEnabled()) {
            return;
        }
        StorageAccount storageAccount = null;
        if (this.creatableStorageAccountKey != null) {
            storageAccount = (StorageAccount)this.taskResult(this.creatableStorageAccountKey);
        } else if (this.existingStorageAccountToAssociate != null) {
            storageAccount = this.existingStorageAccountToAssociate;
        }
        if (this.isInCreateMode()) {
            if (storageAccount != null) {
                if (this.isOSDiskFromPlatformImage(((VirtualMachineInner)((Object)this.innerModel())).storageProfile())) {
                    String uri = ((VirtualMachineInner)((Object)this.innerModel())).storageProfile().osDisk().vhd().uri().replaceFirst("\\{storage-base-url}", storageAccount.endPoints().primary().blob());
                    ((VirtualMachineInner)((Object)this.innerModel())).storageProfile().osDisk().vhd().withUri(uri);
                }
                UnmanagedDataDiskImpl.ensureDisksVhdUri(this.unmanagedDataDisks, storageAccount, this.vmName);
            }
        } else if (storageAccount != null) {
            UnmanagedDataDiskImpl.ensureDisksVhdUri(this.unmanagedDataDisks, storageAccount, this.vmName);
        } else {
            UnmanagedDataDiskImpl.ensureDisksVhdUri(this.unmanagedDataDisks, this.vmName);
        }
    }

    private Mono<VirtualMachineImpl> createNewProximityPlacementGroupAsync() {
        if (this.isInCreateMode() && this.newProximityPlacementGroupName != null && !this.newProximityPlacementGroupName.isEmpty()) {
            ProximityPlacementGroupInner plgInner = new ProximityPlacementGroupInner();
            plgInner.withProximityPlacementGroupType(this.newProximityPlacementGroupType);
            plgInner.withLocation(((VirtualMachineInner)((Object)this.innerModel())).location());
            return ((ComputeManagementClient)((ComputeManager)this.manager()).serviceClient()).getProximityPlacementGroups().createOrUpdateAsync(this.resourceGroupName(), this.newProximityPlacementGroupName, plgInner).map(createdPlgInner -> {
                ((VirtualMachineInner)((Object)((Object)this.innerModel()))).withProximityPlacementGroup(new SubResource().withId(createdPlgInner.id()));
                return this;
            });
        }
        return Mono.just((Object)this);
    }

    private void handleNetworkSettings() {
        String primaryNetworkInterfaceId;
        if (this.isInCreateMode()) {
            NetworkInterface primaryNetworkInterface = null;
            if (this.creatablePrimaryNetworkInterfaceKey != null) {
                primaryNetworkInterface = (NetworkInterface)this.taskResult(this.creatablePrimaryNetworkInterfaceKey);
            } else if (this.existingPrimaryNetworkInterfaceToAssociate != null) {
                primaryNetworkInterface = this.existingPrimaryNetworkInterfaceToAssociate;
            }
            if (primaryNetworkInterface != null) {
                NetworkInterfaceReference nicReference = new NetworkInterfaceReference();
                nicReference.withPrimary(true);
                nicReference.withId(primaryNetworkInterface.id());
                ((VirtualMachineInner)((Object)this.innerModel())).networkProfile().networkInterfaces().add(nicReference);
            }
        }
        if (this.primaryNetworkInterfaceDeleteOptions != null && (primaryNetworkInterfaceId = this.primaryNetworkInterfaceId()) != null) {
            ((VirtualMachineInner)((Object)this.innerModel())).networkProfile().networkInterfaces().stream().filter(nic -> primaryNetworkInterfaceId.equals(nic.id())).forEach(nic -> nic.withDeleteOption(this.primaryNetworkInterfaceDeleteOptions));
        }
        for (String creatableSecondaryNetworkInterfaceKey : this.creatableSecondaryNetworkInterfaceKeys) {
            NetworkInterface secondaryNetworkInterface = (NetworkInterface)this.taskResult(creatableSecondaryNetworkInterfaceKey);
            NetworkInterfaceReference nicReference = new NetworkInterfaceReference();
            nicReference.withPrimary(false);
            nicReference.withId(secondaryNetworkInterface.id());
            if (this.secondaryNetworkInterfaceDeleteOptions.containsKey(creatableSecondaryNetworkInterfaceKey)) {
                DeleteOptions deleteOptions = this.secondaryNetworkInterfaceDeleteOptions.get(creatableSecondaryNetworkInterfaceKey);
                nicReference.withDeleteOption(deleteOptions);
            }
            ((VirtualMachineInner)((Object)this.innerModel())).networkProfile().networkInterfaces().add(nicReference);
        }
        for (NetworkInterface secondaryNetworkInterface : this.existingSecondaryNetworkInterfacesToAssociate) {
            NetworkInterfaceReference nicReference = new NetworkInterfaceReference();
            nicReference.withPrimary(false);
            nicReference.withId(secondaryNetworkInterface.id());
            ((VirtualMachineInner)((Object)this.innerModel())).networkProfile().networkInterfaces().add(nicReference);
        }
    }

    private void handleAvailabilitySettings() {
        if (!this.isInCreateMode()) {
            return;
        }
        AvailabilitySet availabilitySet = null;
        if (this.creatableAvailabilitySetKey != null) {
            availabilitySet = (AvailabilitySet)this.taskResult(this.creatableAvailabilitySetKey);
        } else if (this.existingAvailabilitySetToAssociate != null) {
            availabilitySet = this.existingAvailabilitySetToAssociate;
        }
        if (availabilitySet != null) {
            if (((VirtualMachineInner)((Object)this.innerModel())).availabilitySet() == null) {
                ((VirtualMachineInner)((Object)this.innerModel())).withAvailabilitySet(new SubResource());
            }
            ((VirtualMachineInner)((Object)this.innerModel())).availabilitySet().withId(availabilitySet.id());
        }
    }

    private boolean osDiskRequiresImplicitStorageAccountCreation() {
        if (this.isManagedDiskEnabled()) {
            return false;
        }
        if (this.creatableStorageAccountKey != null || this.existingStorageAccountToAssociate != null || !this.isInCreateMode()) {
            return false;
        }
        return this.isOSDiskFromPlatformImage(((VirtualMachineInner)((Object)this.innerModel())).storageProfile());
    }

    private boolean dataDisksRequiresImplicitStorageAccountCreation() {
        if (this.isManagedDiskEnabled()) {
            return false;
        }
        if (this.creatableStorageAccountKey != null || this.existingStorageAccountToAssociate != null || this.unmanagedDataDisks.size() == 0) {
            return false;
        }
        boolean hasEmptyVhd = false;
        for (VirtualMachineUnmanagedDataDisk dataDisk : this.unmanagedDataDisks) {
            if (dataDisk.creationMethod() != DiskCreateOptionTypes.EMPTY && dataDisk.creationMethod() != DiskCreateOptionTypes.FROM_IMAGE || ((DataDisk)dataDisk.innerModel()).vhd() != null) continue;
            hasEmptyVhd = true;
            break;
        }
        if (this.isInCreateMode()) {
            return hasEmptyVhd;
        }
        if (hasEmptyVhd) {
            for (VirtualMachineUnmanagedDataDisk dataDisk : this.unmanagedDataDisks) {
                if (dataDisk.creationMethod() != DiskCreateOptionTypes.ATTACH || ((DataDisk)dataDisk.innerModel()).vhd() == null) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean isOSDiskAttachedUnmanaged(OSDisk osDisk) {
        return osDisk.createOption() == DiskCreateOptionTypes.ATTACH && osDisk.vhd() != null && osDisk.vhd().uri() != null;
    }

    private boolean isOSDiskAttachedManaged(OSDisk osDisk) {
        return osDisk.createOption() == DiskCreateOptionTypes.ATTACH && osDisk.managedDisk() != null && osDisk.managedDisk().id() != null;
    }

    private boolean isOSDiskFromImage(OSDisk osDisk) {
        return osDisk.createOption() == DiskCreateOptionTypes.FROM_IMAGE;
    }

    private boolean isOSDiskFromPlatformImage(StorageProfile storageProfile) {
        ImageReference imageReference = storageProfile.imageReference();
        return this.isOSDiskFromImage(storageProfile.osDisk()) && imageReference != null && imageReference.publisher() != null && imageReference.offer() != null && imageReference.sku() != null && imageReference.version() != null;
    }

    private boolean isOsDiskFromCustomImage(StorageProfile storageProfile) {
        ImageReference imageReference = storageProfile.imageReference();
        return this.isOSDiskFromImage(storageProfile.osDisk()) && imageReference != null && imageReference.id() != null;
    }

    private boolean isOSDiskFromStoredImage(StorageProfile storageProfile) {
        OSDisk osDisk = storageProfile.osDisk();
        return this.isOSDiskFromImage(osDisk) && osDisk.image() != null && osDisk.image().uri() != null;
    }

    private String temporaryBlobUrl(String containerName, String blobName) {
        return "{storage-base-url}" + containerName + "/" + blobName;
    }

    private NetworkInterface.DefinitionStages.WithPrimaryPublicIPAddress prepareNetworkInterface(String name) {
        NetworkInterface.DefinitionStages.WithGroup definitionWithGroup = (NetworkInterface.DefinitionStages.WithGroup)((NetworkInterface.DefinitionStages.Blank)this.networkManager.networkInterfaces().define(name)).withRegion(this.regionName());
        NetworkInterface.DefinitionStages.WithPrimaryNetwork definitionWithNetwork = this.creatableGroup != null ? (NetworkInterface.DefinitionStages.WithPrimaryNetwork)definitionWithGroup.withNewResourceGroup(this.creatableGroup) : (NetworkInterface.DefinitionStages.WithPrimaryNetwork)definitionWithGroup.withExistingResourceGroup(this.resourceGroupName());
        return definitionWithNetwork.withNewPrimaryNetwork("vnet" + name).withPrimaryPrivateIPAddressDynamic();
    }

    private void initializeDataDisks() {
        if (((VirtualMachineInner)((Object)this.innerModel())).storageProfile().dataDisks() == null) {
            ((VirtualMachineInner)((Object)this.innerModel())).storageProfile().withDataDisks(new ArrayList<DataDisk>());
        }
        this.isUnmanagedDiskSelected = false;
        this.managedDataDisks.clear();
        this.unmanagedDataDisks = new ArrayList<VirtualMachineUnmanagedDataDisk>();
        if (!this.isManagedDiskEnabled()) {
            for (DataDisk dataDiskInner : this.storageProfile().dataDisks()) {
                this.unmanagedDataDisks.add(new UnmanagedDataDiskImpl(dataDiskInner, this));
            }
        }
    }

    private NetworkInterface.DefinitionStages.WithPrimaryNetwork preparePrimaryNetworkInterface(String name) {
        NetworkInterface.DefinitionStages.WithGroup definitionWithGroup = (NetworkInterface.DefinitionStages.WithGroup)((NetworkInterface.DefinitionStages.Blank)this.networkManager.networkInterfaces().define(name)).withRegion(this.regionName());
        NetworkInterface.DefinitionStages.WithPrimaryNetwork definitionAfterGroup = this.creatableGroup != null ? (NetworkInterface.DefinitionStages.WithPrimaryNetwork)definitionWithGroup.withNewResourceGroup(this.creatableGroup) : (NetworkInterface.DefinitionStages.WithPrimaryNetwork)definitionWithGroup.withExistingResourceGroup(this.resourceGroupName());
        return definitionAfterGroup;
    }

    private void clearCachedRelatedResources() {
        this.virtualMachineInstanceView = null;
    }

    private void throwIfManagedDiskEnabled(String message) {
        if (this.isManagedDiskEnabled()) {
            throw this.logger.logExceptionAsError((RuntimeException)new UnsupportedOperationException(message));
        }
    }

    private void throwIfManagedDiskDisabled(String message) {
        if (!this.isManagedDiskEnabled()) {
            throw this.logger.logExceptionAsError((RuntimeException)new UnsupportedOperationException(message));
        }
    }

    private boolean isInUpdateMode() {
        return !this.isInCreateMode();
    }

    private DiskDeleteOptionTypes diskDeleteOptionsFromDeleteOptions(DeleteOptions deleteOptions) {
        return deleteOptions == null ? null : DiskDeleteOptionTypes.fromString(deleteOptions.toString());
    }

    boolean isVirtualMachineModifiedDuringUpdate(VirtualMachineUpdateInner updateParameter) {
        if (this.updateParameterSnapshotOnUpdate == null || updateParameter == null) {
            return true;
        }
        try {
            String jsonStrSnapshot = SERIALIZER_ADAPTER.serialize((Object)this.updateParameterSnapshotOnUpdate, SerializerEncoding.JSON);
            String jsonStr = SERIALIZER_ADAPTER.serialize((Object)updateParameter, SerializerEncoding.JSON);
            return !jsonStr.equals(jsonStrSnapshot);
        }
        catch (IOException e) {
            return true;
        }
    }

    VirtualMachineUpdateInner deepCopyInnerToUpdateParameter() {
        VirtualMachineUpdateInner updateParameter = new VirtualMachineUpdateInner();
        this.copyInnerToUpdateParameter(updateParameter);
        try {
            String jsonStr = SERIALIZER_ADAPTER.serialize((Object)updateParameter, SerializerEncoding.JSON);
            updateParameter = (VirtualMachineUpdateInner)SERIALIZER_ADAPTER.deserialize(jsonStr, VirtualMachineUpdateInner.class, SerializerEncoding.JSON);
        }
        catch (IOException e) {
            return null;
        }
        if (((VirtualMachineInner)((Object)this.innerModel())).identity() != null) {
            VirtualMachineIdentity identity = new VirtualMachineIdentity();
            identity.withType(((VirtualMachineInner)((Object)this.innerModel())).identity().type());
            updateParameter.withIdentity(identity);
        }
        return updateParameter;
    }

    private void copyInnerToUpdateParameter(VirtualMachineUpdateInner updateParameter) {
        updateParameter.withHardwareProfile(((VirtualMachineInner)((Object)this.innerModel())).hardwareProfile());
        updateParameter.withStorageProfile(((VirtualMachineInner)((Object)this.innerModel())).storageProfile());
        updateParameter.withOsProfile(((VirtualMachineInner)((Object)this.innerModel())).osProfile());
        updateParameter.withNetworkProfile(((VirtualMachineInner)((Object)this.innerModel())).networkProfile());
        updateParameter.withDiagnosticsProfile(((VirtualMachineInner)((Object)this.innerModel())).diagnosticsProfile());
        updateParameter.withBillingProfile(((VirtualMachineInner)((Object)this.innerModel())).billingProfile());
        updateParameter.withSecurityProfile(((VirtualMachineInner)((Object)this.innerModel())).securityProfile());
        updateParameter.withAdditionalCapabilities(((VirtualMachineInner)((Object)this.innerModel())).additionalCapabilities());
        updateParameter.withAvailabilitySet(((VirtualMachineInner)((Object)this.innerModel())).availabilitySet());
        updateParameter.withLicenseType(((VirtualMachineInner)((Object)this.innerModel())).licenseType());
        updateParameter.withZones(((VirtualMachineInner)((Object)this.innerModel())).zones());
        updateParameter.withTags(((VirtualMachineInner)((Object)this.innerModel())).tags());
        updateParameter.withProximityPlacementGroup(((VirtualMachineInner)((Object)this.innerModel())).proximityPlacementGroup());
        updateParameter.withPriority(((VirtualMachineInner)((Object)this.innerModel())).priority());
        updateParameter.withEvictionPolicy(((VirtualMachineInner)((Object)this.innerModel())).evictionPolicy());
        updateParameter.withUserData(((VirtualMachineInner)((Object)this.innerModel())).userData());
    }

    RoleAssignmentHelper.IdProvider idProvider() {
        return new RoleAssignmentHelper.IdProvider(){

            public String principalId() {
                if (VirtualMachineImpl.this.innerModel() != null && ((VirtualMachineInner)((Object)VirtualMachineImpl.this.innerModel())).identity() != null) {
                    return ((VirtualMachineInner)((Object)VirtualMachineImpl.this.innerModel())).identity().principalId();
                }
                return null;
            }

            public String resourceId() {
                if (VirtualMachineImpl.this.innerModel() != null) {
                    return ((VirtualMachineInner)((Object)VirtualMachineImpl.this.innerModel())).id();
                }
                return null;
            }
        };
    }

    @Override
    public VirtualMachineImpl withPlacement(DiffDiskPlacement placement) {
        if (placement != null) {
            ((VirtualMachineInner)((Object)this.innerModel())).storageProfile().osDisk().diffDiskSettings().withPlacement(placement);
        }
        return this;
    }

    @Override
    public VirtualMachineImpl withExistingVirtualMachineScaleSet(VirtualMachineScaleSet scaleSet) {
        if (scaleSet != null) {
            ((VirtualMachineInner)((Object)this.innerModel())).withVirtualMachineScaleSet(new SubResource().withId(scaleSet.id()));
        }
        return this;
    }

    @Override
    public VirtualMachineImpl withOSDisk(String diskId) {
        if (diskId == null) {
            return this;
        }
        if (!this.isManagedDiskEnabled() || ((VirtualMachineInner)((Object)this.innerModel())).storageProfile().osDisk().managedDisk() == null) {
            return this;
        }
        OSDisk osDisk = new OSDisk().withCreateOption(((VirtualMachineInner)((Object)this.innerModel())).storageProfile().osDisk().createOption());
        osDisk.withManagedDisk(new ManagedDiskParameters().withId(diskId));
        this.storageProfile().withOsDisk(osDisk);
        this.storageProfile().osDisk().managedDisk().withId(diskId);
        return this;
    }

    @Override
    public VirtualMachineImpl withOSDisk(Disk disk) {
        if (disk == null) {
            return this;
        }
        return this.withOSDisk(disk.id());
    }

    @Override
    public VirtualMachineImpl withTrustedLaunch() {
        this.ensureSecurityProfile().withSecurityType(SecurityTypes.TRUSTED_LAUNCH);
        return this;
    }

    @Override
    public VirtualMachineImpl withSecureBoot() {
        if (this.securityType() == null) {
            return this;
        }
        this.ensureUefiSettings().withSecureBootEnabled(true);
        return this;
    }

    @Override
    public VirtualMachineImpl withoutSecureBoot() {
        if (this.securityType() == null) {
            return this;
        }
        this.ensureUefiSettings().withSecureBootEnabled(false);
        return this;
    }

    @Override
    public VirtualMachineImpl withVTpm() {
        if (this.securityType() == null) {
            return this;
        }
        this.ensureUefiSettings().withVTpmEnabled(true);
        return this;
    }

    @Override
    public VirtualMachineImpl withoutVTpm() {
        if (this.securityType() == null) {
            return this;
        }
        this.ensureUefiSettings().withVTpmEnabled(false);
        return this;
    }

    private SecurityProfile ensureSecurityProfile() {
        SecurityProfile securityProfile = ((VirtualMachineInner)((Object)this.innerModel())).securityProfile();
        if (securityProfile == null) {
            securityProfile = new SecurityProfile();
            ((VirtualMachineInner)((Object)this.innerModel())).withSecurityProfile(securityProfile);
        }
        return securityProfile;
    }

    private UefiSettings ensureUefiSettings() {
        UefiSettings uefiSettings = this.ensureSecurityProfile().uefiSettings();
        if (uefiSettings == null) {
            uefiSettings = new UefiSettings();
            this.ensureSecurityProfile().withUefiSettings(uefiSettings);
        }
        return uefiSettings;
    }

    @Override
    public VirtualMachineImpl withEncryptionAtHost() {
        this.ensureSecurityProfile().withEncryptionAtHost(true);
        return this;
    }

    @Override
    public VirtualMachineImpl withoutEncryptionAtHost() {
        this.ensureSecurityProfile().withEncryptionAtHost(false);
        return this;
    }

    private class ManagedDataDiskCollection {
        private final Map<String, DataDisk> newDisksToAttach = new HashMap<String, DataDisk>();
        private final List<DataDisk> existingDisksToAttach = new ArrayList<DataDisk>();
        private final List<DataDisk> implicitDisksToAssociate = new ArrayList<DataDisk>();
        private final List<Integer> diskLunsToRemove = new ArrayList<Integer>();
        private final List<DataDisk> newDisksFromImage = new ArrayList<DataDisk>();
        private final VirtualMachineImpl vm;
        private CachingTypes defaultCachingType;
        private StorageAccountTypes defaultStorageAccountType;
        private DiskDeleteOptionTypes defaultDeleteOptions;
        private DiskEncryptionSetParameters defaultDiskEncryptionSet;

        ManagedDataDiskCollection(VirtualMachineImpl vm) {
            this.vm = vm;
        }

        void setDefaultCachingType(CachingTypes cachingType) {
            this.defaultCachingType = cachingType;
        }

        void setDefaultDeleteOptions(DiskDeleteOptionTypes deleteOptions) {
            this.defaultDeleteOptions = deleteOptions;
        }

        void setDefaultStorageAccountType(StorageAccountTypes defaultStorageAccountType) {
            this.defaultStorageAccountType = defaultStorageAccountType;
        }

        void setDefaultEncryptionSet(String diskEncryptionSetId) {
            this.defaultDiskEncryptionSet = new DiskEncryptionSetParameters().withId(diskEncryptionSetId);
        }

        void setDataDisksDefaults() {
            VirtualMachineInner vmInner = (VirtualMachineInner)((Object)this.vm.innerModel());
            if (this.isPending()) {
                if (vmInner.storageProfile().dataDisks() == null) {
                    vmInner.storageProfile().withDataDisks(new ArrayList<DataDisk>());
                }
                List<DataDisk> dataDisks = vmInner.storageProfile().dataDisks();
                ArrayList<Integer> usedLuns = new ArrayList<Integer>();
                for (DataDisk dataDisk : dataDisks) {
                    if (dataDisk.lun() == -1) continue;
                    usedLuns.add(dataDisk.lun());
                }
                for (DataDisk dataDisk : this.newDisksToAttach.values()) {
                    if (dataDisk.lun() == -1) continue;
                    usedLuns.add(dataDisk.lun());
                }
                for (DataDisk dataDisk : this.existingDisksToAttach) {
                    if (dataDisk.lun() == -1) continue;
                    usedLuns.add(dataDisk.lun());
                }
                for (DataDisk dataDisk : this.implicitDisksToAssociate) {
                    if (dataDisk.lun() == -1) continue;
                    usedLuns.add(dataDisk.lun());
                }
                for (DataDisk dataDisk : this.newDisksFromImage) {
                    if (dataDisk.lun() == -1) continue;
                    usedLuns.add(dataDisk.lun());
                }
                Callable<Integer> nextLun = () -> {
                    Integer lun = 0;
                    while (usedLuns.contains(lun)) {
                        Integer n = lun;
                        lun = lun + 1;
                    }
                    usedLuns.add(lun);
                    return lun;
                };
                try {
                    this.setAttachableNewDataDisks(nextLun);
                    this.setAttachableExistingDataDisks(nextLun);
                    this.setImplicitDataDisks(nextLun);
                }
                catch (Exception ex) {
                    throw VirtualMachineImpl.this.logger.logExceptionAsError(Exceptions.propagate((Throwable)ex));
                }
                this.setImageBasedDataDisks();
                this.removeDataDisks();
            }
            if (vmInner.storageProfile().dataDisks() != null && vmInner.storageProfile().dataDisks().size() == 0 && this.vm.isInCreateMode()) {
                vmInner.storageProfile().withDataDisks(null);
            }
            this.clear();
        }

        private void clear() {
            this.newDisksToAttach.clear();
            this.existingDisksToAttach.clear();
            this.implicitDisksToAssociate.clear();
            this.diskLunsToRemove.clear();
            this.newDisksFromImage.clear();
            this.defaultCachingType = null;
            this.defaultStorageAccountType = null;
            this.defaultDeleteOptions = null;
            this.defaultDiskEncryptionSet = null;
        }

        private boolean isPending() {
            return this.newDisksToAttach.size() > 0 || this.existingDisksToAttach.size() > 0 || this.implicitDisksToAssociate.size() > 0 || this.diskLunsToRemove.size() > 0 || this.newDisksFromImage.size() > 0;
        }

        private void setDefaultDiskEncryptionSetOptions(DataDisk dataDisk) {
            if (this.getDefaultDiskEncryptionSetOptions() != null) {
                if (dataDisk.managedDisk() != null && dataDisk.managedDisk().diskEncryptionSet() != null) {
                    if (dataDisk.managedDisk().diskEncryptionSet().id() == null) {
                        dataDisk.managedDisk().withDiskEncryptionSet(null);
                    }
                } else {
                    if (dataDisk.managedDisk() == null) {
                        dataDisk.withManagedDisk(new ManagedDiskParameters());
                    }
                    dataDisk.managedDisk().withDiskEncryptionSet(this.getDefaultDiskEncryptionSetOptions());
                }
            }
        }

        private void setAttachableNewDataDisks(Callable<Integer> nextLun) throws Exception {
            List<DataDisk> dataDisks = ((VirtualMachineInner)((Object)this.vm.innerModel())).storageProfile().dataDisks();
            for (Map.Entry<String, DataDisk> entry : this.newDisksToAttach.entrySet()) {
                Disk managedDisk = (Disk)this.vm.taskResult(entry.getKey());
                DataDisk dataDisk = entry.getValue();
                dataDisk.withCreateOption(DiskCreateOptionTypes.ATTACH);
                if (dataDisk.lun() == -1) {
                    dataDisk.withLun(nextLun.call());
                }
                dataDisk.withManagedDisk(new ManagedDiskParameters());
                dataDisk.managedDisk().withId(managedDisk.id());
                if (dataDisk.caching() == null) {
                    dataDisk.withCaching(this.getDefaultCachingType());
                }
                if (dataDisk.deleteOption() == null) {
                    dataDisk.withDeleteOption(this.getDefaultDeleteOptions());
                }
                this.setDefaultDiskEncryptionSetOptions(dataDisk);
                dataDisk.withName(null);
                dataDisks.add(dataDisk);
            }
        }

        private void setAttachableExistingDataDisks(Callable<Integer> nextLun) throws Exception {
            List<DataDisk> dataDisks = ((VirtualMachineInner)((Object)this.vm.innerModel())).storageProfile().dataDisks();
            for (DataDisk dataDisk : this.existingDisksToAttach) {
                dataDisk.withCreateOption(DiskCreateOptionTypes.ATTACH);
                if (dataDisk.lun() == -1) {
                    dataDisk.withLun(nextLun.call());
                }
                if (dataDisk.caching() == null) {
                    dataDisk.withCaching(this.getDefaultCachingType());
                }
                if (dataDisk.deleteOption() == null) {
                    dataDisk.withDeleteOption(this.getDefaultDeleteOptions());
                }
                this.setDefaultDiskEncryptionSetOptions(dataDisk);
                dataDisk.withName(null);
                dataDisks.add(dataDisk);
            }
        }

        private void setImplicitDataDisks(Callable<Integer> nextLun) throws Exception {
            List<DataDisk> dataDisks = ((VirtualMachineInner)((Object)this.vm.innerModel())).storageProfile().dataDisks();
            for (DataDisk dataDisk : this.implicitDisksToAssociate) {
                dataDisk.withCreateOption(DiskCreateOptionTypes.EMPTY);
                if (dataDisk.lun() == -1) {
                    dataDisk.withLun(nextLun.call());
                }
                if (dataDisk.caching() == null) {
                    dataDisk.withCaching(this.getDefaultCachingType());
                }
                if (dataDisk.managedDisk() == null) {
                    dataDisk.withManagedDisk(new ManagedDiskParameters());
                }
                if (dataDisk.managedDisk().storageAccountType() == null) {
                    dataDisk.managedDisk().withStorageAccountType(this.getDefaultStorageAccountType());
                }
                if (dataDisk.deleteOption() == null) {
                    dataDisk.withDeleteOption(this.getDefaultDeleteOptions());
                }
                this.setDefaultDiskEncryptionSetOptions(dataDisk);
                dataDisk.withName(null);
                dataDisks.add(dataDisk);
            }
        }

        private void setImageBasedDataDisks() {
            List<DataDisk> dataDisks = ((VirtualMachineInner)((Object)this.vm.innerModel())).storageProfile().dataDisks();
            for (DataDisk dataDisk : this.newDisksFromImage) {
                dataDisk.withCreateOption(DiskCreateOptionTypes.FROM_IMAGE);
                if (dataDisk.caching() == null) {
                    dataDisk.withCaching(this.getDefaultCachingType());
                }
                if (dataDisk.deleteOption() == null) {
                    dataDisk.withDeleteOption(this.getDefaultDeleteOptions());
                }
                this.setDefaultDiskEncryptionSetOptions(dataDisk);
                dataDisk.withName(null);
                dataDisks.add(dataDisk);
            }
        }

        private void removeDataDisks() {
            List<DataDisk> dataDisks = ((VirtualMachineInner)((Object)this.vm.innerModel())).storageProfile().dataDisks();
            block0: for (Integer lun : this.diskLunsToRemove) {
                int indexToRemove = 0;
                for (DataDisk dataDisk : dataDisks) {
                    if (dataDisk.lun() == lun.intValue()) {
                        dataDisks.remove(indexToRemove);
                        continue block0;
                    }
                    ++indexToRemove;
                }
            }
        }

        private CachingTypes getDefaultCachingType() {
            if (this.defaultCachingType == null) {
                return CachingTypes.READ_WRITE;
            }
            return this.defaultCachingType;
        }

        private StorageAccountTypes getDefaultStorageAccountType() {
            if (this.defaultStorageAccountType == null) {
                return StorageAccountTypes.STANDARD_LRS;
            }
            return this.defaultStorageAccountType;
        }

        private DiskDeleteOptionTypes getDefaultDeleteOptions() {
            return this.defaultDeleteOptions;
        }

        private DiskEncryptionSetParameters getDefaultDiskEncryptionSetOptions() {
            return this.defaultDiskEncryptionSet;
        }
    }

    private class BootDiagnosticsHandler {
        private final VirtualMachineImpl vmImpl;
        private String creatableDiagnosticsStorageAccountKey;
        private boolean useManagedStorageAccount = false;

        BootDiagnosticsHandler(VirtualMachineImpl vmImpl) {
            this.vmImpl = vmImpl;
            if (this.isBootDiagnosticsEnabled() && this.vmInner().diagnosticsProfile().bootDiagnostics().storageUri() == null) {
                this.useManagedStorageAccount = true;
            }
        }

        public boolean isBootDiagnosticsEnabled() {
            if (this.vmInner().diagnosticsProfile() != null && this.vmInner().diagnosticsProfile().bootDiagnostics() != null && this.vmInner().diagnosticsProfile().bootDiagnostics().enabled() != null) {
                return this.vmInner().diagnosticsProfile().bootDiagnostics().enabled();
            }
            return false;
        }

        public String bootDiagnosticsStorageUri() {
            if (this.vmInner().diagnosticsProfile() != null && this.vmInner().diagnosticsProfile().bootDiagnostics() != null) {
                return this.vmInner().diagnosticsProfile().bootDiagnostics().storageUri();
            }
            return null;
        }

        BootDiagnosticsHandler withBootDiagnostics(boolean useManagedStorageAccount) {
            this.enableDisable(true);
            this.useManagedStorageAccount = useManagedStorageAccount;
            return this;
        }

        BootDiagnosticsHandler withBootDiagnostics(Creatable<StorageAccount> creatable) {
            this.enableDisable(true);
            this.useManagedStorageAccount = false;
            this.creatableDiagnosticsStorageAccountKey = this.vmImpl.addDependency(creatable);
            return this;
        }

        BootDiagnosticsHandler withBootDiagnostics(String storageAccountBlobEndpointUri) {
            this.enableDisable(true);
            this.useManagedStorageAccount = false;
            this.vmInner().diagnosticsProfile().bootDiagnostics().withStorageUri(storageAccountBlobEndpointUri);
            return this;
        }

        BootDiagnosticsHandler withBootDiagnostics(StorageAccount storageAccount) {
            return this.withBootDiagnostics(storageAccount.endPoints().primary().blob());
        }

        BootDiagnosticsHandler withoutBootDiagnostics() {
            this.enableDisable(false);
            this.useManagedStorageAccount = false;
            return this;
        }

        void prepare() {
            if (this.useManagedStorageAccount) {
                return;
            }
            DiagnosticsProfile diagnosticsProfile = this.vmInner().diagnosticsProfile();
            if (diagnosticsProfile == null || diagnosticsProfile.bootDiagnostics() == null || diagnosticsProfile.bootDiagnostics().storageUri() != null) {
                return;
            }
            boolean enableBD = ResourceManagerUtils.toPrimitiveBoolean((Boolean)diagnosticsProfile.bootDiagnostics().enabled());
            if (!enableBD) {
                return;
            }
            if (this.creatableDiagnosticsStorageAccountKey != null || this.vmImpl.creatableStorageAccountKey != null || this.vmImpl.existingStorageAccountToAssociate != null) {
                return;
            }
            String accountName = this.vmImpl.namer.getRandomName("stg", 24).replace("-", "");
            Creatable storageAccountCreatable = this.vmImpl.creatableGroup != null ? (Creatable)((StorageAccount.DefinitionStages.WithGroup)((StorageAccount.DefinitionStages.Blank)this.vmImpl.storageManager.storageAccounts().define(accountName)).withRegion(this.vmImpl.regionName())).withNewResourceGroup(this.vmImpl.creatableGroup) : (Creatable)((StorageAccount.DefinitionStages.WithGroup)((StorageAccount.DefinitionStages.Blank)this.vmImpl.storageManager.storageAccounts().define(accountName)).withRegion(this.vmImpl.regionName())).withExistingResourceGroup(this.vmImpl.resourceGroupName());
            this.creatableDiagnosticsStorageAccountKey = this.vmImpl.addDependency(storageAccountCreatable);
        }

        void handleDiagnosticsSettings() {
            if (this.useManagedStorageAccount) {
                return;
            }
            DiagnosticsProfile diagnosticsProfile = this.vmInner().diagnosticsProfile();
            if (diagnosticsProfile == null || diagnosticsProfile.bootDiagnostics() == null || diagnosticsProfile.bootDiagnostics().storageUri() != null) {
                return;
            }
            boolean enableBD = ResourceManagerUtils.toPrimitiveBoolean((Boolean)diagnosticsProfile.bootDiagnostics().enabled());
            if (!enableBD) {
                return;
            }
            StorageAccount storageAccount = null;
            if (this.creatableDiagnosticsStorageAccountKey != null) {
                storageAccount = (StorageAccount)this.vmImpl.taskResult(this.creatableDiagnosticsStorageAccountKey);
            } else if (this.vmImpl.creatableStorageAccountKey != null) {
                storageAccount = (StorageAccount)this.vmImpl.taskResult(this.vmImpl.creatableStorageAccountKey);
            } else if (this.vmImpl.existingStorageAccountToAssociate != null) {
                storageAccount = this.vmImpl.existingStorageAccountToAssociate;
            }
            if (storageAccount == null) {
                throw VirtualMachineImpl.this.logger.logExceptionAsError((RuntimeException)new IllegalStateException("Unable to retrieve expected storageAccount instance for BootDiagnostics"));
            }
            this.vmInner().diagnosticsProfile().bootDiagnostics().withStorageUri(storageAccount.endPoints().primary().blob());
        }

        private VirtualMachineInner vmInner() {
            return (VirtualMachineInner)((Object)this.vmImpl.innerModel());
        }

        private void enableDisable(boolean enable) {
            if (this.vmInner().diagnosticsProfile() == null) {
                this.vmInner().withDiagnosticsProfile(new DiagnosticsProfile());
            }
            if (this.vmInner().diagnosticsProfile().bootDiagnostics() == null) {
                this.vmInner().diagnosticsProfile().withBootDiagnostics(new BootDiagnostics());
            }
            if (enable) {
                this.vmInner().diagnosticsProfile().bootDiagnostics().withEnabled(true);
            } else {
                this.vmInner().diagnosticsProfile().bootDiagnostics().withEnabled(false);
                this.vmInner().diagnosticsProfile().bootDiagnostics().withStorageUri(null);
            }
        }
    }
}

