/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.core.management.exception.AdditionalInfo;
import com.azure.core.management.exception.ManagementError;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.InnerError;
import java.io.IOException;
import java.util.List;

public final class ApiError
extends ManagementError {
    private InnerError innererror;
    private String code;
    private String message;
    private String target;
    private List<ManagementError> details;
    private List<AdditionalInfo> additionalInfo;

    public InnerError getInnererror() {
        return this.innererror;
    }

    public String getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public String getTarget() {
        return this.target;
    }

    public List<ManagementError> getDetails() {
        return this.details;
    }

    public List<AdditionalInfo> getAdditionalInfo() {
        return this.additionalInfo;
    }

    public void validate() {
        if (this.getInnererror() != null) {
            this.getInnererror().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static ApiError fromJson(JsonReader jsonReader) throws IOException {
        return (ApiError)((Object)jsonReader.readObject(reader -> {
            JsonReader bufferedReader = reader.bufferObject();
            bufferedReader.nextToken();
            while (bufferedReader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = bufferedReader.getFieldName();
                bufferedReader.nextToken();
                if ("error".equals(fieldName)) {
                    return ApiError.readManagementError(bufferedReader);
                }
                bufferedReader.skipChildren();
            }
            return ApiError.readManagementError(bufferedReader.reset());
        }));
    }

    private static ApiError readManagementError(JsonReader jsonReader) throws IOException {
        return (ApiError)((Object)jsonReader.readObject(reader -> {
            ApiError deserializedApiError = new ApiError();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("code".equals(fieldName)) {
                    deserializedApiError.code = reader.getString();
                    continue;
                }
                if ("message".equals(fieldName)) {
                    deserializedApiError.message = reader.getString();
                    continue;
                }
                if ("target".equals(fieldName)) {
                    deserializedApiError.target = reader.getString();
                    continue;
                }
                if ("details".equals(fieldName)) {
                    List details;
                    deserializedApiError.details = details = reader.readArray(reader1 -> ManagementError.fromJson((JsonReader)reader1));
                    continue;
                }
                if ("additionalInfo".equals(fieldName)) {
                    List additionalInfo;
                    deserializedApiError.additionalInfo = additionalInfo = reader.readArray(reader1 -> AdditionalInfo.fromJson((JsonReader)reader1));
                    continue;
                }
                if ("innererror".equals(fieldName)) {
                    deserializedApiError.innererror = InnerError.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedApiError;
        }));
    }
}

