// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.DiskEncryptionSetType;
import com.azure.resourcemanager.compute.models.KeyForDiskEncryptionSet;
import java.io.IOException;

/**
 * disk encryption set resource update properties.
 */
@Fluent
public final class DiskEncryptionSetUpdateProperties implements JsonSerializable<DiskEncryptionSetUpdateProperties> {
    /*
     * The type of key used to encrypt the data of the disk.
     */
    private DiskEncryptionSetType encryptionType;

    /*
     * Key Vault Key Url to be used for server side encryption of Managed Disks and Snapshots
     */
    private KeyForDiskEncryptionSet activeKey;

    /*
     * Set this flag to true to enable auto-updating of this disk encryption set to the latest key version.
     */
    private Boolean rotationToLatestKeyVersionEnabled;

    /*
     * Multi-tenant application client id to access key vault in a different tenant. Setting the value to 'None' will
     * clear the property.
     */
    private String federatedClientId;

    /**
     * Creates an instance of DiskEncryptionSetUpdateProperties class.
     */
    public DiskEncryptionSetUpdateProperties() {
    }

    /**
     * Get the encryptionType property: The type of key used to encrypt the data of the disk.
     * 
     * @return the encryptionType value.
     */
    public DiskEncryptionSetType encryptionType() {
        return this.encryptionType;
    }

    /**
     * Set the encryptionType property: The type of key used to encrypt the data of the disk.
     * 
     * @param encryptionType the encryptionType value to set.
     * @return the DiskEncryptionSetUpdateProperties object itself.
     */
    public DiskEncryptionSetUpdateProperties withEncryptionType(DiskEncryptionSetType encryptionType) {
        this.encryptionType = encryptionType;
        return this;
    }

    /**
     * Get the activeKey property: Key Vault Key Url to be used for server side encryption of Managed Disks and
     * Snapshots.
     * 
     * @return the activeKey value.
     */
    public KeyForDiskEncryptionSet activeKey() {
        return this.activeKey;
    }

    /**
     * Set the activeKey property: Key Vault Key Url to be used for server side encryption of Managed Disks and
     * Snapshots.
     * 
     * @param activeKey the activeKey value to set.
     * @return the DiskEncryptionSetUpdateProperties object itself.
     */
    public DiskEncryptionSetUpdateProperties withActiveKey(KeyForDiskEncryptionSet activeKey) {
        this.activeKey = activeKey;
        return this;
    }

    /**
     * Get the rotationToLatestKeyVersionEnabled property: Set this flag to true to enable auto-updating of this disk
     * encryption set to the latest key version.
     * 
     * @return the rotationToLatestKeyVersionEnabled value.
     */
    public Boolean rotationToLatestKeyVersionEnabled() {
        return this.rotationToLatestKeyVersionEnabled;
    }

    /**
     * Set the rotationToLatestKeyVersionEnabled property: Set this flag to true to enable auto-updating of this disk
     * encryption set to the latest key version.
     * 
     * @param rotationToLatestKeyVersionEnabled the rotationToLatestKeyVersionEnabled value to set.
     * @return the DiskEncryptionSetUpdateProperties object itself.
     */
    public DiskEncryptionSetUpdateProperties
        withRotationToLatestKeyVersionEnabled(Boolean rotationToLatestKeyVersionEnabled) {
        this.rotationToLatestKeyVersionEnabled = rotationToLatestKeyVersionEnabled;
        return this;
    }

    /**
     * Get the federatedClientId property: Multi-tenant application client id to access key vault in a different tenant.
     * Setting the value to 'None' will clear the property.
     * 
     * @return the federatedClientId value.
     */
    public String federatedClientId() {
        return this.federatedClientId;
    }

    /**
     * Set the federatedClientId property: Multi-tenant application client id to access key vault in a different tenant.
     * Setting the value to 'None' will clear the property.
     * 
     * @param federatedClientId the federatedClientId value to set.
     * @return the DiskEncryptionSetUpdateProperties object itself.
     */
    public DiskEncryptionSetUpdateProperties withFederatedClientId(String federatedClientId) {
        this.federatedClientId = federatedClientId;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (activeKey() != null) {
            activeKey().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("encryptionType",
            this.encryptionType == null ? null : this.encryptionType.toString());
        jsonWriter.writeJsonField("activeKey", this.activeKey);
        jsonWriter.writeBooleanField("rotationToLatestKeyVersionEnabled", this.rotationToLatestKeyVersionEnabled);
        jsonWriter.writeStringField("federatedClientId", this.federatedClientId);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DiskEncryptionSetUpdateProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DiskEncryptionSetUpdateProperties if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the DiskEncryptionSetUpdateProperties.
     */
    public static DiskEncryptionSetUpdateProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DiskEncryptionSetUpdateProperties deserializedDiskEncryptionSetUpdateProperties
                = new DiskEncryptionSetUpdateProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("encryptionType".equals(fieldName)) {
                    deserializedDiskEncryptionSetUpdateProperties.encryptionType
                        = DiskEncryptionSetType.fromString(reader.getString());
                } else if ("activeKey".equals(fieldName)) {
                    deserializedDiskEncryptionSetUpdateProperties.activeKey = KeyForDiskEncryptionSet.fromJson(reader);
                } else if ("rotationToLatestKeyVersionEnabled".equals(fieldName)) {
                    deserializedDiskEncryptionSetUpdateProperties.rotationToLatestKeyVersionEnabled
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("federatedClientId".equals(fieldName)) {
                    deserializedDiskEncryptionSetUpdateProperties.federatedClientId = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDiskEncryptionSetUpdateProperties;
        });
    }
}
