// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.Resource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.GalleryIdentifier;
import com.azure.resourcemanager.compute.models.GalleryProvisioningState;
import com.azure.resourcemanager.compute.models.SharingProfile;
import com.azure.resourcemanager.compute.models.SharingStatus;
import com.azure.resourcemanager.compute.models.SoftDeletePolicy;
import java.io.IOException;
import java.util.Map;

/**
 * Specifies information about the Shared Image Gallery that you want to create or update.
 */
@Fluent
public final class GalleryInner extends Resource {
    /*
     * Describes the properties of a Shared Image Gallery.
     */
    private GalleryProperties innerProperties;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * The type of the resource.
     */
    private String type;

    /**
     * Creates an instance of GalleryInner class.
     */
    public GalleryInner() {
    }

    /**
     * Get the innerProperties property: Describes the properties of a Shared Image Gallery.
     * 
     * @return the innerProperties value.
     */
    private GalleryProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public GalleryInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public GalleryInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    /**
     * Get the description property: The description of this Shared Image Gallery resource. This property is updatable.
     * 
     * @return the description value.
     */
    public String description() {
        return this.innerProperties() == null ? null : this.innerProperties().description();
    }

    /**
     * Set the description property: The description of this Shared Image Gallery resource. This property is updatable.
     * 
     * @param description the description value to set.
     * @return the GalleryInner object itself.
     */
    public GalleryInner withDescription(String description) {
        if (this.innerProperties() == null) {
            this.innerProperties = new GalleryProperties();
        }
        this.innerProperties().withDescription(description);
        return this;
    }

    /**
     * Get the identifier property: Describes the gallery unique name.
     * 
     * @return the identifier value.
     */
    public GalleryIdentifier identifier() {
        return this.innerProperties() == null ? null : this.innerProperties().identifier();
    }

    /**
     * Set the identifier property: Describes the gallery unique name.
     * 
     * @param identifier the identifier value to set.
     * @return the GalleryInner object itself.
     */
    public GalleryInner withIdentifier(GalleryIdentifier identifier) {
        if (this.innerProperties() == null) {
            this.innerProperties = new GalleryProperties();
        }
        this.innerProperties().withIdentifier(identifier);
        return this;
    }

    /**
     * Get the provisioningState property: The provisioning state, which only appears in the response.
     * 
     * @return the provisioningState value.
     */
    public GalleryProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    /**
     * Get the sharingProfile property: Profile for gallery sharing to subscription or tenant.
     * 
     * @return the sharingProfile value.
     */
    public SharingProfile sharingProfile() {
        return this.innerProperties() == null ? null : this.innerProperties().sharingProfile();
    }

    /**
     * Set the sharingProfile property: Profile for gallery sharing to subscription or tenant.
     * 
     * @param sharingProfile the sharingProfile value to set.
     * @return the GalleryInner object itself.
     */
    public GalleryInner withSharingProfile(SharingProfile sharingProfile) {
        if (this.innerProperties() == null) {
            this.innerProperties = new GalleryProperties();
        }
        this.innerProperties().withSharingProfile(sharingProfile);
        return this;
    }

    /**
     * Get the softDeletePolicy property: Contains information about the soft deletion policy of the gallery.
     * 
     * @return the softDeletePolicy value.
     */
    public SoftDeletePolicy softDeletePolicy() {
        return this.innerProperties() == null ? null : this.innerProperties().softDeletePolicy();
    }

    /**
     * Set the softDeletePolicy property: Contains information about the soft deletion policy of the gallery.
     * 
     * @param softDeletePolicy the softDeletePolicy value to set.
     * @return the GalleryInner object itself.
     */
    public GalleryInner withSoftDeletePolicy(SoftDeletePolicy softDeletePolicy) {
        if (this.innerProperties() == null) {
            this.innerProperties = new GalleryProperties();
        }
        this.innerProperties().withSoftDeletePolicy(softDeletePolicy);
        return this;
    }

    /**
     * Get the sharingStatus property: Sharing status of current gallery.
     * 
     * @return the sharingStatus value.
     */
    public SharingStatus sharingStatus() {
        return this.innerProperties() == null ? null : this.innerProperties().sharingStatus();
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", location());
        jsonWriter.writeMapField("tags", tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of GalleryInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of GalleryInner if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the GalleryInner.
     */
    public static GalleryInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            GalleryInner deserializedGalleryInner = new GalleryInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedGalleryInner.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedGalleryInner.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedGalleryInner.type = reader.getString();
                } else if ("location".equals(fieldName)) {
                    deserializedGalleryInner.withLocation(reader.getString());
                } else if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedGalleryInner.withTags(tags);
                } else if ("properties".equals(fieldName)) {
                    deserializedGalleryInner.innerProperties = GalleryProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedGalleryInner;
        });
    }
}
