// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Describes the alternative option specified by the Publisher for this image when this image is deprecated.
 */
@Fluent
public final class AlternativeOption implements JsonSerializable<AlternativeOption> {
    /*
     * Describes the type of the alternative option.
     */
    private AlternativeType type;

    /*
     * Indicates the alternative option value specified by the Publisher. This is the Offer name when the type is Offer
     * or the Plan name when the type is Plan.
     */
    private String value;

    /**
     * Creates an instance of AlternativeOption class.
     */
    public AlternativeOption() {
    }

    /**
     * Get the type property: Describes the type of the alternative option.
     * 
     * @return the type value.
     */
    public AlternativeType type() {
        return this.type;
    }

    /**
     * Set the type property: Describes the type of the alternative option.
     * 
     * @param type the type value to set.
     * @return the AlternativeOption object itself.
     */
    public AlternativeOption withType(AlternativeType type) {
        this.type = type;
        return this;
    }

    /**
     * Get the value property: Indicates the alternative option value specified by the Publisher. This is the Offer name
     * when the type is Offer or the Plan name when the type is Plan.
     * 
     * @return the value value.
     */
    public String value() {
        return this.value;
    }

    /**
     * Set the value property: Indicates the alternative option value specified by the Publisher. This is the Offer name
     * when the type is Offer or the Plan name when the type is Plan.
     * 
     * @param value the value value to set.
     * @return the AlternativeOption object itself.
     */
    public AlternativeOption withValue(String value) {
        this.value = value;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeStringField("value", this.value);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AlternativeOption from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AlternativeOption if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the AlternativeOption.
     */
    public static AlternativeOption fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AlternativeOption deserializedAlternativeOption = new AlternativeOption();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("type".equals(fieldName)) {
                    deserializedAlternativeOption.type = AlternativeType.fromString(reader.getString());
                } else if ("value".equals(fieldName)) {
                    deserializedAlternativeOption.value = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAlternativeOption;
        });
    }
}
