// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.fluent.models.SharedGalleryImageInner;
import java.io.IOException;
import java.util.List;

/**
 * The List Shared Gallery Images operation response.
 */
@Fluent
public final class SharedGalleryImageList implements JsonSerializable<SharedGalleryImageList> {
    /*
     * A list of shared gallery images.
     */
    private List<SharedGalleryImageInner> value;

    /*
     * The uri to fetch the next page of shared gallery images. Call ListNext() with this to fetch the next page of
     * shared gallery images.
     */
    private String nextLink;

    /**
     * Creates an instance of SharedGalleryImageList class.
     */
    public SharedGalleryImageList() {
    }

    /**
     * Get the value property: A list of shared gallery images.
     * 
     * @return the value value.
     */
    public List<SharedGalleryImageInner> value() {
        return this.value;
    }

    /**
     * Set the value property: A list of shared gallery images.
     * 
     * @param value the value value to set.
     * @return the SharedGalleryImageList object itself.
     */
    public SharedGalleryImageList withValue(List<SharedGalleryImageInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: The uri to fetch the next page of shared gallery images. Call ListNext() with this to
     * fetch the next page of shared gallery images.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: The uri to fetch the next page of shared gallery images. Call ListNext() with this to
     * fetch the next page of shared gallery images.
     * 
     * @param nextLink the nextLink value to set.
     * @return the SharedGalleryImageList object itself.
     */
    public SharedGalleryImageList withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property value in model SharedGalleryImageList"));
        } else {
            value().forEach(e -> e.validate());
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(SharedGalleryImageList.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SharedGalleryImageList from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SharedGalleryImageList if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the SharedGalleryImageList.
     */
    public static SharedGalleryImageList fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SharedGalleryImageList deserializedSharedGalleryImageList = new SharedGalleryImageList();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<SharedGalleryImageInner> value
                        = reader.readArray(reader1 -> SharedGalleryImageInner.fromJson(reader1));
                    deserializedSharedGalleryImageList.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedSharedGalleryImageList.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSharedGalleryImageList;
        });
    }
}
