/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.fluent.models.VirtualMachineExtensionUpdateProperties;
import com.azure.resourcemanager.compute.models.KeyVaultSecretReference;
import com.azure.resourcemanager.compute.models.SubResourceReadOnly;
import java.io.IOException;

public final class VirtualMachineScaleSetVMExtensionUpdate
extends SubResourceReadOnly {
    private String name;
    private String type;
    private VirtualMachineExtensionUpdateProperties innerProperties;
    private String id;

    public String name() {
        return this.name;
    }

    public String type() {
        return this.type;
    }

    private VirtualMachineExtensionUpdateProperties innerProperties() {
        return this.innerProperties;
    }

    @Override
    public String id() {
        return this.id;
    }

    public String forceUpdateTag() {
        return this.innerProperties() == null ? null : this.innerProperties().forceUpdateTag();
    }

    public VirtualMachineScaleSetVMExtensionUpdate withForceUpdateTag(String forceUpdateTag) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineExtensionUpdateProperties();
        }
        this.innerProperties().withForceUpdateTag(forceUpdateTag);
        return this;
    }

    public String publisher() {
        return this.innerProperties() == null ? null : this.innerProperties().publisher();
    }

    public VirtualMachineScaleSetVMExtensionUpdate withPublisher(String publisher) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineExtensionUpdateProperties();
        }
        this.innerProperties().withPublisher(publisher);
        return this;
    }

    public String typePropertiesType() {
        return this.innerProperties() == null ? null : this.innerProperties().type();
    }

    public VirtualMachineScaleSetVMExtensionUpdate withTypePropertiesType(String type) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineExtensionUpdateProperties();
        }
        this.innerProperties().withType(type);
        return this;
    }

    public String typeHandlerVersion() {
        return this.innerProperties() == null ? null : this.innerProperties().typeHandlerVersion();
    }

    public VirtualMachineScaleSetVMExtensionUpdate withTypeHandlerVersion(String typeHandlerVersion) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineExtensionUpdateProperties();
        }
        this.innerProperties().withTypeHandlerVersion(typeHandlerVersion);
        return this;
    }

    public Boolean autoUpgradeMinorVersion() {
        return this.innerProperties() == null ? null : this.innerProperties().autoUpgradeMinorVersion();
    }

    public VirtualMachineScaleSetVMExtensionUpdate withAutoUpgradeMinorVersion(Boolean autoUpgradeMinorVersion) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineExtensionUpdateProperties();
        }
        this.innerProperties().withAutoUpgradeMinorVersion(autoUpgradeMinorVersion);
        return this;
    }

    public Boolean enableAutomaticUpgrade() {
        return this.innerProperties() == null ? null : this.innerProperties().enableAutomaticUpgrade();
    }

    public VirtualMachineScaleSetVMExtensionUpdate withEnableAutomaticUpgrade(Boolean enableAutomaticUpgrade) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineExtensionUpdateProperties();
        }
        this.innerProperties().withEnableAutomaticUpgrade(enableAutomaticUpgrade);
        return this;
    }

    public Object settings() {
        return this.innerProperties() == null ? null : this.innerProperties().settings();
    }

    public VirtualMachineScaleSetVMExtensionUpdate withSettings(Object settings) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineExtensionUpdateProperties();
        }
        this.innerProperties().withSettings(settings);
        return this;
    }

    public Object protectedSettings() {
        return this.innerProperties() == null ? null : this.innerProperties().protectedSettings();
    }

    public VirtualMachineScaleSetVMExtensionUpdate withProtectedSettings(Object protectedSettings) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineExtensionUpdateProperties();
        }
        this.innerProperties().withProtectedSettings(protectedSettings);
        return this;
    }

    public Boolean suppressFailures() {
        return this.innerProperties() == null ? null : this.innerProperties().suppressFailures();
    }

    public VirtualMachineScaleSetVMExtensionUpdate withSuppressFailures(Boolean suppressFailures) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineExtensionUpdateProperties();
        }
        this.innerProperties().withSuppressFailures(suppressFailures);
        return this;
    }

    public KeyVaultSecretReference protectedSettingsFromKeyVault() {
        return this.innerProperties() == null ? null : this.innerProperties().protectedSettingsFromKeyVault();
    }

    public VirtualMachineScaleSetVMExtensionUpdate withProtectedSettingsFromKeyVault(KeyVaultSecretReference protectedSettingsFromKeyVault) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineExtensionUpdateProperties();
        }
        this.innerProperties().withProtectedSettingsFromKeyVault(protectedSettingsFromKeyVault);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    public static VirtualMachineScaleSetVMExtensionUpdate fromJson(JsonReader jsonReader) throws IOException {
        return (VirtualMachineScaleSetVMExtensionUpdate)jsonReader.readObject(reader -> {
            VirtualMachineScaleSetVMExtensionUpdate deserializedVirtualMachineScaleSetVMExtensionUpdate = new VirtualMachineScaleSetVMExtensionUpdate();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetVMExtensionUpdate.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetVMExtensionUpdate.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetVMExtensionUpdate.type = reader.getString();
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedVirtualMachineScaleSetVMExtensionUpdate.innerProperties = VirtualMachineExtensionUpdateProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedVirtualMachineScaleSetVMExtensionUpdate;
        });
    }
}

