/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SystemData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.CloudServiceProperties;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class CloudServiceInner
extends Resource {
    private CloudServiceProperties properties;
    private SystemData systemData;
    private List<String> zones;
    private String id;
    private String name;
    private String type;

    public CloudServiceProperties properties() {
        return this.properties;
    }

    public CloudServiceInner withProperties(CloudServiceProperties properties) {
        this.properties = properties;
        return this;
    }

    public SystemData systemData() {
        return this.systemData;
    }

    public CloudServiceInner withSystemData(SystemData systemData) {
        this.systemData = systemData;
        return this;
    }

    public List<String> zones() {
        return this.zones;
    }

    public CloudServiceInner withZones(List<String> zones) {
        this.zones = zones;
        return this;
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return this.type;
    }

    public CloudServiceInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public CloudServiceInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public void validate() {
        if (this.properties() != null) {
            this.properties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", (JsonSerializable)this.properties);
        jsonWriter.writeJsonField("systemData", (JsonSerializable)this.systemData);
        jsonWriter.writeArrayField("zones", this.zones, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    public static CloudServiceInner fromJson(JsonReader jsonReader) throws IOException {
        return (CloudServiceInner)((Object)jsonReader.readObject(reader -> {
            CloudServiceInner deserializedCloudServiceInner = new CloudServiceInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedCloudServiceInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedCloudServiceInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedCloudServiceInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedCloudServiceInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedCloudServiceInner.withTags(tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedCloudServiceInner.properties = CloudServiceProperties.fromJson(reader);
                    continue;
                }
                if ("systemData".equals(fieldName)) {
                    deserializedCloudServiceInner.systemData = SystemData.fromJson((JsonReader)reader);
                    continue;
                }
                if ("zones".equals(fieldName)) {
                    List zones;
                    deserializedCloudServiceInner.zones = zones = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCloudServiceInner;
        }));
    }
}

