/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.Extension;
import java.io.IOException;
import java.util.List;

public final class CloudServiceExtensionProfile
implements JsonSerializable<CloudServiceExtensionProfile> {
    private List<Extension> extensions;

    public List<Extension> extensions() {
        return this.extensions;
    }

    public CloudServiceExtensionProfile withExtensions(List<Extension> extensions) {
        this.extensions = extensions;
        return this;
    }

    public void validate() {
        if (this.extensions() != null) {
            this.extensions().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("extensions", this.extensions, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static CloudServiceExtensionProfile fromJson(JsonReader jsonReader) throws IOException {
        return (CloudServiceExtensionProfile)jsonReader.readObject(reader -> {
            CloudServiceExtensionProfile deserializedCloudServiceExtensionProfile = new CloudServiceExtensionProfile();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("extensions".equals(fieldName)) {
                    List extensions;
                    deserializedCloudServiceExtensionProfile.extensions = extensions = reader.readArray(reader1 -> Extension.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCloudServiceExtensionProfile;
        });
    }
}

