/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.GalleryApplicationCustomActionParameter;
import java.io.IOException;
import java.util.List;

public final class GalleryApplicationCustomAction
implements JsonSerializable<GalleryApplicationCustomAction> {
    private String name;
    private String script;
    private String description;
    private List<GalleryApplicationCustomActionParameter> parameters;
    private static final ClientLogger LOGGER = new ClientLogger(GalleryApplicationCustomAction.class);

    public String name() {
        return this.name;
    }

    public GalleryApplicationCustomAction withName(String name) {
        this.name = name;
        return this;
    }

    public String script() {
        return this.script;
    }

    public GalleryApplicationCustomAction withScript(String script) {
        this.script = script;
        return this;
    }

    public String description() {
        return this.description;
    }

    public GalleryApplicationCustomAction withDescription(String description) {
        this.description = description;
        return this;
    }

    public List<GalleryApplicationCustomActionParameter> parameters() {
        return this.parameters;
    }

    public GalleryApplicationCustomAction withParameters(List<GalleryApplicationCustomActionParameter> parameters) {
        this.parameters = parameters;
        return this;
    }

    public void validate() {
        if (this.name() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property name in model GalleryApplicationCustomAction"));
        }
        if (this.script() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property script in model GalleryApplicationCustomAction"));
        }
        if (this.parameters() != null) {
            this.parameters().forEach(e -> e.validate());
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("script", this.script);
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeArrayField("parameters", this.parameters, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static GalleryApplicationCustomAction fromJson(JsonReader jsonReader) throws IOException {
        return (GalleryApplicationCustomAction)jsonReader.readObject(reader -> {
            GalleryApplicationCustomAction deserializedGalleryApplicationCustomAction = new GalleryApplicationCustomAction();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedGalleryApplicationCustomAction.name = reader.getString();
                    continue;
                }
                if ("script".equals(fieldName)) {
                    deserializedGalleryApplicationCustomAction.script = reader.getString();
                    continue;
                }
                if ("description".equals(fieldName)) {
                    deserializedGalleryApplicationCustomAction.description = reader.getString();
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    List parameters;
                    deserializedGalleryApplicationCustomAction.parameters = parameters = reader.readArray(reader1 -> GalleryApplicationCustomActionParameter.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedGalleryApplicationCustomAction;
        });
    }
}

