/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.VMSizeProperties;
import com.azure.resourcemanager.compute.models.VirtualMachineSizeTypes;
import java.io.IOException;

public final class HardwareProfile
implements JsonSerializable<HardwareProfile> {
    private VirtualMachineSizeTypes vmSize;
    private VMSizeProperties vmSizeProperties;

    public VirtualMachineSizeTypes vmSize() {
        return this.vmSize;
    }

    public HardwareProfile withVmSize(VirtualMachineSizeTypes vmSize) {
        this.vmSize = vmSize;
        return this;
    }

    public VMSizeProperties vmSizeProperties() {
        return this.vmSizeProperties;
    }

    public HardwareProfile withVmSizeProperties(VMSizeProperties vmSizeProperties) {
        this.vmSizeProperties = vmSizeProperties;
        return this;
    }

    public void validate() {
        if (this.vmSizeProperties() != null) {
            this.vmSizeProperties().validate();
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("vmSize", this.vmSize == null ? null : this.vmSize.toString());
        jsonWriter.writeJsonField("vmSizeProperties", (JsonSerializable)this.vmSizeProperties);
        return jsonWriter.writeEndObject();
    }

    public static HardwareProfile fromJson(JsonReader jsonReader) throws IOException {
        return (HardwareProfile)jsonReader.readObject(reader -> {
            HardwareProfile deserializedHardwareProfile = new HardwareProfile();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("vmSize".equals(fieldName)) {
                    deserializedHardwareProfile.vmSize = VirtualMachineSizeTypes.fromString(reader.getString());
                    continue;
                }
                if ("vmSizeProperties".equals(fieldName)) {
                    deserializedHardwareProfile.vmSizeProperties = VMSizeProperties.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedHardwareProfile;
        });
    }
}

