/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.SourceVault;
import java.io.IOException;

public final class KeyVaultAndSecretReference
implements JsonSerializable<KeyVaultAndSecretReference> {
    private SourceVault sourceVault;
    private String secretUrl;
    private static final ClientLogger LOGGER = new ClientLogger(KeyVaultAndSecretReference.class);

    public SourceVault sourceVault() {
        return this.sourceVault;
    }

    public KeyVaultAndSecretReference withSourceVault(SourceVault sourceVault) {
        this.sourceVault = sourceVault;
        return this;
    }

    public String secretUrl() {
        return this.secretUrl;
    }

    public KeyVaultAndSecretReference withSecretUrl(String secretUrl) {
        this.secretUrl = secretUrl;
        return this;
    }

    public void validate() {
        if (this.sourceVault() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property sourceVault in model KeyVaultAndSecretReference"));
        }
        this.sourceVault().validate();
        if (this.secretUrl() == null) {
            throw LOGGER.atError().log((RuntimeException)new IllegalArgumentException("Missing required property secretUrl in model KeyVaultAndSecretReference"));
        }
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("sourceVault", (JsonSerializable)this.sourceVault);
        jsonWriter.writeStringField("secretUrl", this.secretUrl);
        return jsonWriter.writeEndObject();
    }

    public static KeyVaultAndSecretReference fromJson(JsonReader jsonReader) throws IOException {
        return (KeyVaultAndSecretReference)jsonReader.readObject(reader -> {
            KeyVaultAndSecretReference deserializedKeyVaultAndSecretReference = new KeyVaultAndSecretReference();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sourceVault".equals(fieldName)) {
                    deserializedKeyVaultAndSecretReference.sourceVault = SourceVault.fromJson(reader);
                    continue;
                }
                if ("secretUrl".equals(fieldName)) {
                    deserializedKeyVaultAndSecretReference.secretUrl = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedKeyVaultAndSecretReference;
        });
    }
}

