// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Describes the properties of a Compute Operation Value Display.
 */
@Immutable
public final class ComputeOperationValueDisplay implements JsonSerializable<ComputeOperationValueDisplay> {
    /*
     * The display name of the compute operation.
     */
    private String operation;

    /*
     * The display name of the resource the operation applies to.
     */
    private String resource;

    /*
     * The description of the operation.
     */
    private String description;

    /*
     * The resource provider for the operation.
     */
    private String provider;

    /**
     * Creates an instance of ComputeOperationValueDisplay class.
     */
    public ComputeOperationValueDisplay() {
    }

    /**
     * Get the operation property: The display name of the compute operation.
     * 
     * @return the operation value.
     */
    public String operation() {
        return this.operation;
    }

    /**
     * Get the resource property: The display name of the resource the operation applies to.
     * 
     * @return the resource value.
     */
    public String resource() {
        return this.resource;
    }

    /**
     * Get the description property: The description of the operation.
     * 
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Get the provider property: The resource provider for the operation.
     * 
     * @return the provider value.
     */
    public String provider() {
        return this.provider;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ComputeOperationValueDisplay from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ComputeOperationValueDisplay if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ComputeOperationValueDisplay.
     */
    public static ComputeOperationValueDisplay fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ComputeOperationValueDisplay deserializedComputeOperationValueDisplay = new ComputeOperationValueDisplay();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("operation".equals(fieldName)) {
                    deserializedComputeOperationValueDisplay.operation = reader.getString();
                } else if ("resource".equals(fieldName)) {
                    deserializedComputeOperationValueDisplay.resource = reader.getString();
                } else if ("description".equals(fieldName)) {
                    deserializedComputeOperationValueDisplay.description = reader.getString();
                } else if ("provider".equals(fieldName)) {
                    deserializedComputeOperationValueDisplay.provider = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedComputeOperationValueDisplay;
        });
    }
}
