// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Specifies the VM Size.
 */
@Fluent
public final class SkuProfileVMSize implements JsonSerializable<SkuProfileVMSize> {
    /*
     * Specifies the name of the VM Size.
     */
    private String name;

    /**
     * Creates an instance of SkuProfileVMSize class.
     */
    public SkuProfileVMSize() {
    }

    /**
     * Get the name property: Specifies the name of the VM Size.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Specifies the name of the VM Size.
     * 
     * @param name the name value to set.
     * @return the SkuProfileVMSize object itself.
     */
    public SkuProfileVMSize withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SkuProfileVMSize from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SkuProfileVMSize if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the SkuProfileVMSize.
     */
    public static SkuProfileVMSize fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SkuProfileVMSize deserializedSkuProfileVMSize = new SkuProfileVMSize();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedSkuProfileVMSize.name = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSkuProfileVMSize;
        });
    }
}
