// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The identifier information of community gallery.
 */
@Fluent
public final class CommunityGalleryIdentifier implements JsonSerializable<CommunityGalleryIdentifier> {
    /*
     * The unique id of this community gallery.
     */
    private String uniqueId;

    /**
     * Creates an instance of CommunityGalleryIdentifier class.
     */
    public CommunityGalleryIdentifier() {
    }

    /**
     * Get the uniqueId property: The unique id of this community gallery.
     * 
     * @return the uniqueId value.
     */
    public String uniqueId() {
        return this.uniqueId;
    }

    /**
     * Set the uniqueId property: The unique id of this community gallery.
     * 
     * @param uniqueId the uniqueId value to set.
     * @return the CommunityGalleryIdentifier object itself.
     */
    public CommunityGalleryIdentifier withUniqueId(String uniqueId) {
        this.uniqueId = uniqueId;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("uniqueId", this.uniqueId);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CommunityGalleryIdentifier from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of CommunityGalleryIdentifier if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the CommunityGalleryIdentifier.
     */
    public static CommunityGalleryIdentifier fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CommunityGalleryIdentifier deserializedCommunityGalleryIdentifier = new CommunityGalleryIdentifier();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("uniqueId".equals(fieldName)) {
                    deserializedCommunityGalleryIdentifier.uniqueId = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedCommunityGalleryIdentifier;
        });
    }
}
