// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The instance view of a virtual machine boot diagnostics.
 */
@Immutable
public final class BootDiagnosticsInstanceView implements JsonSerializable<BootDiagnosticsInstanceView> {
    /*
     * The console screenshot blob URI. **Note:** This will **not** be set if boot diagnostics is currently enabled with
     * managed storage.
     */
    private String consoleScreenshotBlobUri;

    /*
     * The serial console log blob Uri. **Note:** This will **not** be set if boot diagnostics is currently enabled with
     * managed storage.
     */
    private String serialConsoleLogBlobUri;

    /*
     * The boot diagnostics status information for the VM. **Note:** It will be set only if there are errors encountered
     * in enabling boot diagnostics.
     */
    private InstanceViewStatus status;

    /**
     * Creates an instance of BootDiagnosticsInstanceView class.
     */
    public BootDiagnosticsInstanceView() {
    }

    /**
     * Get the consoleScreenshotBlobUri property: The console screenshot blob URI. **Note:** This will **not** be set if
     * boot diagnostics is currently enabled with managed storage.
     * 
     * @return the consoleScreenshotBlobUri value.
     */
    public String consoleScreenshotBlobUri() {
        return this.consoleScreenshotBlobUri;
    }

    /**
     * Get the serialConsoleLogBlobUri property: The serial console log blob Uri. **Note:** This will **not** be set if
     * boot diagnostics is currently enabled with managed storage.
     * 
     * @return the serialConsoleLogBlobUri value.
     */
    public String serialConsoleLogBlobUri() {
        return this.serialConsoleLogBlobUri;
    }

    /**
     * Get the status property: The boot diagnostics status information for the VM. **Note:** It will be set only if
     * there are errors encountered in enabling boot diagnostics.
     * 
     * @return the status value.
     */
    public InstanceViewStatus status() {
        return this.status;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (status() != null) {
            status().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of BootDiagnosticsInstanceView from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of BootDiagnosticsInstanceView if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the BootDiagnosticsInstanceView.
     */
    public static BootDiagnosticsInstanceView fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            BootDiagnosticsInstanceView deserializedBootDiagnosticsInstanceView = new BootDiagnosticsInstanceView();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("consoleScreenshotBlobUri".equals(fieldName)) {
                    deserializedBootDiagnosticsInstanceView.consoleScreenshotBlobUri = reader.getString();
                } else if ("serialConsoleLogBlobUri".equals(fieldName)) {
                    deserializedBootDiagnosticsInstanceView.serialConsoleLogBlobUri = reader.getString();
                } else if ("status".equals(fieldName)) {
                    deserializedBootDiagnosticsInstanceView.status = InstanceViewStatus.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedBootDiagnosticsInstanceView;
        });
    }
}
