// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.fluent.models.DedicatedHostGroupInner;
import java.io.IOException;
import java.util.List;

/**
 * The List Dedicated Host Group with resource group response.
 */
@Fluent
public final class DedicatedHostGroupListResult implements JsonSerializable<DedicatedHostGroupListResult> {
    /*
     * The list of dedicated host groups
     */
    private List<DedicatedHostGroupInner> value;

    /*
     * The URI to fetch the next page of Dedicated Host Groups. Call ListNext() with this URI to fetch the next page of
     * Dedicated Host Groups.
     */
    private String nextLink;

    /**
     * Creates an instance of DedicatedHostGroupListResult class.
     */
    public DedicatedHostGroupListResult() {
    }

    /**
     * Get the value property: The list of dedicated host groups.
     * 
     * @return the value value.
     */
    public List<DedicatedHostGroupInner> value() {
        return this.value;
    }

    /**
     * Set the value property: The list of dedicated host groups.
     * 
     * @param value the value value to set.
     * @return the DedicatedHostGroupListResult object itself.
     */
    public DedicatedHostGroupListResult withValue(List<DedicatedHostGroupInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: The URI to fetch the next page of Dedicated Host Groups. Call ListNext() with this URI
     * to fetch the next page of Dedicated Host Groups.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: The URI to fetch the next page of Dedicated Host Groups. Call ListNext() with this URI
     * to fetch the next page of Dedicated Host Groups.
     * 
     * @param nextLink the nextLink value to set.
     * @return the DedicatedHostGroupListResult object itself.
     */
    public DedicatedHostGroupListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property value in model DedicatedHostGroupListResult"));
        } else {
            value().forEach(e -> e.validate());
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(DedicatedHostGroupListResult.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DedicatedHostGroupListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DedicatedHostGroupListResult if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the DedicatedHostGroupListResult.
     */
    public static DedicatedHostGroupListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DedicatedHostGroupListResult deserializedDedicatedHostGroupListResult = new DedicatedHostGroupListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<DedicatedHostGroupInner> value
                        = reader.readArray(reader1 -> DedicatedHostGroupInner.fromJson(reader1));
                    deserializedDedicatedHostGroupListResult.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedDedicatedHostGroupListResult.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDedicatedHostGroupListResult;
        });
    }
}
