// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Map;

/**
 * Identity for the virtual machine.
 */
@Fluent
public final class GalleryIdentity implements JsonSerializable<GalleryIdentity> {
    /*
     * The principal id of the gallery identity. This property will only be provided for a system assigned identity.
     */
    private String principalId;

    /*
     * The AAD tenant id of the gallery identity. This property will only be provided for a system assigned identity.
     */
    private String tenantId;

    /*
     * The type of identity used for the gallery. The type 'SystemAssigned, UserAssigned' includes both an implicitly
     * created identity and a set of user assigned identities. The type 'None' will remove all identities from the
     * gallery.
     */
    private ResourceIdentityType type;

    /*
     * The list of user identities associated with the gallery. The user identity dictionary key references will be ARM
     * resource ids in the form:
     * '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/
     * userAssignedIdentities/{identityName}'.
     */
    private Map<String, VirtualMachineIdentityUserAssignedIdentities> userAssignedIdentities;

    /**
     * Creates an instance of GalleryIdentity class.
     */
    public GalleryIdentity() {
    }

    /**
     * Get the principalId property: The principal id of the gallery identity. This property will only be provided for a
     * system assigned identity.
     * 
     * @return the principalId value.
     */
    public String principalId() {
        return this.principalId;
    }

    /**
     * Get the tenantId property: The AAD tenant id of the gallery identity. This property will only be provided for a
     * system assigned identity.
     * 
     * @return the tenantId value.
     */
    public String tenantId() {
        return this.tenantId;
    }

    /**
     * Get the type property: The type of identity used for the gallery. The type 'SystemAssigned, UserAssigned'
     * includes both an implicitly created identity and a set of user assigned identities. The type 'None' will remove
     * all identities from the gallery.
     * 
     * @return the type value.
     */
    public ResourceIdentityType type() {
        return this.type;
    }

    /**
     * Set the type property: The type of identity used for the gallery. The type 'SystemAssigned, UserAssigned'
     * includes both an implicitly created identity and a set of user assigned identities. The type 'None' will remove
     * all identities from the gallery.
     * 
     * @param type the type value to set.
     * @return the GalleryIdentity object itself.
     */
    public GalleryIdentity withType(ResourceIdentityType type) {
        this.type = type;
        return this;
    }

    /**
     * Get the userAssignedIdentities property: The list of user identities associated with the gallery. The user
     * identity dictionary key references will be ARM resource ids in the form:
     * '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
     * 
     * @return the userAssignedIdentities value.
     */
    public Map<String, VirtualMachineIdentityUserAssignedIdentities> userAssignedIdentities() {
        return this.userAssignedIdentities;
    }

    /**
     * Set the userAssignedIdentities property: The list of user identities associated with the gallery. The user
     * identity dictionary key references will be ARM resource ids in the form:
     * '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
     * 
     * @param userAssignedIdentities the userAssignedIdentities value to set.
     * @return the GalleryIdentity object itself.
     */
    public GalleryIdentity
        withUserAssignedIdentities(Map<String, VirtualMachineIdentityUserAssignedIdentities> userAssignedIdentities) {
        this.userAssignedIdentities = userAssignedIdentities;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (userAssignedIdentities() != null) {
            userAssignedIdentities().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeMapField("userAssignedIdentities", this.userAssignedIdentities,
            (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of GalleryIdentity from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of GalleryIdentity if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the GalleryIdentity.
     */
    public static GalleryIdentity fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            GalleryIdentity deserializedGalleryIdentity = new GalleryIdentity();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("principalId".equals(fieldName)) {
                    deserializedGalleryIdentity.principalId = reader.getString();
                } else if ("tenantId".equals(fieldName)) {
                    deserializedGalleryIdentity.tenantId = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedGalleryIdentity.type = ResourceIdentityType.fromString(reader.getString());
                } else if ("userAssignedIdentities".equals(fieldName)) {
                    Map<String, VirtualMachineIdentityUserAssignedIdentities> userAssignedIdentities
                        = reader.readMap(reader1 -> VirtualMachineIdentityUserAssignedIdentities.fromJson(reader1));
                    deserializedGalleryIdentity.userAssignedIdentities = userAssignedIdentities;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedGalleryIdentity;
        });
    }
}
