// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

/**
 * The properties of a gallery ResourceProfile version.
 */
@Fluent
public class GalleryResourceProfileVersionPropertiesBase
    implements JsonSerializable<GalleryResourceProfileVersionPropertiesBase> {
    /*
     * The target regions where the Resource Profile version is going to be replicated to. This property is updatable.
     */
    private List<TargetRegion> targetLocations;

    /*
     * If set to true, Virtual Machines deployed from the latest version of the Resource Profile won't use this Profile
     * version.
     */
    private Boolean excludeFromLatest;

    /*
     * The timestamp for when the Resource Profile Version is published.
     */
    private OffsetDateTime publishedDate;

    /*
     * The provisioning state, which only appears in the response.
     */
    private GalleryProvisioningState provisioningState;

    /*
     * This is the replication status of the gallery image version.
     */
    private ReplicationStatus replicationStatus;

    /**
     * Creates an instance of GalleryResourceProfileVersionPropertiesBase class.
     */
    public GalleryResourceProfileVersionPropertiesBase() {
    }

    /**
     * Get the targetLocations property: The target regions where the Resource Profile version is going to be replicated
     * to. This property is updatable.
     * 
     * @return the targetLocations value.
     */
    public List<TargetRegion> targetLocations() {
        return this.targetLocations;
    }

    /**
     * Set the targetLocations property: The target regions where the Resource Profile version is going to be replicated
     * to. This property is updatable.
     * 
     * @param targetLocations the targetLocations value to set.
     * @return the GalleryResourceProfileVersionPropertiesBase object itself.
     */
    public GalleryResourceProfileVersionPropertiesBase withTargetLocations(List<TargetRegion> targetLocations) {
        this.targetLocations = targetLocations;
        return this;
    }

    /**
     * Get the excludeFromLatest property: If set to true, Virtual Machines deployed from the latest version of the
     * Resource Profile won't use this Profile version.
     * 
     * @return the excludeFromLatest value.
     */
    public Boolean excludeFromLatest() {
        return this.excludeFromLatest;
    }

    /**
     * Set the excludeFromLatest property: If set to true, Virtual Machines deployed from the latest version of the
     * Resource Profile won't use this Profile version.
     * 
     * @param excludeFromLatest the excludeFromLatest value to set.
     * @return the GalleryResourceProfileVersionPropertiesBase object itself.
     */
    public GalleryResourceProfileVersionPropertiesBase withExcludeFromLatest(Boolean excludeFromLatest) {
        this.excludeFromLatest = excludeFromLatest;
        return this;
    }

    /**
     * Get the publishedDate property: The timestamp for when the Resource Profile Version is published.
     * 
     * @return the publishedDate value.
     */
    public OffsetDateTime publishedDate() {
        return this.publishedDate;
    }

    /**
     * Set the publishedDate property: The timestamp for when the Resource Profile Version is published.
     * 
     * @param publishedDate the publishedDate value to set.
     * @return the GalleryResourceProfileVersionPropertiesBase object itself.
     */
    GalleryResourceProfileVersionPropertiesBase withPublishedDate(OffsetDateTime publishedDate) {
        this.publishedDate = publishedDate;
        return this;
    }

    /**
     * Get the provisioningState property: The provisioning state, which only appears in the response.
     * 
     * @return the provisioningState value.
     */
    public GalleryProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Set the provisioningState property: The provisioning state, which only appears in the response.
     * 
     * @param provisioningState the provisioningState value to set.
     * @return the GalleryResourceProfileVersionPropertiesBase object itself.
     */
    GalleryResourceProfileVersionPropertiesBase withProvisioningState(GalleryProvisioningState provisioningState) {
        this.provisioningState = provisioningState;
        return this;
    }

    /**
     * Get the replicationStatus property: This is the replication status of the gallery image version.
     * 
     * @return the replicationStatus value.
     */
    public ReplicationStatus replicationStatus() {
        return this.replicationStatus;
    }

    /**
     * Set the replicationStatus property: This is the replication status of the gallery image version.
     * 
     * @param replicationStatus the replicationStatus value to set.
     * @return the GalleryResourceProfileVersionPropertiesBase object itself.
     */
    GalleryResourceProfileVersionPropertiesBase withReplicationStatus(ReplicationStatus replicationStatus) {
        this.replicationStatus = replicationStatus;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (targetLocations() != null) {
            targetLocations().forEach(e -> e.validate());
        }
        if (replicationStatus() != null) {
            replicationStatus().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("targetLocations", this.targetLocations,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeBooleanField("excludeFromLatest", this.excludeFromLatest);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of GalleryResourceProfileVersionPropertiesBase from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of GalleryResourceProfileVersionPropertiesBase if the JsonReader was pointing to an instance
     * of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the GalleryResourceProfileVersionPropertiesBase.
     */
    public static GalleryResourceProfileVersionPropertiesBase fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            GalleryResourceProfileVersionPropertiesBase deserializedGalleryResourceProfileVersionPropertiesBase
                = new GalleryResourceProfileVersionPropertiesBase();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("targetLocations".equals(fieldName)) {
                    List<TargetRegion> targetLocations = reader.readArray(reader1 -> TargetRegion.fromJson(reader1));
                    deserializedGalleryResourceProfileVersionPropertiesBase.targetLocations = targetLocations;
                } else if ("excludeFromLatest".equals(fieldName)) {
                    deserializedGalleryResourceProfileVersionPropertiesBase.excludeFromLatest
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("publishedDate".equals(fieldName)) {
                    deserializedGalleryResourceProfileVersionPropertiesBase.publishedDate = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("provisioningState".equals(fieldName)) {
                    deserializedGalleryResourceProfileVersionPropertiesBase.provisioningState
                        = GalleryProvisioningState.fromString(reader.getString());
                } else if ("replicationStatus".equals(fieldName)) {
                    deserializedGalleryResourceProfileVersionPropertiesBase.replicationStatus
                        = ReplicationStatus.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedGalleryResourceProfileVersionPropertiesBase;
        });
    }
}
