// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Describes a data disk.
 */
@Fluent
public final class RestorePointSourceVMDataDisk implements JsonSerializable<RestorePointSourceVMDataDisk> {
    /*
     * Gets the logical unit number.
     */
    private Integer lun;

    /*
     * Gets the disk name.
     */
    private String name;

    /*
     * Gets the caching type.
     */
    private CachingTypes caching;

    /*
     * Gets the initial disk size in GB for blank data disks, and the new desired size for existing OS and Data disks.
     */
    private Integer diskSizeGB;

    /*
     * Contains the managed disk details.
     */
    private ManagedDiskParameters managedDisk;

    /*
     * Contains Disk Restore Point properties.
     */
    private DiskRestorePointAttributes diskRestorePoint;

    /*
     * Shows true if the disk is write-accelerator enabled.
     */
    private Boolean writeAcceleratorEnabled;

    /**
     * Creates an instance of RestorePointSourceVMDataDisk class.
     */
    public RestorePointSourceVMDataDisk() {
    }

    /**
     * Get the lun property: Gets the logical unit number.
     * 
     * @return the lun value.
     */
    public Integer lun() {
        return this.lun;
    }

    /**
     * Get the name property: Gets the disk name.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Get the caching property: Gets the caching type.
     * 
     * @return the caching value.
     */
    public CachingTypes caching() {
        return this.caching;
    }

    /**
     * Get the diskSizeGB property: Gets the initial disk size in GB for blank data disks, and the new desired size for
     * existing OS and Data disks.
     * 
     * @return the diskSizeGB value.
     */
    public Integer diskSizeGB() {
        return this.diskSizeGB;
    }

    /**
     * Get the managedDisk property: Contains the managed disk details.
     * 
     * @return the managedDisk value.
     */
    public ManagedDiskParameters managedDisk() {
        return this.managedDisk;
    }

    /**
     * Set the managedDisk property: Contains the managed disk details.
     * 
     * @param managedDisk the managedDisk value to set.
     * @return the RestorePointSourceVMDataDisk object itself.
     */
    public RestorePointSourceVMDataDisk withManagedDisk(ManagedDiskParameters managedDisk) {
        this.managedDisk = managedDisk;
        return this;
    }

    /**
     * Get the diskRestorePoint property: Contains Disk Restore Point properties.
     * 
     * @return the diskRestorePoint value.
     */
    public DiskRestorePointAttributes diskRestorePoint() {
        return this.diskRestorePoint;
    }

    /**
     * Set the diskRestorePoint property: Contains Disk Restore Point properties.
     * 
     * @param diskRestorePoint the diskRestorePoint value to set.
     * @return the RestorePointSourceVMDataDisk object itself.
     */
    public RestorePointSourceVMDataDisk withDiskRestorePoint(DiskRestorePointAttributes diskRestorePoint) {
        this.diskRestorePoint = diskRestorePoint;
        return this;
    }

    /**
     * Get the writeAcceleratorEnabled property: Shows true if the disk is write-accelerator enabled.
     * 
     * @return the writeAcceleratorEnabled value.
     */
    public Boolean writeAcceleratorEnabled() {
        return this.writeAcceleratorEnabled;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (managedDisk() != null) {
            managedDisk().validate();
        }
        if (diskRestorePoint() != null) {
            diskRestorePoint().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("managedDisk", this.managedDisk);
        jsonWriter.writeJsonField("diskRestorePoint", this.diskRestorePoint);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RestorePointSourceVMDataDisk from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RestorePointSourceVMDataDisk if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the RestorePointSourceVMDataDisk.
     */
    public static RestorePointSourceVMDataDisk fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RestorePointSourceVMDataDisk deserializedRestorePointSourceVMDataDisk = new RestorePointSourceVMDataDisk();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("lun".equals(fieldName)) {
                    deserializedRestorePointSourceVMDataDisk.lun = reader.getNullable(JsonReader::getInt);
                } else if ("name".equals(fieldName)) {
                    deserializedRestorePointSourceVMDataDisk.name = reader.getString();
                } else if ("caching".equals(fieldName)) {
                    deserializedRestorePointSourceVMDataDisk.caching = CachingTypes.fromString(reader.getString());
                } else if ("diskSizeGB".equals(fieldName)) {
                    deserializedRestorePointSourceVMDataDisk.diskSizeGB = reader.getNullable(JsonReader::getInt);
                } else if ("managedDisk".equals(fieldName)) {
                    deserializedRestorePointSourceVMDataDisk.managedDisk = ManagedDiskParameters.fromJson(reader);
                } else if ("diskRestorePoint".equals(fieldName)) {
                    deserializedRestorePointSourceVMDataDisk.diskRestorePoint
                        = DiskRestorePointAttributes.fromJson(reader);
                } else if ("writeAcceleratorEnabled".equals(fieldName)) {
                    deserializedRestorePointSourceVMDataDisk.writeAcceleratorEnabled
                        = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRestorePointSourceVMDataDisk;
        });
    }
}
