// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Parameters for GenerateSshKeyPair.
 */
@Fluent
public final class SshGenerateKeyPairInputParameters implements JsonSerializable<SshGenerateKeyPairInputParameters> {
    /*
     * The encryption type of the SSH keys to be generated. See SshEncryptionTypes for possible set of values. If not
     * provided, will default to RSA
     */
    private SshEncryptionTypes encryptionType;

    /**
     * Creates an instance of SshGenerateKeyPairInputParameters class.
     */
    public SshGenerateKeyPairInputParameters() {
    }

    /**
     * Get the encryptionType property: The encryption type of the SSH keys to be generated. See SshEncryptionTypes for
     * possible set of values. If not provided, will default to RSA.
     * 
     * @return the encryptionType value.
     */
    public SshEncryptionTypes encryptionType() {
        return this.encryptionType;
    }

    /**
     * Set the encryptionType property: The encryption type of the SSH keys to be generated. See SshEncryptionTypes for
     * possible set of values. If not provided, will default to RSA.
     * 
     * @param encryptionType the encryptionType value to set.
     * @return the SshGenerateKeyPairInputParameters object itself.
     */
    public SshGenerateKeyPairInputParameters withEncryptionType(SshEncryptionTypes encryptionType) {
        this.encryptionType = encryptionType;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("encryptionType",
            this.encryptionType == null ? null : this.encryptionType.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of SshGenerateKeyPairInputParameters from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of SshGenerateKeyPairInputParameters if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the SshGenerateKeyPairInputParameters.
     */
    public static SshGenerateKeyPairInputParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SshGenerateKeyPairInputParameters deserializedSshGenerateKeyPairInputParameters
                = new SshGenerateKeyPairInputParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("encryptionType".equals(fieldName)) {
                    deserializedSshGenerateKeyPairInputParameters.encryptionType
                        = SshEncryptionTypes.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedSshGenerateKeyPairInputParameters;
        });
    }
}
