// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * A disk access SAS uri.
 */
@Immutable
public final class AccessUriInner implements JsonSerializable<AccessUriInner> {
    /*
     * A SAS uri for accessing a disk.
     */
    private String accessSas;

    /*
     * A SAS uri for accessing a VM guest state.
     */
    private String securityDataAccessSas;

    /**
     * Creates an instance of AccessUriInner class.
     */
    public AccessUriInner() {
    }

    /**
     * Get the accessSas property: A SAS uri for accessing a disk.
     * 
     * @return the accessSas value.
     */
    public String accessSas() {
        return this.accessSas;
    }

    /**
     * Get the securityDataAccessSas property: A SAS uri for accessing a VM guest state.
     * 
     * @return the securityDataAccessSas value.
     */
    public String securityDataAccessSas() {
        return this.securityDataAccessSas;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AccessUriInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AccessUriInner if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the AccessUriInner.
     */
    public static AccessUriInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AccessUriInner deserializedAccessUriInner = new AccessUriInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("accessSAS".equals(fieldName)) {
                    deserializedAccessUriInner.accessSas = reader.getString();
                } else if ("securityDataAccessSAS".equals(fieldName)) {
                    deserializedAccessUriInner.securityDataAccessSas = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAccessUriInner;
        });
    }
}
