// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.GalleryImageVersionPublishingProfile;
import com.azure.resourcemanager.compute.models.GalleryImageVersionSafetyProfile;
import com.azure.resourcemanager.compute.models.GalleryImageVersionStorageProfile;
import com.azure.resourcemanager.compute.models.GalleryProvisioningState;
import com.azure.resourcemanager.compute.models.ImageVersionSecurityProfile;
import com.azure.resourcemanager.compute.models.ReplicationStatus;
import com.azure.resourcemanager.compute.models.ValidationsProfile;
import java.io.IOException;

/**
 * Describes the properties of a gallery image version.
 */
@Fluent
public final class GalleryImageVersionProperties implements JsonSerializable<GalleryImageVersionProperties> {
    /*
     * The publishing profile of a gallery image Version.
     */
    private GalleryImageVersionPublishingProfile publishingProfile;

    /*
     * The provisioning state, which only appears in the response.
     */
    private GalleryProvisioningState provisioningState;

    /*
     * This is the storage profile of a Gallery Image Version.
     */
    private GalleryImageVersionStorageProfile storageProfile;

    /*
     * This is the safety profile of the Gallery Image Version.
     */
    private GalleryImageVersionSafetyProfile safetyProfile;

    /*
     * This is the replication status of the gallery image version.
     */
    private ReplicationStatus replicationStatus;

    /*
     * The security profile of a gallery image version
     */
    private ImageVersionSecurityProfile securityProfile;

    /*
     * Indicates if this is a soft-delete resource restoration request.
     */
    private Boolean restore;

    /*
     * This is the validations profile of a Gallery Image Version.
     */
    private ValidationsProfile validationsProfile;

    /**
     * Creates an instance of GalleryImageVersionProperties class.
     */
    public GalleryImageVersionProperties() {
    }

    /**
     * Get the publishingProfile property: The publishing profile of a gallery image Version.
     * 
     * @return the publishingProfile value.
     */
    public GalleryImageVersionPublishingProfile publishingProfile() {
        return this.publishingProfile;
    }

    /**
     * Set the publishingProfile property: The publishing profile of a gallery image Version.
     * 
     * @param publishingProfile the publishingProfile value to set.
     * @return the GalleryImageVersionProperties object itself.
     */
    public GalleryImageVersionProperties withPublishingProfile(GalleryImageVersionPublishingProfile publishingProfile) {
        this.publishingProfile = publishingProfile;
        return this;
    }

    /**
     * Get the provisioningState property: The provisioning state, which only appears in the response.
     * 
     * @return the provisioningState value.
     */
    public GalleryProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the storageProfile property: This is the storage profile of a Gallery Image Version.
     * 
     * @return the storageProfile value.
     */
    public GalleryImageVersionStorageProfile storageProfile() {
        return this.storageProfile;
    }

    /**
     * Set the storageProfile property: This is the storage profile of a Gallery Image Version.
     * 
     * @param storageProfile the storageProfile value to set.
     * @return the GalleryImageVersionProperties object itself.
     */
    public GalleryImageVersionProperties withStorageProfile(GalleryImageVersionStorageProfile storageProfile) {
        this.storageProfile = storageProfile;
        return this;
    }

    /**
     * Get the safetyProfile property: This is the safety profile of the Gallery Image Version.
     * 
     * @return the safetyProfile value.
     */
    public GalleryImageVersionSafetyProfile safetyProfile() {
        return this.safetyProfile;
    }

    /**
     * Set the safetyProfile property: This is the safety profile of the Gallery Image Version.
     * 
     * @param safetyProfile the safetyProfile value to set.
     * @return the GalleryImageVersionProperties object itself.
     */
    public GalleryImageVersionProperties withSafetyProfile(GalleryImageVersionSafetyProfile safetyProfile) {
        this.safetyProfile = safetyProfile;
        return this;
    }

    /**
     * Get the replicationStatus property: This is the replication status of the gallery image version.
     * 
     * @return the replicationStatus value.
     */
    public ReplicationStatus replicationStatus() {
        return this.replicationStatus;
    }

    /**
     * Get the securityProfile property: The security profile of a gallery image version.
     * 
     * @return the securityProfile value.
     */
    public ImageVersionSecurityProfile securityProfile() {
        return this.securityProfile;
    }

    /**
     * Set the securityProfile property: The security profile of a gallery image version.
     * 
     * @param securityProfile the securityProfile value to set.
     * @return the GalleryImageVersionProperties object itself.
     */
    public GalleryImageVersionProperties withSecurityProfile(ImageVersionSecurityProfile securityProfile) {
        this.securityProfile = securityProfile;
        return this;
    }

    /**
     * Get the restore property: Indicates if this is a soft-delete resource restoration request.
     * 
     * @return the restore value.
     */
    public Boolean restore() {
        return this.restore;
    }

    /**
     * Set the restore property: Indicates if this is a soft-delete resource restoration request.
     * 
     * @param restore the restore value to set.
     * @return the GalleryImageVersionProperties object itself.
     */
    public GalleryImageVersionProperties withRestore(Boolean restore) {
        this.restore = restore;
        return this;
    }

    /**
     * Get the validationsProfile property: This is the validations profile of a Gallery Image Version.
     * 
     * @return the validationsProfile value.
     */
    public ValidationsProfile validationsProfile() {
        return this.validationsProfile;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (publishingProfile() != null) {
            publishingProfile().validate();
        }
        if (storageProfile() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property storageProfile in model GalleryImageVersionProperties"));
        } else {
            storageProfile().validate();
        }
        if (safetyProfile() != null) {
            safetyProfile().validate();
        }
        if (replicationStatus() != null) {
            replicationStatus().validate();
        }
        if (securityProfile() != null) {
            securityProfile().validate();
        }
        if (validationsProfile() != null) {
            validationsProfile().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(GalleryImageVersionProperties.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("storageProfile", this.storageProfile);
        jsonWriter.writeJsonField("publishingProfile", this.publishingProfile);
        jsonWriter.writeJsonField("safetyProfile", this.safetyProfile);
        jsonWriter.writeJsonField("securityProfile", this.securityProfile);
        jsonWriter.writeBooleanField("restore", this.restore);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of GalleryImageVersionProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of GalleryImageVersionProperties if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the GalleryImageVersionProperties.
     */
    public static GalleryImageVersionProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            GalleryImageVersionProperties deserializedGalleryImageVersionProperties
                = new GalleryImageVersionProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("storageProfile".equals(fieldName)) {
                    deserializedGalleryImageVersionProperties.storageProfile
                        = GalleryImageVersionStorageProfile.fromJson(reader);
                } else if ("publishingProfile".equals(fieldName)) {
                    deserializedGalleryImageVersionProperties.publishingProfile
                        = GalleryImageVersionPublishingProfile.fromJson(reader);
                } else if ("provisioningState".equals(fieldName)) {
                    deserializedGalleryImageVersionProperties.provisioningState
                        = GalleryProvisioningState.fromString(reader.getString());
                } else if ("safetyProfile".equals(fieldName)) {
                    deserializedGalleryImageVersionProperties.safetyProfile
                        = GalleryImageVersionSafetyProfile.fromJson(reader);
                } else if ("replicationStatus".equals(fieldName)) {
                    deserializedGalleryImageVersionProperties.replicationStatus = ReplicationStatus.fromJson(reader);
                } else if ("securityProfile".equals(fieldName)) {
                    deserializedGalleryImageVersionProperties.securityProfile
                        = ImageVersionSecurityProfile.fromJson(reader);
                } else if ("restore".equals(fieldName)) {
                    deserializedGalleryImageVersionProperties.restore = reader.getNullable(JsonReader::getBoolean);
                } else if ("validationsProfile".equals(fieldName)) {
                    deserializedGalleryImageVersionProperties.validationsProfile = ValidationsProfile.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedGalleryImageVersionProperties;
        });
    }
}
