// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.AccessControlRules;
import com.azure.resourcemanager.compute.models.AccessControlRulesMode;
import com.azure.resourcemanager.compute.models.EndpointAccess;
import com.azure.resourcemanager.compute.models.GalleryProvisioningState;
import com.azure.resourcemanager.compute.models.GalleryResourceProfileVersionPropertiesBase;
import com.azure.resourcemanager.compute.models.ReplicationStatus;
import com.azure.resourcemanager.compute.models.TargetRegion;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

/**
 * Describes the properties of an inVMAccessControlProfile version.
 */
@Fluent
public final class GalleryInVMAccessControlProfileVersionProperties
    extends GalleryResourceProfileVersionPropertiesBase {
    /*
     * This property allows you to specify whether the access control rules are in Audit mode, in Enforce mode or
     * Disabled. Possible values are: 'Audit', 'Enforce' or 'Disabled'.
     */
    private AccessControlRulesMode mode;

    /*
     * This property allows you to specify if the requests will be allowed to access the host endpoints. Possible values
     * are: 'Allow', 'Deny'.
     */
    private EndpointAccess defaultAccess;

    /*
     * This is the Access Control Rules specification for an inVMAccessControlProfile version.
     */
    private AccessControlRules rules;

    /*
     * This is the replication status of the gallery image version.
     */
    private ReplicationStatus replicationStatus;

    /*
     * The provisioning state, which only appears in the response.
     */
    private GalleryProvisioningState provisioningState;

    /*
     * The timestamp for when the Resource Profile Version is published.
     */
    private OffsetDateTime publishedDate;

    /**
     * Creates an instance of GalleryInVMAccessControlProfileVersionProperties class.
     */
    public GalleryInVMAccessControlProfileVersionProperties() {
    }

    /**
     * Get the mode property: This property allows you to specify whether the access control rules are in Audit mode, in
     * Enforce mode or Disabled. Possible values are: 'Audit', 'Enforce' or 'Disabled'.
     * 
     * @return the mode value.
     */
    public AccessControlRulesMode mode() {
        return this.mode;
    }

    /**
     * Set the mode property: This property allows you to specify whether the access control rules are in Audit mode, in
     * Enforce mode or Disabled. Possible values are: 'Audit', 'Enforce' or 'Disabled'.
     * 
     * @param mode the mode value to set.
     * @return the GalleryInVMAccessControlProfileVersionProperties object itself.
     */
    public GalleryInVMAccessControlProfileVersionProperties withMode(AccessControlRulesMode mode) {
        this.mode = mode;
        return this;
    }

    /**
     * Get the defaultAccess property: This property allows you to specify if the requests will be allowed to access the
     * host endpoints. Possible values are: 'Allow', 'Deny'.
     * 
     * @return the defaultAccess value.
     */
    public EndpointAccess defaultAccess() {
        return this.defaultAccess;
    }

    /**
     * Set the defaultAccess property: This property allows you to specify if the requests will be allowed to access the
     * host endpoints. Possible values are: 'Allow', 'Deny'.
     * 
     * @param defaultAccess the defaultAccess value to set.
     * @return the GalleryInVMAccessControlProfileVersionProperties object itself.
     */
    public GalleryInVMAccessControlProfileVersionProperties withDefaultAccess(EndpointAccess defaultAccess) {
        this.defaultAccess = defaultAccess;
        return this;
    }

    /**
     * Get the rules property: This is the Access Control Rules specification for an inVMAccessControlProfile version.
     * 
     * @return the rules value.
     */
    public AccessControlRules rules() {
        return this.rules;
    }

    /**
     * Set the rules property: This is the Access Control Rules specification for an inVMAccessControlProfile version.
     * 
     * @param rules the rules value to set.
     * @return the GalleryInVMAccessControlProfileVersionProperties object itself.
     */
    public GalleryInVMAccessControlProfileVersionProperties withRules(AccessControlRules rules) {
        this.rules = rules;
        return this;
    }

    /**
     * Get the replicationStatus property: This is the replication status of the gallery image version.
     * 
     * @return the replicationStatus value.
     */
    @Override
    public ReplicationStatus replicationStatus() {
        return this.replicationStatus;
    }

    /**
     * Get the provisioningState property: The provisioning state, which only appears in the response.
     * 
     * @return the provisioningState value.
     */
    @Override
    public GalleryProvisioningState provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the publishedDate property: The timestamp for when the Resource Profile Version is published.
     * 
     * @return the publishedDate value.
     */
    @Override
    public OffsetDateTime publishedDate() {
        return this.publishedDate;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public GalleryInVMAccessControlProfileVersionProperties withTargetLocations(List<TargetRegion> targetLocations) {
        super.withTargetLocations(targetLocations);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public GalleryInVMAccessControlProfileVersionProperties withExcludeFromLatest(Boolean excludeFromLatest) {
        super.withExcludeFromLatest(excludeFromLatest);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        if (mode() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property mode in model GalleryInVMAccessControlProfileVersionProperties"));
        }
        if (defaultAccess() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property defaultAccess in model GalleryInVMAccessControlProfileVersionProperties"));
        }
        if (rules() != null) {
            rules().validate();
        }
        if (targetLocations() != null) {
            targetLocations().forEach(e -> e.validate());
        }
        if (replicationStatus() != null) {
            replicationStatus().validate();
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(GalleryInVMAccessControlProfileVersionProperties.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("targetLocations", targetLocations(),
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeBooleanField("excludeFromLatest", excludeFromLatest());
        jsonWriter.writeStringField("mode", this.mode == null ? null : this.mode.toString());
        jsonWriter.writeStringField("defaultAccess", this.defaultAccess == null ? null : this.defaultAccess.toString());
        jsonWriter.writeJsonField("rules", this.rules);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of GalleryInVMAccessControlProfileVersionProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of GalleryInVMAccessControlProfileVersionProperties if the JsonReader was pointing to an
     * instance of it, or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the GalleryInVMAccessControlProfileVersionProperties.
     */
    public static GalleryInVMAccessControlProfileVersionProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            GalleryInVMAccessControlProfileVersionProperties deserializedGalleryInVMAccessControlProfileVersionProperties
                = new GalleryInVMAccessControlProfileVersionProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("targetLocations".equals(fieldName)) {
                    List<TargetRegion> targetLocations = reader.readArray(reader1 -> TargetRegion.fromJson(reader1));
                    deserializedGalleryInVMAccessControlProfileVersionProperties.withTargetLocations(targetLocations);
                } else if ("excludeFromLatest".equals(fieldName)) {
                    deserializedGalleryInVMAccessControlProfileVersionProperties
                        .withExcludeFromLatest(reader.getNullable(JsonReader::getBoolean));
                } else if ("publishedDate".equals(fieldName)) {
                    deserializedGalleryInVMAccessControlProfileVersionProperties.publishedDate = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("provisioningState".equals(fieldName)) {
                    deserializedGalleryInVMAccessControlProfileVersionProperties.provisioningState
                        = GalleryProvisioningState.fromString(reader.getString());
                } else if ("replicationStatus".equals(fieldName)) {
                    deserializedGalleryInVMAccessControlProfileVersionProperties.replicationStatus
                        = ReplicationStatus.fromJson(reader);
                } else if ("mode".equals(fieldName)) {
                    deserializedGalleryInVMAccessControlProfileVersionProperties.mode
                        = AccessControlRulesMode.fromString(reader.getString());
                } else if ("defaultAccess".equals(fieldName)) {
                    deserializedGalleryInVMAccessControlProfileVersionProperties.defaultAccess
                        = EndpointAccess.fromString(reader.getString());
                } else if ("rules".equals(fieldName)) {
                    deserializedGalleryInVMAccessControlProfileVersionProperties.rules
                        = AccessControlRules.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedGalleryInVMAccessControlProfileVersionProperties;
        });
    }
}
