// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.HyperVGenerationTypes;
import com.azure.resourcemanager.compute.models.ImageStorageProfile;
import java.io.IOException;

/**
 * Describes the properties of an Image.
 */
@Fluent
public final class ImageProperties implements JsonSerializable<ImageProperties> {
    /*
     * The source virtual machine from which Image is created.
     */
    private SubResource sourceVirtualMachine;

    /*
     * Specifies the storage settings for the virtual machine disks.
     */
    private ImageStorageProfile storageProfile;

    /*
     * The provisioning state.
     */
    private String provisioningState;

    /*
     * Specifies the HyperVGenerationType of the VirtualMachine created from the image. From API Version 2019-03-01 if
     * the image source is a blob, then we need the user to specify the value, if the source is managed resource like
     * disk or snapshot, we may require the user to specify the property if we cannot deduce it from the source managed
     * resource.
     */
    private HyperVGenerationTypes hyperVGeneration;

    /**
     * Creates an instance of ImageProperties class.
     */
    public ImageProperties() {
    }

    /**
     * Get the sourceVirtualMachine property: The source virtual machine from which Image is created.
     * 
     * @return the sourceVirtualMachine value.
     */
    public SubResource sourceVirtualMachine() {
        return this.sourceVirtualMachine;
    }

    /**
     * Set the sourceVirtualMachine property: The source virtual machine from which Image is created.
     * 
     * @param sourceVirtualMachine the sourceVirtualMachine value to set.
     * @return the ImageProperties object itself.
     */
    public ImageProperties withSourceVirtualMachine(SubResource sourceVirtualMachine) {
        this.sourceVirtualMachine = sourceVirtualMachine;
        return this;
    }

    /**
     * Get the storageProfile property: Specifies the storage settings for the virtual machine disks.
     * 
     * @return the storageProfile value.
     */
    public ImageStorageProfile storageProfile() {
        return this.storageProfile;
    }

    /**
     * Set the storageProfile property: Specifies the storage settings for the virtual machine disks.
     * 
     * @param storageProfile the storageProfile value to set.
     * @return the ImageProperties object itself.
     */
    public ImageProperties withStorageProfile(ImageStorageProfile storageProfile) {
        this.storageProfile = storageProfile;
        return this;
    }

    /**
     * Get the provisioningState property: The provisioning state.
     * 
     * @return the provisioningState value.
     */
    public String provisioningState() {
        return this.provisioningState;
    }

    /**
     * Get the hyperVGeneration property: Specifies the HyperVGenerationType of the VirtualMachine created from the
     * image. From API Version 2019-03-01 if the image source is a blob, then we need the user to specify the value, if
     * the source is managed resource like disk or snapshot, we may require the user to specify the property if we
     * cannot deduce it from the source managed resource.
     * 
     * @return the hyperVGeneration value.
     */
    public HyperVGenerationTypes hyperVGeneration() {
        return this.hyperVGeneration;
    }

    /**
     * Set the hyperVGeneration property: Specifies the HyperVGenerationType of the VirtualMachine created from the
     * image. From API Version 2019-03-01 if the image source is a blob, then we need the user to specify the value, if
     * the source is managed resource like disk or snapshot, we may require the user to specify the property if we
     * cannot deduce it from the source managed resource.
     * 
     * @param hyperVGeneration the hyperVGeneration value to set.
     * @return the ImageProperties object itself.
     */
    public ImageProperties withHyperVGeneration(HyperVGenerationTypes hyperVGeneration) {
        this.hyperVGeneration = hyperVGeneration;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (storageProfile() != null) {
            storageProfile().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("sourceVirtualMachine", this.sourceVirtualMachine);
        jsonWriter.writeJsonField("storageProfile", this.storageProfile);
        jsonWriter.writeStringField("hyperVGeneration",
            this.hyperVGeneration == null ? null : this.hyperVGeneration.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ImageProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ImageProperties if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the ImageProperties.
     */
    public static ImageProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ImageProperties deserializedImageProperties = new ImageProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("sourceVirtualMachine".equals(fieldName)) {
                    deserializedImageProperties.sourceVirtualMachine = SubResource.fromJson(reader);
                } else if ("storageProfile".equals(fieldName)) {
                    deserializedImageProperties.storageProfile = ImageStorageProfile.fromJson(reader);
                } else if ("provisioningState".equals(fieldName)) {
                    deserializedImageProperties.provisioningState = reader.getString();
                } else if ("hyperVGeneration".equals(fieldName)) {
                    deserializedImageProperties.hyperVGeneration = HyperVGenerationTypes.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedImageProperties;
        });
    }
}
