// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.fluent.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.OperatingSystemTypes;
import java.io.IOException;

/**
 * Describes the properties of a Run Command metadata.
 */
@Fluent
public class RunCommandDocumentBaseInner implements JsonSerializable<RunCommandDocumentBaseInner> {
    /*
     * The VM run command schema.
     */
    private String schema;

    /*
     * The VM run command id.
     */
    private String id;

    /*
     * The Operating System type.
     */
    private OperatingSystemTypes osType;

    /*
     * The VM run command label.
     */
    private String label;

    /*
     * The VM run command description.
     */
    private String description;

    /**
     * Creates an instance of RunCommandDocumentBaseInner class.
     */
    public RunCommandDocumentBaseInner() {
    }

    /**
     * Get the schema property: The VM run command schema.
     * 
     * @return the schema value.
     */
    public String schema() {
        return this.schema;
    }

    /**
     * Set the schema property: The VM run command schema.
     * 
     * @param schema the schema value to set.
     * @return the RunCommandDocumentBaseInner object itself.
     */
    public RunCommandDocumentBaseInner withSchema(String schema) {
        this.schema = schema;
        return this;
    }

    /**
     * Get the id property: The VM run command id.
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Set the id property: The VM run command id.
     * 
     * @param id the id value to set.
     * @return the RunCommandDocumentBaseInner object itself.
     */
    public RunCommandDocumentBaseInner withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Get the osType property: The Operating System type.
     * 
     * @return the osType value.
     */
    public OperatingSystemTypes osType() {
        return this.osType;
    }

    /**
     * Set the osType property: The Operating System type.
     * 
     * @param osType the osType value to set.
     * @return the RunCommandDocumentBaseInner object itself.
     */
    public RunCommandDocumentBaseInner withOsType(OperatingSystemTypes osType) {
        this.osType = osType;
        return this;
    }

    /**
     * Get the label property: The VM run command label.
     * 
     * @return the label value.
     */
    public String label() {
        return this.label;
    }

    /**
     * Set the label property: The VM run command label.
     * 
     * @param label the label value to set.
     * @return the RunCommandDocumentBaseInner object itself.
     */
    public RunCommandDocumentBaseInner withLabel(String label) {
        this.label = label;
        return this;
    }

    /**
     * Get the description property: The VM run command description.
     * 
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description property: The VM run command description.
     * 
     * @param description the description value to set.
     * @return the RunCommandDocumentBaseInner object itself.
     */
    public RunCommandDocumentBaseInner withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (schema() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property schema in model RunCommandDocumentBaseInner"));
        }
        if (id() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property id in model RunCommandDocumentBaseInner"));
        }
        if (osType() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property osType in model RunCommandDocumentBaseInner"));
        }
        if (label() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property label in model RunCommandDocumentBaseInner"));
        }
        if (description() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property description in model RunCommandDocumentBaseInner"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(RunCommandDocumentBaseInner.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("$schema", this.schema);
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("osType", this.osType == null ? null : this.osType.toString());
        jsonWriter.writeStringField("label", this.label);
        jsonWriter.writeStringField("description", this.description);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RunCommandDocumentBaseInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RunCommandDocumentBaseInner if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the RunCommandDocumentBaseInner.
     */
    public static RunCommandDocumentBaseInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RunCommandDocumentBaseInner deserializedRunCommandDocumentBaseInner = new RunCommandDocumentBaseInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("$schema".equals(fieldName)) {
                    deserializedRunCommandDocumentBaseInner.schema = reader.getString();
                } else if ("id".equals(fieldName)) {
                    deserializedRunCommandDocumentBaseInner.id = reader.getString();
                } else if ("osType".equals(fieldName)) {
                    deserializedRunCommandDocumentBaseInner.osType
                        = OperatingSystemTypes.fromString(reader.getString());
                } else if ("label".equals(fieldName)) {
                    deserializedRunCommandDocumentBaseInner.label = reader.getString();
                } else if ("description".equals(fieldName)) {
                    deserializedRunCommandDocumentBaseInner.description = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRunCommandDocumentBaseInner;
        });
    }
}
