// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.fluent.models;

import com.azure.core.annotation.Immutable;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.models.ApiError;
import com.azure.resourcemanager.compute.models.PatchInstallationDetail;
import com.azure.resourcemanager.compute.models.PatchOperationStatus;
import com.azure.resourcemanager.compute.models.VMGuestPatchRebootStatus;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;

/**
 * The result summary of an installation operation.
 */
@Immutable
public final class VirtualMachineInstallPatchesResultInner
    implements JsonSerializable<VirtualMachineInstallPatchesResultInner> {
    /*
     * The overall success or failure status of the operation. It remains "InProgress" until the operation completes. At
     * that point it will become "Failed", "Succeeded", "Unknown" or "CompletedWithWarnings."
     */
    private PatchOperationStatus status;

    /*
     * The activity ID of the operation that produced this result. It is used to correlate across CRP and extension
     * logs.
     */
    private String installationActivityId;

    /*
     * The reboot state of the VM following completion of the operation.
     */
    private VMGuestPatchRebootStatus rebootStatus;

    /*
     * Whether the operation ran out of time before it completed all its intended actions.
     */
    private Boolean maintenanceWindowExceeded;

    /*
     * The number of patches that were not installed due to the user blocking their installation.
     */
    private Integer excludedPatchCount;

    /*
     * The number of patches that were detected as available for install, but did not meet the operation's criteria.
     */
    private Integer notSelectedPatchCount;

    /*
     * The number of patches that were identified as meeting the installation criteria, but were not able to be
     * installed. Typically this happens when maintenanceWindowExceeded == true.
     */
    private Integer pendingPatchCount;

    /*
     * The number of patches successfully installed.
     */
    private Integer installedPatchCount;

    /*
     * The number of patches that could not be installed due to some issue. See errors for details.
     */
    private Integer failedPatchCount;

    /*
     * The patches that were installed during the operation.
     */
    private List<PatchInstallationDetail> patches;

    /*
     * The UTC timestamp when the operation began.
     */
    private OffsetDateTime startDateTime;

    /*
     * The errors that were encountered during execution of the operation. The details array contains the list of them.
     */
    private ApiError error;

    /**
     * Creates an instance of VirtualMachineInstallPatchesResultInner class.
     */
    public VirtualMachineInstallPatchesResultInner() {
    }

    /**
     * Get the status property: The overall success or failure status of the operation. It remains "InProgress" until
     * the operation completes. At that point it will become "Failed", "Succeeded", "Unknown" or
     * "CompletedWithWarnings.".
     * 
     * @return the status value.
     */
    public PatchOperationStatus status() {
        return this.status;
    }

    /**
     * Get the installationActivityId property: The activity ID of the operation that produced this result. It is used
     * to correlate across CRP and extension logs.
     * 
     * @return the installationActivityId value.
     */
    public String installationActivityId() {
        return this.installationActivityId;
    }

    /**
     * Get the rebootStatus property: The reboot state of the VM following completion of the operation.
     * 
     * @return the rebootStatus value.
     */
    public VMGuestPatchRebootStatus rebootStatus() {
        return this.rebootStatus;
    }

    /**
     * Get the maintenanceWindowExceeded property: Whether the operation ran out of time before it completed all its
     * intended actions.
     * 
     * @return the maintenanceWindowExceeded value.
     */
    public Boolean maintenanceWindowExceeded() {
        return this.maintenanceWindowExceeded;
    }

    /**
     * Get the excludedPatchCount property: The number of patches that were not installed due to the user blocking their
     * installation.
     * 
     * @return the excludedPatchCount value.
     */
    public Integer excludedPatchCount() {
        return this.excludedPatchCount;
    }

    /**
     * Get the notSelectedPatchCount property: The number of patches that were detected as available for install, but
     * did not meet the operation's criteria.
     * 
     * @return the notSelectedPatchCount value.
     */
    public Integer notSelectedPatchCount() {
        return this.notSelectedPatchCount;
    }

    /**
     * Get the pendingPatchCount property: The number of patches that were identified as meeting the installation
     * criteria, but were not able to be installed. Typically this happens when maintenanceWindowExceeded == true.
     * 
     * @return the pendingPatchCount value.
     */
    public Integer pendingPatchCount() {
        return this.pendingPatchCount;
    }

    /**
     * Get the installedPatchCount property: The number of patches successfully installed.
     * 
     * @return the installedPatchCount value.
     */
    public Integer installedPatchCount() {
        return this.installedPatchCount;
    }

    /**
     * Get the failedPatchCount property: The number of patches that could not be installed due to some issue. See
     * errors for details.
     * 
     * @return the failedPatchCount value.
     */
    public Integer failedPatchCount() {
        return this.failedPatchCount;
    }

    /**
     * Get the patches property: The patches that were installed during the operation.
     * 
     * @return the patches value.
     */
    public List<PatchInstallationDetail> patches() {
        return this.patches;
    }

    /**
     * Get the startDateTime property: The UTC timestamp when the operation began.
     * 
     * @return the startDateTime value.
     */
    public OffsetDateTime startDateTime() {
        return this.startDateTime;
    }

    /**
     * Get the error property: The errors that were encountered during execution of the operation. The details array
     * contains the list of them.
     * 
     * @return the error value.
     */
    public ApiError error() {
        return this.error;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (patches() != null) {
            patches().forEach(e -> e.validate());
        }
        if (error() != null) {
            error().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of VirtualMachineInstallPatchesResultInner from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of VirtualMachineInstallPatchesResultInner if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the VirtualMachineInstallPatchesResultInner.
     */
    public static VirtualMachineInstallPatchesResultInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            VirtualMachineInstallPatchesResultInner deserializedVirtualMachineInstallPatchesResultInner
                = new VirtualMachineInstallPatchesResultInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("status".equals(fieldName)) {
                    deserializedVirtualMachineInstallPatchesResultInner.status
                        = PatchOperationStatus.fromString(reader.getString());
                } else if ("installationActivityId".equals(fieldName)) {
                    deserializedVirtualMachineInstallPatchesResultInner.installationActivityId = reader.getString();
                } else if ("rebootStatus".equals(fieldName)) {
                    deserializedVirtualMachineInstallPatchesResultInner.rebootStatus
                        = VMGuestPatchRebootStatus.fromString(reader.getString());
                } else if ("maintenanceWindowExceeded".equals(fieldName)) {
                    deserializedVirtualMachineInstallPatchesResultInner.maintenanceWindowExceeded
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("excludedPatchCount".equals(fieldName)) {
                    deserializedVirtualMachineInstallPatchesResultInner.excludedPatchCount
                        = reader.getNullable(JsonReader::getInt);
                } else if ("notSelectedPatchCount".equals(fieldName)) {
                    deserializedVirtualMachineInstallPatchesResultInner.notSelectedPatchCount
                        = reader.getNullable(JsonReader::getInt);
                } else if ("pendingPatchCount".equals(fieldName)) {
                    deserializedVirtualMachineInstallPatchesResultInner.pendingPatchCount
                        = reader.getNullable(JsonReader::getInt);
                } else if ("installedPatchCount".equals(fieldName)) {
                    deserializedVirtualMachineInstallPatchesResultInner.installedPatchCount
                        = reader.getNullable(JsonReader::getInt);
                } else if ("failedPatchCount".equals(fieldName)) {
                    deserializedVirtualMachineInstallPatchesResultInner.failedPatchCount
                        = reader.getNullable(JsonReader::getInt);
                } else if ("patches".equals(fieldName)) {
                    List<PatchInstallationDetail> patches
                        = reader.readArray(reader1 -> PatchInstallationDetail.fromJson(reader1));
                    deserializedVirtualMachineInstallPatchesResultInner.patches = patches;
                } else if ("startDateTime".equals(fieldName)) {
                    deserializedVirtualMachineInstallPatchesResultInner.startDateTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("error".equals(fieldName)) {
                    deserializedVirtualMachineInstallPatchesResultInner.error = ApiError.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedVirtualMachineInstallPatchesResultInner;
        });
    }
}
