// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.implementation;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.Host;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceInterface;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.RestProxy;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.compute.fluent.GalleryInVMAccessControlProfilesClient;
import com.azure.resourcemanager.compute.fluent.models.GalleryInVMAccessControlProfileInner;
import com.azure.resourcemanager.compute.models.ApiErrorException;
import com.azure.resourcemanager.compute.models.GalleryInVMAccessControlProfileList;
import com.azure.resourcemanager.compute.models.GalleryInVMAccessControlProfileUpdate;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

/**
 * An instance of this class provides access to all the operations defined in GalleryInVMAccessControlProfilesClient.
 */
public final class GalleryInVMAccessControlProfilesClientImpl implements GalleryInVMAccessControlProfilesClient {
    /**
     * The proxy service used to perform REST calls.
     */
    private final GalleryInVMAccessControlProfilesService service;

    /**
     * The service client containing this operation class.
     */
    private final ComputeManagementClientImpl client;

    /**
     * Initializes an instance of GalleryInVMAccessControlProfilesClientImpl.
     * 
     * @param client the instance of the service client containing this operation class.
     */
    GalleryInVMAccessControlProfilesClientImpl(ComputeManagementClientImpl client) {
        this.service = RestProxy.create(GalleryInVMAccessControlProfilesService.class, client.getHttpPipeline(),
            client.getSerializerAdapter());
        this.client = client;
    }

    /**
     * The interface defining all the services for ComputeManagementClientGalleryInVMAccessControlProfiles to be used by
     * the proxy service to perform REST calls.
     */
    @Host("{$host}")
    @ServiceInterface(name = "ComputeManagementCli")
    public interface GalleryInVMAccessControlProfilesService {
        @Headers({ "Content-Type: application/json" })
        @Put("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/inVMAccessControlProfiles/{inVMAccessControlProfileName}")
        @ExpectedResponses({ 200, 201 })
        @UnexpectedResponseExceptionType(ApiErrorException.class)
        Mono<Response<Flux<ByteBuffer>>> createOrUpdate(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("galleryName") String galleryName,
            @PathParam("inVMAccessControlProfileName") String inVMAccessControlProfileName,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") GalleryInVMAccessControlProfileInner galleryInVMAccessControlProfile,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Patch("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/inVMAccessControlProfiles/{inVMAccessControlProfileName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ApiErrorException.class)
        Mono<Response<Flux<ByteBuffer>>> update(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("galleryName") String galleryName,
            @PathParam("inVMAccessControlProfileName") String inVMAccessControlProfileName,
            @QueryParam("api-version") String apiVersion,
            @BodyParam("application/json") GalleryInVMAccessControlProfileUpdate galleryInVMAccessControlProfile,
            @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/inVMAccessControlProfiles/{inVMAccessControlProfileName}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ApiErrorException.class)
        Mono<Response<GalleryInVMAccessControlProfileInner>> get(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("galleryName") String galleryName,
            @PathParam("inVMAccessControlProfileName") String inVMAccessControlProfileName,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Delete("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/inVMAccessControlProfiles/{inVMAccessControlProfileName}")
        @ExpectedResponses({ 202, 204 })
        @UnexpectedResponseExceptionType(ApiErrorException.class)
        Mono<Response<Flux<ByteBuffer>>> delete(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("galleryName") String galleryName,
            @PathParam("inVMAccessControlProfileName") String inVMAccessControlProfileName,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/inVMAccessControlProfiles")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ApiErrorException.class)
        Mono<Response<GalleryInVMAccessControlProfileList>> listByGallery(@HostParam("$host") String endpoint,
            @PathParam("subscriptionId") String subscriptionId,
            @PathParam("resourceGroupName") String resourceGroupName, @PathParam("galleryName") String galleryName,
            @QueryParam("api-version") String apiVersion, @HeaderParam("Accept") String accept, Context context);

        @Headers({ "Content-Type: application/json" })
        @Get("{nextLink}")
        @ExpectedResponses({ 200 })
        @UnexpectedResponseExceptionType(ApiErrorException.class)
        Mono<Response<GalleryInVMAccessControlProfileList>> listByGalleryNext(
            @PathParam(value = "nextLink", encoded = true) String nextLink, @HostParam("$host") String endpoint,
            @HeaderParam("Accept") String accept, Context context);
    }

    /**
     * Create or update a gallery inVMAccessControlProfile.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery in which the InVMAccessControlProfile is to be created.
     * @param inVMAccessControlProfileName The name of the gallery inVMAccessControlProfile to be created or updated.
     * The allowed characters are alphabets and numbers with dots, dashes, and periods allowed in the middle. The
     * maximum length is 80 characters.
     * @param galleryInVMAccessControlProfile Parameters supplied to the create or update gallery
     * inVMAccessControlProfile operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery inVMAccessControlProfile that you want to create or update along
     * with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName,
        String galleryName, String inVMAccessControlProfileName,
        GalleryInVMAccessControlProfileInner galleryInVMAccessControlProfile) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (galleryName == null) {
            return Mono.error(new IllegalArgumentException("Parameter galleryName is required and cannot be null."));
        }
        if (inVMAccessControlProfileName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter inVMAccessControlProfileName is required and cannot be null."));
        }
        if (galleryInVMAccessControlProfile == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter galleryInVMAccessControlProfile is required and cannot be null."));
        } else {
            galleryInVMAccessControlProfile.validate();
        }
        final String apiVersion = "2024-03-03";
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.createOrUpdate(this.client.getEndpoint(), this.client.getSubscriptionId(),
                resourceGroupName, galleryName, inVMAccessControlProfileName, apiVersion,
                galleryInVMAccessControlProfile, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Create or update a gallery inVMAccessControlProfile.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery in which the InVMAccessControlProfile is to be created.
     * @param inVMAccessControlProfileName The name of the gallery inVMAccessControlProfile to be created or updated.
     * The allowed characters are alphabets and numbers with dots, dashes, and periods allowed in the middle. The
     * maximum length is 80 characters.
     * @param galleryInVMAccessControlProfile Parameters supplied to the create or update gallery
     * inVMAccessControlProfile operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery inVMAccessControlProfile that you want to create or update along
     * with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> createOrUpdateWithResponseAsync(String resourceGroupName,
        String galleryName, String inVMAccessControlProfileName,
        GalleryInVMAccessControlProfileInner galleryInVMAccessControlProfile, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (galleryName == null) {
            return Mono.error(new IllegalArgumentException("Parameter galleryName is required and cannot be null."));
        }
        if (inVMAccessControlProfileName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter inVMAccessControlProfileName is required and cannot be null."));
        }
        if (galleryInVMAccessControlProfile == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter galleryInVMAccessControlProfile is required and cannot be null."));
        } else {
            galleryInVMAccessControlProfile.validate();
        }
        final String apiVersion = "2024-03-03";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.createOrUpdate(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName,
            galleryName, inVMAccessControlProfileName, apiVersion, galleryInVMAccessControlProfile, accept, context);
    }

    /**
     * Create or update a gallery inVMAccessControlProfile.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery in which the InVMAccessControlProfile is to be created.
     * @param inVMAccessControlProfileName The name of the gallery inVMAccessControlProfile to be created or updated.
     * The allowed characters are alphabets and numbers with dots, dashes, and periods allowed in the middle. The
     * maximum length is 80 characters.
     * @param galleryInVMAccessControlProfile Parameters supplied to the create or update gallery
     * inVMAccessControlProfile operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of specifies information about the gallery inVMAccessControlProfile
     * that you want to create or update.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<GalleryInVMAccessControlProfileInner>, GalleryInVMAccessControlProfileInner>
        beginCreateOrUpdateAsync(String resourceGroupName, String galleryName, String inVMAccessControlProfileName,
            GalleryInVMAccessControlProfileInner galleryInVMAccessControlProfile) {
        Mono<Response<Flux<ByteBuffer>>> mono = createOrUpdateWithResponseAsync(resourceGroupName, galleryName,
            inVMAccessControlProfileName, galleryInVMAccessControlProfile);
        return this.client.<GalleryInVMAccessControlProfileInner, GalleryInVMAccessControlProfileInner>getLroResult(
            mono, this.client.getHttpPipeline(), GalleryInVMAccessControlProfileInner.class,
            GalleryInVMAccessControlProfileInner.class, this.client.getContext());
    }

    /**
     * Create or update a gallery inVMAccessControlProfile.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery in which the InVMAccessControlProfile is to be created.
     * @param inVMAccessControlProfileName The name of the gallery inVMAccessControlProfile to be created or updated.
     * The allowed characters are alphabets and numbers with dots, dashes, and periods allowed in the middle. The
     * maximum length is 80 characters.
     * @param galleryInVMAccessControlProfile Parameters supplied to the create or update gallery
     * inVMAccessControlProfile operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of specifies information about the gallery inVMAccessControlProfile
     * that you want to create or update.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<GalleryInVMAccessControlProfileInner>, GalleryInVMAccessControlProfileInner>
        beginCreateOrUpdateAsync(String resourceGroupName, String galleryName, String inVMAccessControlProfileName,
            GalleryInVMAccessControlProfileInner galleryInVMAccessControlProfile, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = createOrUpdateWithResponseAsync(resourceGroupName, galleryName,
            inVMAccessControlProfileName, galleryInVMAccessControlProfile, context);
        return this.client.<GalleryInVMAccessControlProfileInner, GalleryInVMAccessControlProfileInner>getLroResult(
            mono, this.client.getHttpPipeline(), GalleryInVMAccessControlProfileInner.class,
            GalleryInVMAccessControlProfileInner.class, context);
    }

    /**
     * Create or update a gallery inVMAccessControlProfile.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery in which the InVMAccessControlProfile is to be created.
     * @param inVMAccessControlProfileName The name of the gallery inVMAccessControlProfile to be created or updated.
     * The allowed characters are alphabets and numbers with dots, dashes, and periods allowed in the middle. The
     * maximum length is 80 characters.
     * @param galleryInVMAccessControlProfile Parameters supplied to the create or update gallery
     * inVMAccessControlProfile operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of specifies information about the gallery inVMAccessControlProfile
     * that you want to create or update.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<GalleryInVMAccessControlProfileInner>, GalleryInVMAccessControlProfileInner>
        beginCreateOrUpdate(String resourceGroupName, String galleryName, String inVMAccessControlProfileName,
            GalleryInVMAccessControlProfileInner galleryInVMAccessControlProfile) {
        return this
            .beginCreateOrUpdateAsync(resourceGroupName, galleryName, inVMAccessControlProfileName,
                galleryInVMAccessControlProfile)
            .getSyncPoller();
    }

    /**
     * Create or update a gallery inVMAccessControlProfile.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery in which the InVMAccessControlProfile is to be created.
     * @param inVMAccessControlProfileName The name of the gallery inVMAccessControlProfile to be created or updated.
     * The allowed characters are alphabets and numbers with dots, dashes, and periods allowed in the middle. The
     * maximum length is 80 characters.
     * @param galleryInVMAccessControlProfile Parameters supplied to the create or update gallery
     * inVMAccessControlProfile operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of specifies information about the gallery inVMAccessControlProfile
     * that you want to create or update.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<GalleryInVMAccessControlProfileInner>, GalleryInVMAccessControlProfileInner>
        beginCreateOrUpdate(String resourceGroupName, String galleryName, String inVMAccessControlProfileName,
            GalleryInVMAccessControlProfileInner galleryInVMAccessControlProfile, Context context) {
        return this
            .beginCreateOrUpdateAsync(resourceGroupName, galleryName, inVMAccessControlProfileName,
                galleryInVMAccessControlProfile, context)
            .getSyncPoller();
    }

    /**
     * Create or update a gallery inVMAccessControlProfile.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery in which the InVMAccessControlProfile is to be created.
     * @param inVMAccessControlProfileName The name of the gallery inVMAccessControlProfile to be created or updated.
     * The allowed characters are alphabets and numbers with dots, dashes, and periods allowed in the middle. The
     * maximum length is 80 characters.
     * @param galleryInVMAccessControlProfile Parameters supplied to the create or update gallery
     * inVMAccessControlProfile operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery inVMAccessControlProfile that you want to create or update on
     * successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<GalleryInVMAccessControlProfileInner> createOrUpdateAsync(String resourceGroupName, String galleryName,
        String inVMAccessControlProfileName, GalleryInVMAccessControlProfileInner galleryInVMAccessControlProfile) {
        return beginCreateOrUpdateAsync(resourceGroupName, galleryName, inVMAccessControlProfileName,
            galleryInVMAccessControlProfile).last().flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Create or update a gallery inVMAccessControlProfile.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery in which the InVMAccessControlProfile is to be created.
     * @param inVMAccessControlProfileName The name of the gallery inVMAccessControlProfile to be created or updated.
     * The allowed characters are alphabets and numbers with dots, dashes, and periods allowed in the middle. The
     * maximum length is 80 characters.
     * @param galleryInVMAccessControlProfile Parameters supplied to the create or update gallery
     * inVMAccessControlProfile operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery inVMAccessControlProfile that you want to create or update on
     * successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<GalleryInVMAccessControlProfileInner> createOrUpdateAsync(String resourceGroupName, String galleryName,
        String inVMAccessControlProfileName, GalleryInVMAccessControlProfileInner galleryInVMAccessControlProfile,
        Context context) {
        return beginCreateOrUpdateAsync(resourceGroupName, galleryName, inVMAccessControlProfileName,
            galleryInVMAccessControlProfile, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Create or update a gallery inVMAccessControlProfile.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery in which the InVMAccessControlProfile is to be created.
     * @param inVMAccessControlProfileName The name of the gallery inVMAccessControlProfile to be created or updated.
     * The allowed characters are alphabets and numbers with dots, dashes, and periods allowed in the middle. The
     * maximum length is 80 characters.
     * @param galleryInVMAccessControlProfile Parameters supplied to the create or update gallery
     * inVMAccessControlProfile operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery inVMAccessControlProfile that you want to create or update.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public GalleryInVMAccessControlProfileInner createOrUpdate(String resourceGroupName, String galleryName,
        String inVMAccessControlProfileName, GalleryInVMAccessControlProfileInner galleryInVMAccessControlProfile) {
        return createOrUpdateAsync(resourceGroupName, galleryName, inVMAccessControlProfileName,
            galleryInVMAccessControlProfile).block();
    }

    /**
     * Create or update a gallery inVMAccessControlProfile.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery in which the InVMAccessControlProfile is to be created.
     * @param inVMAccessControlProfileName The name of the gallery inVMAccessControlProfile to be created or updated.
     * The allowed characters are alphabets and numbers with dots, dashes, and periods allowed in the middle. The
     * maximum length is 80 characters.
     * @param galleryInVMAccessControlProfile Parameters supplied to the create or update gallery
     * inVMAccessControlProfile operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery inVMAccessControlProfile that you want to create or update.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public GalleryInVMAccessControlProfileInner createOrUpdate(String resourceGroupName, String galleryName,
        String inVMAccessControlProfileName, GalleryInVMAccessControlProfileInner galleryInVMAccessControlProfile,
        Context context) {
        return createOrUpdateAsync(resourceGroupName, galleryName, inVMAccessControlProfileName,
            galleryInVMAccessControlProfile, context).block();
    }

    /**
     * Update a gallery inVMAccessControlProfile.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery in which the InVMAccessControlProfile is to be updated.
     * @param inVMAccessControlProfileName The name of the gallery inVMAccessControlProfile to be updated. The allowed
     * characters are alphabets and numbers with dots, dashes, and periods allowed in the middle. The maximum length is
     * 80 characters.
     * @param galleryInVMAccessControlProfile Parameters supplied to the update gallery inVMAccessControlProfile
     * operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery inVMAccessControlProfile that you want to create or update along
     * with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String galleryName,
        String inVMAccessControlProfileName, GalleryInVMAccessControlProfileUpdate galleryInVMAccessControlProfile) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (galleryName == null) {
            return Mono.error(new IllegalArgumentException("Parameter galleryName is required and cannot be null."));
        }
        if (inVMAccessControlProfileName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter inVMAccessControlProfileName is required and cannot be null."));
        }
        if (galleryInVMAccessControlProfile == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter galleryInVMAccessControlProfile is required and cannot be null."));
        } else {
            galleryInVMAccessControlProfile.validate();
        }
        final String apiVersion = "2024-03-03";
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.update(this.client.getEndpoint(), this.client.getSubscriptionId(),
                resourceGroupName, galleryName, inVMAccessControlProfileName, apiVersion,
                galleryInVMAccessControlProfile, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Update a gallery inVMAccessControlProfile.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery in which the InVMAccessControlProfile is to be updated.
     * @param inVMAccessControlProfileName The name of the gallery inVMAccessControlProfile to be updated. The allowed
     * characters are alphabets and numbers with dots, dashes, and periods allowed in the middle. The maximum length is
     * 80 characters.
     * @param galleryInVMAccessControlProfile Parameters supplied to the update gallery inVMAccessControlProfile
     * operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery inVMAccessControlProfile that you want to create or update along
     * with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> updateWithResponseAsync(String resourceGroupName, String galleryName,
        String inVMAccessControlProfileName, GalleryInVMAccessControlProfileUpdate galleryInVMAccessControlProfile,
        Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (galleryName == null) {
            return Mono.error(new IllegalArgumentException("Parameter galleryName is required and cannot be null."));
        }
        if (inVMAccessControlProfileName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter inVMAccessControlProfileName is required and cannot be null."));
        }
        if (galleryInVMAccessControlProfile == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter galleryInVMAccessControlProfile is required and cannot be null."));
        } else {
            galleryInVMAccessControlProfile.validate();
        }
        final String apiVersion = "2024-03-03";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.update(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName,
            galleryName, inVMAccessControlProfileName, apiVersion, galleryInVMAccessControlProfile, accept, context);
    }

    /**
     * Update a gallery inVMAccessControlProfile.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery in which the InVMAccessControlProfile is to be updated.
     * @param inVMAccessControlProfileName The name of the gallery inVMAccessControlProfile to be updated. The allowed
     * characters are alphabets and numbers with dots, dashes, and periods allowed in the middle. The maximum length is
     * 80 characters.
     * @param galleryInVMAccessControlProfile Parameters supplied to the update gallery inVMAccessControlProfile
     * operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of specifies information about the gallery inVMAccessControlProfile
     * that you want to create or update.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<GalleryInVMAccessControlProfileInner>, GalleryInVMAccessControlProfileInner>
        beginUpdateAsync(String resourceGroupName, String galleryName, String inVMAccessControlProfileName,
            GalleryInVMAccessControlProfileUpdate galleryInVMAccessControlProfile) {
        Mono<Response<Flux<ByteBuffer>>> mono = updateWithResponseAsync(resourceGroupName, galleryName,
            inVMAccessControlProfileName, galleryInVMAccessControlProfile);
        return this.client.<GalleryInVMAccessControlProfileInner, GalleryInVMAccessControlProfileInner>getLroResult(
            mono, this.client.getHttpPipeline(), GalleryInVMAccessControlProfileInner.class,
            GalleryInVMAccessControlProfileInner.class, this.client.getContext());
    }

    /**
     * Update a gallery inVMAccessControlProfile.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery in which the InVMAccessControlProfile is to be updated.
     * @param inVMAccessControlProfileName The name of the gallery inVMAccessControlProfile to be updated. The allowed
     * characters are alphabets and numbers with dots, dashes, and periods allowed in the middle. The maximum length is
     * 80 characters.
     * @param galleryInVMAccessControlProfile Parameters supplied to the update gallery inVMAccessControlProfile
     * operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of specifies information about the gallery inVMAccessControlProfile
     * that you want to create or update.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<GalleryInVMAccessControlProfileInner>, GalleryInVMAccessControlProfileInner>
        beginUpdateAsync(String resourceGroupName, String galleryName, String inVMAccessControlProfileName,
            GalleryInVMAccessControlProfileUpdate galleryInVMAccessControlProfile, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono = updateWithResponseAsync(resourceGroupName, galleryName,
            inVMAccessControlProfileName, galleryInVMAccessControlProfile, context);
        return this.client.<GalleryInVMAccessControlProfileInner, GalleryInVMAccessControlProfileInner>getLroResult(
            mono, this.client.getHttpPipeline(), GalleryInVMAccessControlProfileInner.class,
            GalleryInVMAccessControlProfileInner.class, context);
    }

    /**
     * Update a gallery inVMAccessControlProfile.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery in which the InVMAccessControlProfile is to be updated.
     * @param inVMAccessControlProfileName The name of the gallery inVMAccessControlProfile to be updated. The allowed
     * characters are alphabets and numbers with dots, dashes, and periods allowed in the middle. The maximum length is
     * 80 characters.
     * @param galleryInVMAccessControlProfile Parameters supplied to the update gallery inVMAccessControlProfile
     * operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of specifies information about the gallery inVMAccessControlProfile
     * that you want to create or update.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<GalleryInVMAccessControlProfileInner>, GalleryInVMAccessControlProfileInner>
        beginUpdate(String resourceGroupName, String galleryName, String inVMAccessControlProfileName,
            GalleryInVMAccessControlProfileUpdate galleryInVMAccessControlProfile) {
        return this
            .beginUpdateAsync(resourceGroupName, galleryName, inVMAccessControlProfileName,
                galleryInVMAccessControlProfile)
            .getSyncPoller();
    }

    /**
     * Update a gallery inVMAccessControlProfile.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery in which the InVMAccessControlProfile is to be updated.
     * @param inVMAccessControlProfileName The name of the gallery inVMAccessControlProfile to be updated. The allowed
     * characters are alphabets and numbers with dots, dashes, and periods allowed in the middle. The maximum length is
     * 80 characters.
     * @param galleryInVMAccessControlProfile Parameters supplied to the update gallery inVMAccessControlProfile
     * operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of specifies information about the gallery inVMAccessControlProfile
     * that you want to create or update.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<GalleryInVMAccessControlProfileInner>, GalleryInVMAccessControlProfileInner>
        beginUpdate(String resourceGroupName, String galleryName, String inVMAccessControlProfileName,
            GalleryInVMAccessControlProfileUpdate galleryInVMAccessControlProfile, Context context) {
        return this
            .beginUpdateAsync(resourceGroupName, galleryName, inVMAccessControlProfileName,
                galleryInVMAccessControlProfile, context)
            .getSyncPoller();
    }

    /**
     * Update a gallery inVMAccessControlProfile.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery in which the InVMAccessControlProfile is to be updated.
     * @param inVMAccessControlProfileName The name of the gallery inVMAccessControlProfile to be updated. The allowed
     * characters are alphabets and numbers with dots, dashes, and periods allowed in the middle. The maximum length is
     * 80 characters.
     * @param galleryInVMAccessControlProfile Parameters supplied to the update gallery inVMAccessControlProfile
     * operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery inVMAccessControlProfile that you want to create or update on
     * successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<GalleryInVMAccessControlProfileInner> updateAsync(String resourceGroupName, String galleryName,
        String inVMAccessControlProfileName, GalleryInVMAccessControlProfileUpdate galleryInVMAccessControlProfile) {
        return beginUpdateAsync(resourceGroupName, galleryName, inVMAccessControlProfileName,
            galleryInVMAccessControlProfile).last().flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Update a gallery inVMAccessControlProfile.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery in which the InVMAccessControlProfile is to be updated.
     * @param inVMAccessControlProfileName The name of the gallery inVMAccessControlProfile to be updated. The allowed
     * characters are alphabets and numbers with dots, dashes, and periods allowed in the middle. The maximum length is
     * 80 characters.
     * @param galleryInVMAccessControlProfile Parameters supplied to the update gallery inVMAccessControlProfile
     * operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery inVMAccessControlProfile that you want to create or update on
     * successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<GalleryInVMAccessControlProfileInner> updateAsync(String resourceGroupName, String galleryName,
        String inVMAccessControlProfileName, GalleryInVMAccessControlProfileUpdate galleryInVMAccessControlProfile,
        Context context) {
        return beginUpdateAsync(resourceGroupName, galleryName, inVMAccessControlProfileName,
            galleryInVMAccessControlProfile, context).last().flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Update a gallery inVMAccessControlProfile.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery in which the InVMAccessControlProfile is to be updated.
     * @param inVMAccessControlProfileName The name of the gallery inVMAccessControlProfile to be updated. The allowed
     * characters are alphabets and numbers with dots, dashes, and periods allowed in the middle. The maximum length is
     * 80 characters.
     * @param galleryInVMAccessControlProfile Parameters supplied to the update gallery inVMAccessControlProfile
     * operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery inVMAccessControlProfile that you want to create or update.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public GalleryInVMAccessControlProfileInner update(String resourceGroupName, String galleryName,
        String inVMAccessControlProfileName, GalleryInVMAccessControlProfileUpdate galleryInVMAccessControlProfile) {
        return updateAsync(resourceGroupName, galleryName, inVMAccessControlProfileName,
            galleryInVMAccessControlProfile).block();
    }

    /**
     * Update a gallery inVMAccessControlProfile.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery in which the InVMAccessControlProfile is to be updated.
     * @param inVMAccessControlProfileName The name of the gallery inVMAccessControlProfile to be updated. The allowed
     * characters are alphabets and numbers with dots, dashes, and periods allowed in the middle. The maximum length is
     * 80 characters.
     * @param galleryInVMAccessControlProfile Parameters supplied to the update gallery inVMAccessControlProfile
     * operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery inVMAccessControlProfile that you want to create or update.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public GalleryInVMAccessControlProfileInner update(String resourceGroupName, String galleryName,
        String inVMAccessControlProfileName, GalleryInVMAccessControlProfileUpdate galleryInVMAccessControlProfile,
        Context context) {
        return updateAsync(resourceGroupName, galleryName, inVMAccessControlProfileName,
            galleryInVMAccessControlProfile, context).block();
    }

    /**
     * Retrieves information about a gallery inVMAccessControlProfile.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery from which the InVMAccessControlProfiles are to be
     * retrieved.
     * @param inVMAccessControlProfileName The name of the gallery inVMAccessControlProfile to be retrieved.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery inVMAccessControlProfile that you want to create or update along
     * with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<GalleryInVMAccessControlProfileInner>> getWithResponseAsync(String resourceGroupName,
        String galleryName, String inVMAccessControlProfileName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (galleryName == null) {
            return Mono.error(new IllegalArgumentException("Parameter galleryName is required and cannot be null."));
        }
        if (inVMAccessControlProfileName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter inVMAccessControlProfileName is required and cannot be null."));
        }
        final String apiVersion = "2024-03-03";
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.get(this.client.getEndpoint(), this.client.getSubscriptionId(),
                resourceGroupName, galleryName, inVMAccessControlProfileName, apiVersion, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Retrieves information about a gallery inVMAccessControlProfile.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery from which the InVMAccessControlProfiles are to be
     * retrieved.
     * @param inVMAccessControlProfileName The name of the gallery inVMAccessControlProfile to be retrieved.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery inVMAccessControlProfile that you want to create or update along
     * with {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<GalleryInVMAccessControlProfileInner>> getWithResponseAsync(String resourceGroupName,
        String galleryName, String inVMAccessControlProfileName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (galleryName == null) {
            return Mono.error(new IllegalArgumentException("Parameter galleryName is required and cannot be null."));
        }
        if (inVMAccessControlProfileName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter inVMAccessControlProfileName is required and cannot be null."));
        }
        final String apiVersion = "2024-03-03";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.get(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, galleryName,
            inVMAccessControlProfileName, apiVersion, accept, context);
    }

    /**
     * Retrieves information about a gallery inVMAccessControlProfile.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery from which the InVMAccessControlProfiles are to be
     * retrieved.
     * @param inVMAccessControlProfileName The name of the gallery inVMAccessControlProfile to be retrieved.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery inVMAccessControlProfile that you want to create or update on
     * successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<GalleryInVMAccessControlProfileInner> getAsync(String resourceGroupName, String galleryName,
        String inVMAccessControlProfileName) {
        return getWithResponseAsync(resourceGroupName, galleryName, inVMAccessControlProfileName)
            .flatMap(res -> Mono.justOrEmpty(res.getValue()));
    }

    /**
     * Retrieves information about a gallery inVMAccessControlProfile.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery from which the InVMAccessControlProfiles are to be
     * retrieved.
     * @param inVMAccessControlProfileName The name of the gallery inVMAccessControlProfile to be retrieved.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery inVMAccessControlProfile that you want to create or update along
     * with {@link Response}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Response<GalleryInVMAccessControlProfileInner> getWithResponse(String resourceGroupName, String galleryName,
        String inVMAccessControlProfileName, Context context) {
        return getWithResponseAsync(resourceGroupName, galleryName, inVMAccessControlProfileName, context).block();
    }

    /**
     * Retrieves information about a gallery inVMAccessControlProfile.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery from which the InVMAccessControlProfiles are to be
     * retrieved.
     * @param inVMAccessControlProfileName The name of the gallery inVMAccessControlProfile to be retrieved.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return specifies information about the gallery inVMAccessControlProfile that you want to create or update.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public GalleryInVMAccessControlProfileInner get(String resourceGroupName, String galleryName,
        String inVMAccessControlProfileName) {
        return getWithResponse(resourceGroupName, galleryName, inVMAccessControlProfileName, Context.NONE).getValue();
    }

    /**
     * Delete a gallery inVMAccessControlProfile.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param galleryName he name of the Shared Image Gallery in which the InVMAccessControlProfile resides.
     * @param inVMAccessControlProfileName The name of the gallery inVMAccessControlProfile to be deleted.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String galleryName,
        String inVMAccessControlProfileName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (galleryName == null) {
            return Mono.error(new IllegalArgumentException("Parameter galleryName is required and cannot be null."));
        }
        if (inVMAccessControlProfileName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter inVMAccessControlProfileName is required and cannot be null."));
        }
        final String apiVersion = "2024-03-03";
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(),
                resourceGroupName, galleryName, inVMAccessControlProfileName, apiVersion, accept, context))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Delete a gallery inVMAccessControlProfile.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param galleryName he name of the Shared Image Gallery in which the InVMAccessControlProfile resides.
     * @param inVMAccessControlProfileName The name of the gallery inVMAccessControlProfile to be deleted.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link Response} on successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Response<Flux<ByteBuffer>>> deleteWithResponseAsync(String resourceGroupName, String galleryName,
        String inVMAccessControlProfileName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (galleryName == null) {
            return Mono.error(new IllegalArgumentException("Parameter galleryName is required and cannot be null."));
        }
        if (inVMAccessControlProfileName == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter inVMAccessControlProfileName is required and cannot be null."));
        }
        final String apiVersion = "2024-03-03";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.delete(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName,
            galleryName, inVMAccessControlProfileName, apiVersion, accept, context);
    }

    /**
     * Delete a gallery inVMAccessControlProfile.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param galleryName he name of the Shared Image Gallery in which the InVMAccessControlProfile resides.
     * @param inVMAccessControlProfileName The name of the gallery inVMAccessControlProfile to be deleted.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String galleryName,
        String inVMAccessControlProfileName) {
        Mono<Response<Flux<ByteBuffer>>> mono
            = deleteWithResponseAsync(resourceGroupName, galleryName, inVMAccessControlProfileName);
        return this.client.<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class,
            this.client.getContext());
    }

    /**
     * Delete a gallery inVMAccessControlProfile.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param galleryName he name of the Shared Image Gallery in which the InVMAccessControlProfile resides.
     * @param inVMAccessControlProfileName The name of the gallery inVMAccessControlProfile to be deleted.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link PollerFlux} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    private PollerFlux<PollResult<Void>, Void> beginDeleteAsync(String resourceGroupName, String galleryName,
        String inVMAccessControlProfileName, Context context) {
        context = this.client.mergeContext(context);
        Mono<Response<Flux<ByteBuffer>>> mono
            = deleteWithResponseAsync(resourceGroupName, galleryName, inVMAccessControlProfileName, context);
        return this.client.<Void, Void>getLroResult(mono, this.client.getHttpPipeline(), Void.class, Void.class,
            context);
    }

    /**
     * Delete a gallery inVMAccessControlProfile.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param galleryName he name of the Shared Image Gallery in which the InVMAccessControlProfile resides.
     * @param inVMAccessControlProfileName The name of the gallery inVMAccessControlProfile to be deleted.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String galleryName,
        String inVMAccessControlProfileName) {
        return this.beginDeleteAsync(resourceGroupName, galleryName, inVMAccessControlProfileName).getSyncPoller();
    }

    /**
     * Delete a gallery inVMAccessControlProfile.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param galleryName he name of the Shared Image Gallery in which the InVMAccessControlProfile resides.
     * @param inVMAccessControlProfileName The name of the gallery inVMAccessControlProfile to be deleted.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the {@link SyncPoller} for polling of long-running operation.
     */
    @ServiceMethod(returns = ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginDelete(String resourceGroupName, String galleryName,
        String inVMAccessControlProfileName, Context context) {
        return this.beginDeleteAsync(resourceGroupName, galleryName, inVMAccessControlProfileName, context)
            .getSyncPoller();
    }

    /**
     * Delete a gallery inVMAccessControlProfile.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param galleryName he name of the Shared Image Gallery in which the InVMAccessControlProfile resides.
     * @param inVMAccessControlProfileName The name of the gallery inVMAccessControlProfile to be deleted.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String resourceGroupName, String galleryName, String inVMAccessControlProfileName) {
        return beginDeleteAsync(resourceGroupName, galleryName, inVMAccessControlProfileName).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Delete a gallery inVMAccessControlProfile.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param galleryName he name of the Shared Image Gallery in which the InVMAccessControlProfile resides.
     * @param inVMAccessControlProfileName The name of the gallery inVMAccessControlProfile to be deleted.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return A {@link Mono} that completes when a successful response is received.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<Void> deleteAsync(String resourceGroupName, String galleryName, String inVMAccessControlProfileName,
        Context context) {
        return beginDeleteAsync(resourceGroupName, galleryName, inVMAccessControlProfileName, context).last()
            .flatMap(this.client::getLroFinalResultOrError);
    }

    /**
     * Delete a gallery inVMAccessControlProfile.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param galleryName he name of the Shared Image Gallery in which the InVMAccessControlProfile resides.
     * @param inVMAccessControlProfileName The name of the gallery inVMAccessControlProfile to be deleted.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void delete(String resourceGroupName, String galleryName, String inVMAccessControlProfileName) {
        deleteAsync(resourceGroupName, galleryName, inVMAccessControlProfileName).block();
    }

    /**
     * Delete a gallery inVMAccessControlProfile.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param galleryName he name of the Shared Image Gallery in which the InVMAccessControlProfile resides.
     * @param inVMAccessControlProfileName The name of the gallery inVMAccessControlProfile to be deleted.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    public void delete(String resourceGroupName, String galleryName, String inVMAccessControlProfileName,
        Context context) {
        deleteAsync(resourceGroupName, galleryName, inVMAccessControlProfileName, context).block();
    }

    /**
     * List gallery inVMAccessControlProfiles in a gallery.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery from which the InVMAccessControlProfiles are to be
     * listed.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List Gallery InVMAccessControlProfiles operation response along with {@link PagedResponse} on
     * successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<GalleryInVMAccessControlProfileInner>>
        listByGallerySinglePageAsync(String resourceGroupName, String galleryName) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (galleryName == null) {
            return Mono.error(new IllegalArgumentException("Parameter galleryName is required and cannot be null."));
        }
        final String apiVersion = "2024-03-03";
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listByGallery(this.client.getEndpoint(), this.client.getSubscriptionId(),
                resourceGroupName, galleryName, apiVersion, accept, context))
            .<PagedResponse<GalleryInVMAccessControlProfileInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * List gallery inVMAccessControlProfiles in a gallery.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery from which the InVMAccessControlProfiles are to be
     * listed.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List Gallery InVMAccessControlProfiles operation response along with {@link PagedResponse} on
     * successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<GalleryInVMAccessControlProfileInner>>
        listByGallerySinglePageAsync(String resourceGroupName, String galleryName, Context context) {
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        if (this.client.getSubscriptionId() == null) {
            return Mono.error(new IllegalArgumentException(
                "Parameter this.client.getSubscriptionId() is required and cannot be null."));
        }
        if (resourceGroupName == null) {
            return Mono
                .error(new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null."));
        }
        if (galleryName == null) {
            return Mono.error(new IllegalArgumentException("Parameter galleryName is required and cannot be null."));
        }
        final String apiVersion = "2024-03-03";
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service
            .listByGallery(this.client.getEndpoint(), this.client.getSubscriptionId(), resourceGroupName, galleryName,
                apiVersion, accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }

    /**
     * List gallery inVMAccessControlProfiles in a gallery.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery from which the InVMAccessControlProfiles are to be
     * listed.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List Gallery InVMAccessControlProfiles operation response as paginated response with
     * {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedFlux<GalleryInVMAccessControlProfileInner> listByGalleryAsync(String resourceGroupName,
        String galleryName) {
        return new PagedFlux<>(() -> listByGallerySinglePageAsync(resourceGroupName, galleryName),
            nextLink -> listByGalleryNextSinglePageAsync(nextLink));
    }

    /**
     * List gallery inVMAccessControlProfiles in a gallery.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery from which the InVMAccessControlProfiles are to be
     * listed.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List Gallery InVMAccessControlProfiles operation response as paginated response with
     * {@link PagedFlux}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    private PagedFlux<GalleryInVMAccessControlProfileInner> listByGalleryAsync(String resourceGroupName,
        String galleryName, Context context) {
        return new PagedFlux<>(() -> listByGallerySinglePageAsync(resourceGroupName, galleryName, context),
            nextLink -> listByGalleryNextSinglePageAsync(nextLink, context));
    }

    /**
     * List gallery inVMAccessControlProfiles in a gallery.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery from which the InVMAccessControlProfiles are to be
     * listed.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List Gallery InVMAccessControlProfiles operation response as paginated response with
     * {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<GalleryInVMAccessControlProfileInner> listByGallery(String resourceGroupName,
        String galleryName) {
        return new PagedIterable<>(listByGalleryAsync(resourceGroupName, galleryName));
    }

    /**
     * List gallery inVMAccessControlProfiles in a gallery.
     * 
     * @param resourceGroupName The name of the resource group.
     * @param galleryName The name of the Shared Image Gallery from which the InVMAccessControlProfiles are to be
     * listed.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List Gallery InVMAccessControlProfiles operation response as paginated response with
     * {@link PagedIterable}.
     */
    @ServiceMethod(returns = ReturnType.COLLECTION)
    public PagedIterable<GalleryInVMAccessControlProfileInner> listByGallery(String resourceGroupName,
        String galleryName, Context context) {
        return new PagedIterable<>(listByGalleryAsync(resourceGroupName, galleryName, context));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List Gallery InVMAccessControlProfiles operation response along with {@link PagedResponse} on
     * successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<GalleryInVMAccessControlProfileInner>>
        listByGalleryNextSinglePageAsync(String nextLink) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        return FluxUtil
            .withContext(context -> service.listByGalleryNext(nextLink, this.client.getEndpoint(), accept, context))
            .<PagedResponse<GalleryInVMAccessControlProfileInner>>map(res -> new PagedResponseBase<>(res.getRequest(),
                res.getStatusCode(), res.getHeaders(), res.getValue().value(), res.getValue().nextLink(), null))
            .contextWrite(context -> context.putAll(FluxUtil.toReactorContext(this.client.getContext()).readOnly()));
    }

    /**
     * Get the next page of items.
     * 
     * @param nextLink The URL to get the next list of items.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws ApiErrorException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the List Gallery InVMAccessControlProfiles operation response along with {@link PagedResponse} on
     * successful completion of {@link Mono}.
     */
    @ServiceMethod(returns = ReturnType.SINGLE)
    private Mono<PagedResponse<GalleryInVMAccessControlProfileInner>> listByGalleryNextSinglePageAsync(String nextLink,
        Context context) {
        if (nextLink == null) {
            return Mono.error(new IllegalArgumentException("Parameter nextLink is required and cannot be null."));
        }
        if (this.client.getEndpoint() == null) {
            return Mono.error(
                new IllegalArgumentException("Parameter this.client.getEndpoint() is required and cannot be null."));
        }
        final String accept = "application/json";
        context = this.client.mergeContext(context);
        return service.listByGalleryNext(nextLink, this.client.getEndpoint(), accept, context)
            .map(res -> new PagedResponseBase<>(res.getRequest(), res.getStatusCode(), res.getHeaders(),
                res.getValue().value(), res.getValue().nextLink(), null));
    }
}
