// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * This is the Access Control Rules specification for an inVMAccessControlProfile version.
 */
@Fluent
public final class AccessControlRules implements JsonSerializable<AccessControlRules> {
    /*
     * A list of privileges.
     */
    private List<AccessControlRulesPrivilege> privileges;

    /*
     * A list of roles.
     */
    private List<AccessControlRulesRole> roles;

    /*
     * A list of identities.
     */
    private List<AccessControlRulesIdentity> identities;

    /*
     * A list of role assignments.
     */
    private List<AccessControlRulesRoleAssignment> roleAssignments;

    /**
     * Creates an instance of AccessControlRules class.
     */
    public AccessControlRules() {
    }

    /**
     * Get the privileges property: A list of privileges.
     * 
     * @return the privileges value.
     */
    public List<AccessControlRulesPrivilege> privileges() {
        return this.privileges;
    }

    /**
     * Set the privileges property: A list of privileges.
     * 
     * @param privileges the privileges value to set.
     * @return the AccessControlRules object itself.
     */
    public AccessControlRules withPrivileges(List<AccessControlRulesPrivilege> privileges) {
        this.privileges = privileges;
        return this;
    }

    /**
     * Get the roles property: A list of roles.
     * 
     * @return the roles value.
     */
    public List<AccessControlRulesRole> roles() {
        return this.roles;
    }

    /**
     * Set the roles property: A list of roles.
     * 
     * @param roles the roles value to set.
     * @return the AccessControlRules object itself.
     */
    public AccessControlRules withRoles(List<AccessControlRulesRole> roles) {
        this.roles = roles;
        return this;
    }

    /**
     * Get the identities property: A list of identities.
     * 
     * @return the identities value.
     */
    public List<AccessControlRulesIdentity> identities() {
        return this.identities;
    }

    /**
     * Set the identities property: A list of identities.
     * 
     * @param identities the identities value to set.
     * @return the AccessControlRules object itself.
     */
    public AccessControlRules withIdentities(List<AccessControlRulesIdentity> identities) {
        this.identities = identities;
        return this;
    }

    /**
     * Get the roleAssignments property: A list of role assignments.
     * 
     * @return the roleAssignments value.
     */
    public List<AccessControlRulesRoleAssignment> roleAssignments() {
        return this.roleAssignments;
    }

    /**
     * Set the roleAssignments property: A list of role assignments.
     * 
     * @param roleAssignments the roleAssignments value to set.
     * @return the AccessControlRules object itself.
     */
    public AccessControlRules withRoleAssignments(List<AccessControlRulesRoleAssignment> roleAssignments) {
        this.roleAssignments = roleAssignments;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (privileges() != null) {
            privileges().forEach(e -> e.validate());
        }
        if (roles() != null) {
            roles().forEach(e -> e.validate());
        }
        if (identities() != null) {
            identities().forEach(e -> e.validate());
        }
        if (roleAssignments() != null) {
            roleAssignments().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("privileges", this.privileges, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("roles", this.roles, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("identities", this.identities, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("roleAssignments", this.roleAssignments,
            (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AccessControlRules from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AccessControlRules if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the AccessControlRules.
     */
    public static AccessControlRules fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AccessControlRules deserializedAccessControlRules = new AccessControlRules();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("privileges".equals(fieldName)) {
                    List<AccessControlRulesPrivilege> privileges
                        = reader.readArray(reader1 -> AccessControlRulesPrivilege.fromJson(reader1));
                    deserializedAccessControlRules.privileges = privileges;
                } else if ("roles".equals(fieldName)) {
                    List<AccessControlRulesRole> roles
                        = reader.readArray(reader1 -> AccessControlRulesRole.fromJson(reader1));
                    deserializedAccessControlRules.roles = roles;
                } else if ("identities".equals(fieldName)) {
                    List<AccessControlRulesIdentity> identities
                        = reader.readArray(reader1 -> AccessControlRulesIdentity.fromJson(reader1));
                    deserializedAccessControlRules.identities = identities;
                } else if ("roleAssignments".equals(fieldName)) {
                    List<AccessControlRulesRoleAssignment> roleAssignments
                        = reader.readArray(reader1 -> AccessControlRulesRoleAssignment.fromJson(reader1));
                    deserializedAccessControlRules.roleAssignments = roleAssignments;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAccessControlRules;
        });
    }
}
