// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Describes automatic OS upgrade properties on the image.
 */
@Fluent
public final class AutomaticOSUpgradeProperties implements JsonSerializable<AutomaticOSUpgradeProperties> {
    /*
     * Specifies whether automatic OS upgrade is supported on the image.
     */
    private boolean automaticOSUpgradeSupported;

    /**
     * Creates an instance of AutomaticOSUpgradeProperties class.
     */
    public AutomaticOSUpgradeProperties() {
    }

    /**
     * Get the automaticOSUpgradeSupported property: Specifies whether automatic OS upgrade is supported on the image.
     * 
     * @return the automaticOSUpgradeSupported value.
     */
    public boolean automaticOSUpgradeSupported() {
        return this.automaticOSUpgradeSupported;
    }

    /**
     * Set the automaticOSUpgradeSupported property: Specifies whether automatic OS upgrade is supported on the image.
     * 
     * @param automaticOSUpgradeSupported the automaticOSUpgradeSupported value to set.
     * @return the AutomaticOSUpgradeProperties object itself.
     */
    public AutomaticOSUpgradeProperties withAutomaticOSUpgradeSupported(boolean automaticOSUpgradeSupported) {
        this.automaticOSUpgradeSupported = automaticOSUpgradeSupported;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("automaticOSUpgradeSupported", this.automaticOSUpgradeSupported);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AutomaticOSUpgradeProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AutomaticOSUpgradeProperties if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the AutomaticOSUpgradeProperties.
     */
    public static AutomaticOSUpgradeProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AutomaticOSUpgradeProperties deserializedAutomaticOSUpgradeProperties = new AutomaticOSUpgradeProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("automaticOSUpgradeSupported".equals(fieldName)) {
                    deserializedAutomaticOSUpgradeProperties.automaticOSUpgradeSupported = reader.getBoolean();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAutomaticOSUpgradeProperties;
        });
    }
}
