// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.SubResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Protected settings for the extension, referenced using KeyVault which are encrypted before sent to the role instance.
 */
@Fluent
public final class CloudServiceVaultAndSecretReference
    implements JsonSerializable<CloudServiceVaultAndSecretReference> {
    /*
     * The ARM Resource ID of the Key Vault
     */
    private SubResource sourceVault;

    /*
     * Secret URL which contains the protected settings of the extension
     */
    private String secretUrl;

    /**
     * Creates an instance of CloudServiceVaultAndSecretReference class.
     */
    public CloudServiceVaultAndSecretReference() {
    }

    /**
     * Get the sourceVault property: The ARM Resource ID of the Key Vault.
     * 
     * @return the sourceVault value.
     */
    public SubResource sourceVault() {
        return this.sourceVault;
    }

    /**
     * Set the sourceVault property: The ARM Resource ID of the Key Vault.
     * 
     * @param sourceVault the sourceVault value to set.
     * @return the CloudServiceVaultAndSecretReference object itself.
     */
    public CloudServiceVaultAndSecretReference withSourceVault(SubResource sourceVault) {
        this.sourceVault = sourceVault;
        return this;
    }

    /**
     * Get the secretUrl property: Secret URL which contains the protected settings of the extension.
     * 
     * @return the secretUrl value.
     */
    public String secretUrl() {
        return this.secretUrl;
    }

    /**
     * Set the secretUrl property: Secret URL which contains the protected settings of the extension.
     * 
     * @param secretUrl the secretUrl value to set.
     * @return the CloudServiceVaultAndSecretReference object itself.
     */
    public CloudServiceVaultAndSecretReference withSecretUrl(String secretUrl) {
        this.secretUrl = secretUrl;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("sourceVault", this.sourceVault);
        jsonWriter.writeStringField("secretUrl", this.secretUrl);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CloudServiceVaultAndSecretReference from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of CloudServiceVaultAndSecretReference if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the CloudServiceVaultAndSecretReference.
     */
    public static CloudServiceVaultAndSecretReference fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CloudServiceVaultAndSecretReference deserializedCloudServiceVaultAndSecretReference
                = new CloudServiceVaultAndSecretReference();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("sourceVault".equals(fieldName)) {
                    deserializedCloudServiceVaultAndSecretReference.sourceVault = SubResource.fromJson(reader);
                } else if ("secretUrl".equals(fieldName)) {
                    deserializedCloudServiceVaultAndSecretReference.secretUrl = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedCloudServiceVaultAndSecretReference;
        });
    }
}
