// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The instance view of a disk restore point.
 */
@Fluent
public final class DiskRestorePointReplicationStatus implements JsonSerializable<DiskRestorePointReplicationStatus> {
    /*
     * The resource status information.
     */
    private InstanceViewStatus status;

    /*
     * Replication completion percentage.
     */
    private Integer completionPercent;

    /**
     * Creates an instance of DiskRestorePointReplicationStatus class.
     */
    public DiskRestorePointReplicationStatus() {
    }

    /**
     * Get the status property: The resource status information.
     * 
     * @return the status value.
     */
    public InstanceViewStatus status() {
        return this.status;
    }

    /**
     * Set the status property: The resource status information.
     * 
     * @param status the status value to set.
     * @return the DiskRestorePointReplicationStatus object itself.
     */
    public DiskRestorePointReplicationStatus withStatus(InstanceViewStatus status) {
        this.status = status;
        return this;
    }

    /**
     * Get the completionPercent property: Replication completion percentage.
     * 
     * @return the completionPercent value.
     */
    public Integer completionPercent() {
        return this.completionPercent;
    }

    /**
     * Set the completionPercent property: Replication completion percentage.
     * 
     * @param completionPercent the completionPercent value to set.
     * @return the DiskRestorePointReplicationStatus object itself.
     */
    public DiskRestorePointReplicationStatus withCompletionPercent(Integer completionPercent) {
        this.completionPercent = completionPercent;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (status() != null) {
            status().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("status", this.status);
        jsonWriter.writeNumberField("completionPercent", this.completionPercent);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of DiskRestorePointReplicationStatus from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of DiskRestorePointReplicationStatus if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the DiskRestorePointReplicationStatus.
     */
    public static DiskRestorePointReplicationStatus fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            DiskRestorePointReplicationStatus deserializedDiskRestorePointReplicationStatus
                = new DiskRestorePointReplicationStatus();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("status".equals(fieldName)) {
                    deserializedDiskRestorePointReplicationStatus.status = InstanceViewStatus.fromJson(reader);
                } else if ("completionPercent".equals(fieldName)) {
                    deserializedDiskRestorePointReplicationStatus.completionPercent
                        = reader.getNullable(JsonReader::getInt);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedDiskRestorePointReplicationStatus;
        });
    }
}
