// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * This property allows you to specify if the requests will be allowed to access the host endpoints. Possible values
 * are: 'Allow', 'Deny'.
 */
public final class EndpointAccess extends ExpandableStringEnum<EndpointAccess> {
    /**
     * Static value Allow for EndpointAccess.
     */
    public static final EndpointAccess ALLOW = fromString("Allow");

    /**
     * Static value Deny for EndpointAccess.
     */
    public static final EndpointAccess DENY = fromString("Deny");

    /**
     * Creates a new instance of EndpointAccess value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public EndpointAccess() {
    }

    /**
     * Creates or finds a EndpointAccess from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding EndpointAccess.
     */
    public static EndpointAccess fromString(String name) {
        return fromString(name, EndpointAccess.class);
    }

    /**
     * Gets known EndpointAccess values.
     * 
     * @return known EndpointAccess values.
     */
    public static Collection<EndpointAccess> values() {
        return values(EndpointAccess.class);
    }
}
