// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * A custom action that can be performed with a Gallery Application Version.
 */
@Fluent
public final class GalleryApplicationCustomAction implements JsonSerializable<GalleryApplicationCustomAction> {
    /*
     * The name of the custom action. Must be unique within the Gallery Application Version.
     */
    private String name;

    /*
     * The script to run when executing this custom action.
     */
    private String script;

    /*
     * Description to help the users understand what this custom action does.
     */
    private String description;

    /*
     * The parameters that this custom action uses
     */
    private List<GalleryApplicationCustomActionParameter> parameters;

    /**
     * Creates an instance of GalleryApplicationCustomAction class.
     */
    public GalleryApplicationCustomAction() {
    }

    /**
     * Get the name property: The name of the custom action. Must be unique within the Gallery Application Version.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The name of the custom action. Must be unique within the Gallery Application Version.
     * 
     * @param name the name value to set.
     * @return the GalleryApplicationCustomAction object itself.
     */
    public GalleryApplicationCustomAction withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the script property: The script to run when executing this custom action.
     * 
     * @return the script value.
     */
    public String script() {
        return this.script;
    }

    /**
     * Set the script property: The script to run when executing this custom action.
     * 
     * @param script the script value to set.
     * @return the GalleryApplicationCustomAction object itself.
     */
    public GalleryApplicationCustomAction withScript(String script) {
        this.script = script;
        return this;
    }

    /**
     * Get the description property: Description to help the users understand what this custom action does.
     * 
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description property: Description to help the users understand what this custom action does.
     * 
     * @param description the description value to set.
     * @return the GalleryApplicationCustomAction object itself.
     */
    public GalleryApplicationCustomAction withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the parameters property: The parameters that this custom action uses.
     * 
     * @return the parameters value.
     */
    public List<GalleryApplicationCustomActionParameter> parameters() {
        return this.parameters;
    }

    /**
     * Set the parameters property: The parameters that this custom action uses.
     * 
     * @param parameters the parameters value to set.
     * @return the GalleryApplicationCustomAction object itself.
     */
    public GalleryApplicationCustomAction withParameters(List<GalleryApplicationCustomActionParameter> parameters) {
        this.parameters = parameters;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (name() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property name in model GalleryApplicationCustomAction"));
        }
        if (script() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property script in model GalleryApplicationCustomAction"));
        }
        if (parameters() != null) {
            parameters().forEach(e -> e.validate());
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(GalleryApplicationCustomAction.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("script", this.script);
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeArrayField("parameters", this.parameters, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of GalleryApplicationCustomAction from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of GalleryApplicationCustomAction if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the GalleryApplicationCustomAction.
     */
    public static GalleryApplicationCustomAction fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            GalleryApplicationCustomAction deserializedGalleryApplicationCustomAction
                = new GalleryApplicationCustomAction();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedGalleryApplicationCustomAction.name = reader.getString();
                } else if ("script".equals(fieldName)) {
                    deserializedGalleryApplicationCustomAction.script = reader.getString();
                } else if ("description".equals(fieldName)) {
                    deserializedGalleryApplicationCustomAction.description = reader.getString();
                } else if ("parameters".equals(fieldName)) {
                    List<GalleryApplicationCustomActionParameter> parameters
                        = reader.readArray(reader1 -> GalleryApplicationCustomActionParameter.fromJson(reader1));
                    deserializedGalleryApplicationCustomAction.parameters = parameters;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedGalleryApplicationCustomAction;
        });
    }
}
