// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.compute.fluent.models.GalleryInVMAccessControlProfileInner;
import java.io.IOException;
import java.util.List;

/**
 * The List Gallery InVMAccessControlProfiles operation response.
 */
@Fluent
public final class GalleryInVMAccessControlProfileList
    implements JsonSerializable<GalleryInVMAccessControlProfileList> {
    /*
     * A list of Gallery InVMAccessControlProfiles.
     */
    private List<GalleryInVMAccessControlProfileInner> value;

    /*
     * The uri to fetch the next page of inVMAccessControlProfiles in the gallery. Call ListNext() with this to fetch
     * the next page of gallery inVMAccessControlProfiles.
     */
    private String nextLink;

    /**
     * Creates an instance of GalleryInVMAccessControlProfileList class.
     */
    public GalleryInVMAccessControlProfileList() {
    }

    /**
     * Get the value property: A list of Gallery InVMAccessControlProfiles.
     * 
     * @return the value value.
     */
    public List<GalleryInVMAccessControlProfileInner> value() {
        return this.value;
    }

    /**
     * Set the value property: A list of Gallery InVMAccessControlProfiles.
     * 
     * @param value the value value to set.
     * @return the GalleryInVMAccessControlProfileList object itself.
     */
    public GalleryInVMAccessControlProfileList withValue(List<GalleryInVMAccessControlProfileInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: The uri to fetch the next page of inVMAccessControlProfiles in the gallery. Call
     * ListNext() with this to fetch the next page of gallery inVMAccessControlProfiles.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: The uri to fetch the next page of inVMAccessControlProfiles in the gallery. Call
     * ListNext() with this to fetch the next page of gallery inVMAccessControlProfiles.
     * 
     * @param nextLink the nextLink value to set.
     * @return the GalleryInVMAccessControlProfileList object itself.
     */
    public GalleryInVMAccessControlProfileList withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property value in model GalleryInVMAccessControlProfileList"));
        } else {
            value().forEach(e -> e.validate());
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(GalleryInVMAccessControlProfileList.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of GalleryInVMAccessControlProfileList from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of GalleryInVMAccessControlProfileList if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the GalleryInVMAccessControlProfileList.
     */
    public static GalleryInVMAccessControlProfileList fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            GalleryInVMAccessControlProfileList deserializedGalleryInVMAccessControlProfileList
                = new GalleryInVMAccessControlProfileList();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<GalleryInVMAccessControlProfileInner> value
                        = reader.readArray(reader1 -> GalleryInVMAccessControlProfileInner.fromJson(reader1));
                    deserializedGalleryInVMAccessControlProfileList.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedGalleryInVMAccessControlProfileList.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedGalleryInVMAccessControlProfileList;
        });
    }
}
