// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The security profile of a gallery image version.
 */
@Fluent
public final class ImageVersionSecurityProfile implements JsonSerializable<ImageVersionSecurityProfile> {
    /*
     * Contains UEFI settings for the image version.
     */
    private GalleryImageVersionUefiSettings uefiSettings;

    /**
     * Creates an instance of ImageVersionSecurityProfile class.
     */
    public ImageVersionSecurityProfile() {
    }

    /**
     * Get the uefiSettings property: Contains UEFI settings for the image version.
     * 
     * @return the uefiSettings value.
     */
    public GalleryImageVersionUefiSettings uefiSettings() {
        return this.uefiSettings;
    }

    /**
     * Set the uefiSettings property: Contains UEFI settings for the image version.
     * 
     * @param uefiSettings the uefiSettings value to set.
     * @return the ImageVersionSecurityProfile object itself.
     */
    public ImageVersionSecurityProfile withUefiSettings(GalleryImageVersionUefiSettings uefiSettings) {
        this.uefiSettings = uefiSettings;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (uefiSettings() != null) {
            uefiSettings().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("uefiSettings", this.uefiSettings);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ImageVersionSecurityProfile from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ImageVersionSecurityProfile if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ImageVersionSecurityProfile.
     */
    public static ImageVersionSecurityProfile fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ImageVersionSecurityProfile deserializedImageVersionSecurityProfile = new ImageVersionSecurityProfile();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("uefiSettings".equals(fieldName)) {
                    deserializedImageVersionSecurityProfile.uefiSettings
                        = GalleryImageVersionUefiSettings.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedImageVersionSecurityProfile;
        });
    }
}
