// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Describes a reference to Key Vault Key.
 */
@Fluent
public final class KeyVaultKeyReference implements JsonSerializable<KeyVaultKeyReference> {
    /*
     * The URL referencing a key encryption key in Key Vault.
     */
    private String keyUrl;

    /*
     * The relative URL of the Key Vault containing the key.
     */
    private SubResource sourceVault;

    /**
     * Creates an instance of KeyVaultKeyReference class.
     */
    public KeyVaultKeyReference() {
    }

    /**
     * Get the keyUrl property: The URL referencing a key encryption key in Key Vault.
     * 
     * @return the keyUrl value.
     */
    public String keyUrl() {
        return this.keyUrl;
    }

    /**
     * Set the keyUrl property: The URL referencing a key encryption key in Key Vault.
     * 
     * @param keyUrl the keyUrl value to set.
     * @return the KeyVaultKeyReference object itself.
     */
    public KeyVaultKeyReference withKeyUrl(String keyUrl) {
        this.keyUrl = keyUrl;
        return this;
    }

    /**
     * Get the sourceVault property: The relative URL of the Key Vault containing the key.
     * 
     * @return the sourceVault value.
     */
    public SubResource sourceVault() {
        return this.sourceVault;
    }

    /**
     * Set the sourceVault property: The relative URL of the Key Vault containing the key.
     * 
     * @param sourceVault the sourceVault value to set.
     * @return the KeyVaultKeyReference object itself.
     */
    public KeyVaultKeyReference withSourceVault(SubResource sourceVault) {
        this.sourceVault = sourceVault;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (keyUrl() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException("Missing required property keyUrl in model KeyVaultKeyReference"));
        }
        if (sourceVault() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property sourceVault in model KeyVaultKeyReference"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(KeyVaultKeyReference.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("keyUrl", this.keyUrl);
        jsonWriter.writeJsonField("sourceVault", this.sourceVault);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of KeyVaultKeyReference from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of KeyVaultKeyReference if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the KeyVaultKeyReference.
     */
    public static KeyVaultKeyReference fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            KeyVaultKeyReference deserializedKeyVaultKeyReference = new KeyVaultKeyReference();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("keyUrl".equals(fieldName)) {
                    deserializedKeyVaultKeyReference.keyUrl = reader.getString();
                } else if ("sourceVault".equals(fieldName)) {
                    deserializedKeyVaultKeyReference.sourceVault = SubResource.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedKeyVaultKeyReference;
        });
    }
}
