// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Immutable;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;

/**
 * Describes the properties of the last installed patch summary.
 */
@Immutable
public final class LastPatchInstallationSummary implements JsonSerializable<LastPatchInstallationSummary> {
    /*
     * The overall success or failure status of the operation. It remains "InProgress" until the operation completes. At
     * that point it will become "Unknown", "Failed", "Succeeded", or "CompletedWithWarnings."
     */
    private PatchOperationStatus status;

    /*
     * The activity ID of the operation that produced this result. It is used to correlate across CRP and extension
     * logs.
     */
    private String installationActivityId;

    /*
     * Describes whether the operation ran out of time before it completed all its intended actions
     */
    private Boolean maintenanceWindowExceeded;

    /*
     * The number of all available patches but not going to be installed because it didn't match a classification or
     * inclusion list entry.
     */
    private Integer notSelectedPatchCount;

    /*
     * The number of all available patches but excluded explicitly by a customer-specified exclusion list match.
     */
    private Integer excludedPatchCount;

    /*
     * The number of all available patches expected to be installed over the course of the patch installation operation.
     */
    private Integer pendingPatchCount;

    /*
     * The count of patches that successfully installed.
     */
    private Integer installedPatchCount;

    /*
     * The count of patches that failed installation.
     */
    private Integer failedPatchCount;

    /*
     * The UTC timestamp when the operation began.
     */
    private OffsetDateTime startTime;

    /*
     * The UTC timestamp when the operation began.
     */
    private OffsetDateTime lastModifiedTime;

    /*
     * The errors that were encountered during execution of the operation. The details array contains the list of them.
     */
    private ApiError error;

    /**
     * Creates an instance of LastPatchInstallationSummary class.
     */
    public LastPatchInstallationSummary() {
    }

    /**
     * Get the status property: The overall success or failure status of the operation. It remains "InProgress" until
     * the operation completes. At that point it will become "Unknown", "Failed", "Succeeded", or
     * "CompletedWithWarnings.".
     * 
     * @return the status value.
     */
    public PatchOperationStatus status() {
        return this.status;
    }

    /**
     * Get the installationActivityId property: The activity ID of the operation that produced this result. It is used
     * to correlate across CRP and extension logs.
     * 
     * @return the installationActivityId value.
     */
    public String installationActivityId() {
        return this.installationActivityId;
    }

    /**
     * Get the maintenanceWindowExceeded property: Describes whether the operation ran out of time before it completed
     * all its intended actions.
     * 
     * @return the maintenanceWindowExceeded value.
     */
    public Boolean maintenanceWindowExceeded() {
        return this.maintenanceWindowExceeded;
    }

    /**
     * Get the notSelectedPatchCount property: The number of all available patches but not going to be installed because
     * it didn't match a classification or inclusion list entry.
     * 
     * @return the notSelectedPatchCount value.
     */
    public Integer notSelectedPatchCount() {
        return this.notSelectedPatchCount;
    }

    /**
     * Get the excludedPatchCount property: The number of all available patches but excluded explicitly by a
     * customer-specified exclusion list match.
     * 
     * @return the excludedPatchCount value.
     */
    public Integer excludedPatchCount() {
        return this.excludedPatchCount;
    }

    /**
     * Get the pendingPatchCount property: The number of all available patches expected to be installed over the course
     * of the patch installation operation.
     * 
     * @return the pendingPatchCount value.
     */
    public Integer pendingPatchCount() {
        return this.pendingPatchCount;
    }

    /**
     * Get the installedPatchCount property: The count of patches that successfully installed.
     * 
     * @return the installedPatchCount value.
     */
    public Integer installedPatchCount() {
        return this.installedPatchCount;
    }

    /**
     * Get the failedPatchCount property: The count of patches that failed installation.
     * 
     * @return the failedPatchCount value.
     */
    public Integer failedPatchCount() {
        return this.failedPatchCount;
    }

    /**
     * Get the startTime property: The UTC timestamp when the operation began.
     * 
     * @return the startTime value.
     */
    public OffsetDateTime startTime() {
        return this.startTime;
    }

    /**
     * Get the lastModifiedTime property: The UTC timestamp when the operation began.
     * 
     * @return the lastModifiedTime value.
     */
    public OffsetDateTime lastModifiedTime() {
        return this.lastModifiedTime;
    }

    /**
     * Get the error property: The errors that were encountered during execution of the operation. The details array
     * contains the list of them.
     * 
     * @return the error value.
     */
    public ApiError error() {
        return this.error;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (error() != null) {
            error().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of LastPatchInstallationSummary from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of LastPatchInstallationSummary if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the LastPatchInstallationSummary.
     */
    public static LastPatchInstallationSummary fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            LastPatchInstallationSummary deserializedLastPatchInstallationSummary = new LastPatchInstallationSummary();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("status".equals(fieldName)) {
                    deserializedLastPatchInstallationSummary.status
                        = PatchOperationStatus.fromString(reader.getString());
                } else if ("installationActivityId".equals(fieldName)) {
                    deserializedLastPatchInstallationSummary.installationActivityId = reader.getString();
                } else if ("maintenanceWindowExceeded".equals(fieldName)) {
                    deserializedLastPatchInstallationSummary.maintenanceWindowExceeded
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("notSelectedPatchCount".equals(fieldName)) {
                    deserializedLastPatchInstallationSummary.notSelectedPatchCount
                        = reader.getNullable(JsonReader::getInt);
                } else if ("excludedPatchCount".equals(fieldName)) {
                    deserializedLastPatchInstallationSummary.excludedPatchCount
                        = reader.getNullable(JsonReader::getInt);
                } else if ("pendingPatchCount".equals(fieldName)) {
                    deserializedLastPatchInstallationSummary.pendingPatchCount = reader.getNullable(JsonReader::getInt);
                } else if ("installedPatchCount".equals(fieldName)) {
                    deserializedLastPatchInstallationSummary.installedPatchCount
                        = reader.getNullable(JsonReader::getInt);
                } else if ("failedPatchCount".equals(fieldName)) {
                    deserializedLastPatchInstallationSummary.failedPatchCount = reader.getNullable(JsonReader::getInt);
                } else if ("startTime".equals(fieldName)) {
                    deserializedLastPatchInstallationSummary.startTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("lastModifiedTime".equals(fieldName)) {
                    deserializedLastPatchInstallationSummary.lastModifiedTime = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("error".equals(fieldName)) {
                    deserializedLastPatchInstallationSummary.error = ApiError.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedLastPatchInstallationSummary;
        });
    }
}
