// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Specifies the user intent of the proximity placement group.
 */
@Fluent
public final class ProximityPlacementGroupPropertiesIntent
    implements JsonSerializable<ProximityPlacementGroupPropertiesIntent> {
    /*
     * Specifies possible sizes of virtual machines that can be created in the proximity placement group.
     */
    private List<String> vmSizes;

    /**
     * Creates an instance of ProximityPlacementGroupPropertiesIntent class.
     */
    public ProximityPlacementGroupPropertiesIntent() {
    }

    /**
     * Get the vmSizes property: Specifies possible sizes of virtual machines that can be created in the proximity
     * placement group.
     * 
     * @return the vmSizes value.
     */
    public List<String> vmSizes() {
        return this.vmSizes;
    }

    /**
     * Set the vmSizes property: Specifies possible sizes of virtual machines that can be created in the proximity
     * placement group.
     * 
     * @param vmSizes the vmSizes value to set.
     * @return the ProximityPlacementGroupPropertiesIntent object itself.
     */
    public ProximityPlacementGroupPropertiesIntent withVmSizes(List<String> vmSizes) {
        this.vmSizes = vmSizes;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("vmSizes", this.vmSizes, (writer, element) -> writer.writeString(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ProximityPlacementGroupPropertiesIntent from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ProximityPlacementGroupPropertiesIntent if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ProximityPlacementGroupPropertiesIntent.
     */
    public static ProximityPlacementGroupPropertiesIntent fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ProximityPlacementGroupPropertiesIntent deserializedProximityPlacementGroupPropertiesIntent
                = new ProximityPlacementGroupPropertiesIntent();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("vmSizes".equals(fieldName)) {
                    List<String> vmSizes = reader.readArray(reader1 -> reader1.getString());
                    deserializedProximityPlacementGroupPropertiesIntent.vmSizes = vmSizes;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedProximityPlacementGroupPropertiesIntent;
        });
    }
}
