// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The ProxyOnly Resource model definition.
 */
@Immutable
public class ProxyOnlyResource implements JsonSerializable<ProxyOnlyResource> {
    /*
     * Resource Id
     */
    private String id;

    /*
     * Resource name
     */
    private String name;

    /*
     * Resource type
     */
    private String type;

    /**
     * Creates an instance of ProxyOnlyResource class.
     */
    public ProxyOnlyResource() {
    }

    /**
     * Get the id property: Resource Id.
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Set the id property: Resource Id.
     * 
     * @param id the id value to set.
     * @return the ProxyOnlyResource object itself.
     */
    ProxyOnlyResource withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Get the name property: Resource name.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: Resource name.
     * 
     * @param name the name value to set.
     * @return the ProxyOnlyResource object itself.
     */
    ProxyOnlyResource withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the type property: Resource type.
     * 
     * @return the type value.
     */
    public String type() {
        return this.type;
    }

    /**
     * Set the type property: Resource type.
     * 
     * @param type the type value to set.
     * @return the ProxyOnlyResource object itself.
     */
    ProxyOnlyResource withType(String type) {
        this.type = type;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ProxyOnlyResource from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ProxyOnlyResource if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the ProxyOnlyResource.
     */
    public static ProxyOnlyResource fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ProxyOnlyResource deserializedProxyOnlyResource = new ProxyOnlyResource();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedProxyOnlyResource.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedProxyOnlyResource.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedProxyOnlyResource.type = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedProxyOnlyResource;
        });
    }
}
