// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Gallery regional sharing status.
 */
@Fluent
public final class RegionalSharingStatus implements JsonSerializable<RegionalSharingStatus> {
    /*
     * Region name
     */
    private String region;

    /*
     * Gallery sharing state in current region
     */
    private SharingState state;

    /*
     * Details of gallery regional sharing failure.
     */
    private String details;

    /**
     * Creates an instance of RegionalSharingStatus class.
     */
    public RegionalSharingStatus() {
    }

    /**
     * Get the region property: Region name.
     * 
     * @return the region value.
     */
    public String region() {
        return this.region;
    }

    /**
     * Set the region property: Region name.
     * 
     * @param region the region value to set.
     * @return the RegionalSharingStatus object itself.
     */
    public RegionalSharingStatus withRegion(String region) {
        this.region = region;
        return this;
    }

    /**
     * Get the state property: Gallery sharing state in current region.
     * 
     * @return the state value.
     */
    public SharingState state() {
        return this.state;
    }

    /**
     * Get the details property: Details of gallery regional sharing failure.
     * 
     * @return the details value.
     */
    public String details() {
        return this.details;
    }

    /**
     * Set the details property: Details of gallery regional sharing failure.
     * 
     * @param details the details value to set.
     * @return the RegionalSharingStatus object itself.
     */
    public RegionalSharingStatus withDetails(String details) {
        this.details = details;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("region", this.region);
        jsonWriter.writeStringField("details", this.details);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of RegionalSharingStatus from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of RegionalSharingStatus if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the RegionalSharingStatus.
     */
    public static RegionalSharingStatus fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RegionalSharingStatus deserializedRegionalSharingStatus = new RegionalSharingStatus();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("region".equals(fieldName)) {
                    deserializedRegionalSharingStatus.region = reader.getString();
                } else if ("state".equals(fieldName)) {
                    deserializedRegionalSharingStatus.state = SharingState.fromString(reader.getString());
                } else if ("details".equals(fieldName)) {
                    deserializedRegionalSharingStatus.details = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedRegionalSharingStatus;
        });
    }
}
