// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.compute.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The ScheduledEventsAdditionalPublishingTargets model.
 */
@Fluent
public final class ScheduledEventsAdditionalPublishingTargets
    implements JsonSerializable<ScheduledEventsAdditionalPublishingTargets> {
    /*
     * The configuration parameters used while creating eventGridAndResourceGraph Scheduled Event setting.
     */
    private EventGridAndResourceGraph eventGridAndResourceGraph;

    /**
     * Creates an instance of ScheduledEventsAdditionalPublishingTargets class.
     */
    public ScheduledEventsAdditionalPublishingTargets() {
    }

    /**
     * Get the eventGridAndResourceGraph property: The configuration parameters used while creating
     * eventGridAndResourceGraph Scheduled Event setting.
     * 
     * @return the eventGridAndResourceGraph value.
     */
    public EventGridAndResourceGraph eventGridAndResourceGraph() {
        return this.eventGridAndResourceGraph;
    }

    /**
     * Set the eventGridAndResourceGraph property: The configuration parameters used while creating
     * eventGridAndResourceGraph Scheduled Event setting.
     * 
     * @param eventGridAndResourceGraph the eventGridAndResourceGraph value to set.
     * @return the ScheduledEventsAdditionalPublishingTargets object itself.
     */
    public ScheduledEventsAdditionalPublishingTargets
        withEventGridAndResourceGraph(EventGridAndResourceGraph eventGridAndResourceGraph) {
        this.eventGridAndResourceGraph = eventGridAndResourceGraph;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (eventGridAndResourceGraph() != null) {
            eventGridAndResourceGraph().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("eventGridAndResourceGraph", this.eventGridAndResourceGraph);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ScheduledEventsAdditionalPublishingTargets from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ScheduledEventsAdditionalPublishingTargets if the JsonReader was pointing to an instance
     * of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ScheduledEventsAdditionalPublishingTargets.
     */
    public static ScheduledEventsAdditionalPublishingTargets fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ScheduledEventsAdditionalPublishingTargets deserializedScheduledEventsAdditionalPublishingTargets
                = new ScheduledEventsAdditionalPublishingTargets();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("eventGridAndResourceGraph".equals(fieldName)) {
                    deserializedScheduledEventsAdditionalPublishingTargets.eventGridAndResourceGraph
                        = EventGridAndResourceGraph.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedScheduledEventsAdditionalPublishingTargets;
        });
    }
}
